package dev.hipposgrumm.armor_trims.api.item;

import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.chat.*;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.item.*;
import java.util.*;
import java.util.function.Supplier;

//? if forge {
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
//?}

/**
 * Smithing template for use in the Smithing Table GUI
 * @see dev.hipposgrumm.armor_trims.api.base.SmithingTemplateItems Example
 */
public abstract class SmithingTemplate extends Item {
    protected final Supplier<Ingredient> materials;
    protected final ResourceLocation trimIdentifier;
    protected final ITextComponent applyTo;

    /**
     * Smithing Template
     * @param trimIdentifier - A registered Trim Pattern associated with this template. Doesn't have to be an armor trim pattern ({@see ItemUpgradePattern}) and is used for translation.
     * @param materials      - Materials used by the template - passed as a supplier and accessed during runtime.
     * @param applyTo        - Component following "Apply To" in tooltip
     * @param properties     - Item Properties
     */
    public SmithingTemplate(ResourceLocation trimIdentifier, Supplier<Ingredient> materials, ITextComponent applyTo, Item.Properties properties) {
        super(properties);
        this.materials = materials;
        this.trimIdentifier = trimIdentifier;
        this.applyTo = applyTo;
    }

    /**
     * Result of the recipe.
     * @param baseItem     - Base Item (eg Armor)
     * @param templateItem - Smithing Template (this)
     * @param materialItem - Material (trim material)
     * @param level        - World (used to access recipe data and such)
     * @return Resulting Item
     */
    public abstract ItemStack getResult(ItemStack baseItem, ItemStack templateItem, ItemStack materialItem, World level);

    //? if forge {
    /// @apiNote Override {@link #getRecipeRemainder} instead.
    @ApiStatus.Internal
    public final ItemStack getContainerItem(ItemStack item) {
        return getRecipeRemainder(item);
    }

    ///  @apiNote Override {@link #hasCraftingRemainingItem()} instead.
    @ApiStatus.Internal
    public final boolean hasContainerItem(ItemStack stack) {
        return func_77634_r();
    }
    //?}

    public ItemStack getRecipeRemainder(ItemStack item) {
        return item;
    }

    public boolean func_77634_r() {
        return true;
    }

    public Ingredient materials() {
        return materials.get();
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        return /*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("item.armor_trims.smithing_template");
    }

    /// This is where the meat of the code is. It's the trim information of the item. You can change it if you're willing to read it.
    public void func_77624_a(ItemStack itemstack, World level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, level, list, flag);

        if (Minecraft.func_71410_x().field_71441_e == null) return;

        // Name of Smithing Template
        if (trimIdentifier != null) list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("trims." + trimIdentifier.toString().replace(':', '.')).func_240699_a_(TextFormatting.DARK_GRAY));

        // Application
        list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/("").func_240699_a_(TextFormatting.GRAY));
        list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("tooltip.armor_trims.applyTo").func_240699_a_(TextFormatting.GRAY));
        list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ").func_230529_a_(applyTo));

        // Ingredients
        list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("tooltip.armor_trims.ingredients").func_240699_a_(TextFormatting.GRAY));
        ItemStack[] materialItems = materials().func_193365_a();
        if (materialItems.length > 0) {
            if (materialItems.length <= 4 || Screen.func_231173_s_()) { // If fits or shifts.
                int firstIndex = list.size();
                list.addAll(createColoredList(materialItems, flag));
                list.set(firstIndex, /*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ").func_230529_a_(list.get(firstIndex)));
            } else { // Require shift.
                list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ").func_230529_a_(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("tooltip.armor_trims.ingredients.show_more").func_240701_a_(TextFormatting.BLUE, TextFormatting.UNDERLINE)));
            }
        } else { // If none.
            list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ").func_230529_a_(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/("tooltip.armor_trims.ingredients.empty").func_240701_a_(TextFormatting.BLUE, TextFormatting.ITALIC)));
        }
    }

    /// This creates all the items in a list by their color. You can change it if you're willing to read it.
    protected List<IFormattableTextComponent> createColoredList(ItemStack[] list, ITooltipFlag flag) {
        if (list.length >= 3) {
            List<IFormattableTextComponent> itemlist = new ArrayList<>();
            IFormattableTextComponent item = /*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ");
            for (int i = 0; i < list.length; i++) {
                ITextComponent coloredIngredient = colorAndNameIngredient(list[i]);
                if (i == list.length - 1) {
                    item.func_230529_a_(coloredIngredient);
                } else if (i == list.length - 2) {
                    item.func_230529_a_(coloredIngredient).func_230529_a_(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(", & "));
                } else {
                    item.func_230529_a_(coloredIngredient).func_230529_a_(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(", "));
                }
                //? if fabric {
                /*// This is only needed on Fabric because the UI doesn't wraparound like on Forge.
                if (item.getString().length()>=(flag.isAdvanced()?Math.max(30,Registry.ITEM.getKey(this).toString().length()):30)) {
                    itemlist.add(item);
                    item = /^? if >=1.19 {^/Component.literal/^?} else {^//^new TextComponent^//^?}^/("");
                }
                *///?}
            }
            itemlist.add(item);
            itemlist.removeIf(c -> c.getString().equals(" "));
            return itemlist;
        } else if (list.length == 2) {
            IFormattableTextComponent item = /*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/(" ");
            return Collections.singletonList(item.func_230529_a_(colorAndNameIngredient(list[0]))
                    .func_240702_b_(" & ").func_230529_a_(colorAndNameIngredient(list[1])));
        } else if (list.length == 1) {
            return Collections.singletonList(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new StringTextComponent/*?}*/("").func_230529_a_(colorAndNameIngredient(list[0])));
        } else {
            return null;
        }
    }

    /// Create a component from an itemstack. You can change it if you're willing to read it.
    protected static ITextComponent colorAndNameIngredient(ItemStack item) {
        IFormattableTextComponent output = /*? if >=1.19 {*//*Component.translatable*//*?} else {*/new TranslationTextComponent/*?}*/(item.func_77977_a());
        //? if forge {
        ResourceLocation name = ForgeRegistries.ITEMS.getKey(item.func_77973_b());
        //?} else {
        /*ResourceLocation name = Registry.ITEM.getKey(item.getItem());
        *///?}
        ColorPalette color = ColorPaletteManager.get(name);
        if (color == null) color = ColorPalette.DEFAULT; // Yes this can happen for some reason.
        return output.func_240703_c_(output.func_150256_b().func_240718_a_(color.textColor()));
    }
}
