package dev.hipposgrumm.armor_trims.compat.jei;

import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.jei.ArmortrimsRecipe;
import dev.hipposgrumm.armor_trims.api.item.ArmorTrimSmithingTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

//? if forge {
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
//?}

public class ItemTrimRecipeMaker {
    public static List<ArmortrimsRecipe> getTrimmingRecipes(/*? if forge {*/IIngredientManager ingredientManager/*?}*/) {
        // Creating a stream this way preserves the original order, while using values().stream() does not.
        List<ItemStack> armorItems = StreamSupport.stream(
                //? if forge {
                ForgeRegistries.ITEMS.spliterator(),
                //?} else {
                /*Registry.ITEM.spliterator(),
                *///?}
                false).filter(
                item -> item instanceof ArmorItem
        ).map(Item::func_190903_i).filter(item ->
                !item/*? if <1.18.2 {*/.func_77973_b()/*?}*/.func_206844_a(Armortrims.NON_TRIMMABLE_ITEMS_TAG)
        ).collect(Collectors.toList());

        //? if forge {
        Stream<Item> itemstream = ingredientManager
                .getAllIngredients(VanillaTypes./*? if >=1.17 {*//*ITEM_STACK*//*?} else {*/ITEM/*?}*/)
                .stream().map(ItemStack::func_77973_b);
        //?} else {
        /*Stream<Item> itemstream = StreamSupport
                .stream(Registry.ITEM.spliterator(), false);
        *///?}
        Ingredient materials = Ingredient.func_199805_a(Armortrims.TRIM_MATERIALS_TAG);
        if (materials.func_193365_a().length == 0) return Collections.emptyList();
        return itemstream.flatMap(templateItem -> {
            List<ArmortrimsRecipe> recipes = new ArrayList<>();
            if (templateItem instanceof ArmorTrimSmithingTemplate) {
                Ingredient template = Ingredient.func_199804_a(templateItem);
                for (ItemStack armorItem : armorItems) {
                    recipes.add(new ArmortrimsRecipe(
                            Ingredient.func_193369_a(armorItem),
                            template,
                            materials,
                            //? if >=1.17 {
                            /*ItemStack.EMPTY
                            *///?} else {
                            armorItem
                            //?}
                    ));
                }
            }
            return recipes.stream();
        }).collect(Collectors.toList());
    }
}