package dev.hipposgrumm.armor_trims.compat.jei;

import dev.hipposgrumm.armor_trims.api.item.UpgradeSmithingTemplate;
import dev.hipposgrumm.armor_trims.api.jei.ArmortrimsRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraft.world.item.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

//? if forge {
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraftforge.registries.ForgeRegistries;
//?}

public class ItemUpgradeRecipeMaker {
    public static List<ArmortrimsRecipe> getUpgradingRecipes(/*? if forge {*/IIngredientManager ingredientManager/*?}*/) {
        // We need level.
        World level = Minecraft.func_71410_x().field_71441_e;
        if (level == null) return Collections.emptyList();

        // Creating a stream this way preserves the original order, while using values().stream() does not.
        List<UpgradeSmithingTemplate> upgradeTemplates = StreamSupport.stream(
                //? if forge {
                ForgeRegistries.ITEMS.spliterator(),
                //?} else {
                /*Registry.ITEM.spliterator(),
                *///?}
                false).filter(
                item -> item instanceof UpgradeSmithingTemplate
        ).map(item -> (UpgradeSmithingTemplate) item).collect(Collectors.toList());

        //? if forge {
        Stream<ItemStack> itemstream = ingredientManager
                .getAllIngredients(VanillaTypes./*? if >=1.17 {*//*ITEM_STACK*//*?} else {*/ITEM/*?}*/).stream();
        //?} else {
        /*Stream<ItemStack> itemstream = StreamSupport
                .stream(Registry.ITEM.spliterator(), false)
                .map(Item::getDefaultInstance);
        *///?}
        return itemstream.flatMap(baseItem -> {
            List<ArmortrimsRecipe> recipes = new ArrayList<>();
            for (UpgradeSmithingTemplate templateItem : upgradeTemplates) {
                ItemStack upgradedItem = getUpgradedItem(level, baseItem.func_77946_l(), templateItem);
                if (upgradedItem != null && !upgradedItem.func_190926_b()) {
                    recipes.add(new ArmortrimsRecipe(
                            Ingredient.func_193369_a(baseItem),
                            Ingredient.func_199804_a(templateItem),
                            templateItem.materials(),
                            upgradedItem
                    ));
                }
            }
            return recipes.stream();
        }).collect(Collectors.toList());
    }

    public static ItemStack getUpgradedItem(World level, ItemStack baseItem, UpgradeSmithingTemplate templateItem) {
        ItemStack[] items = templateItem.materials().func_193365_a();
        if (items.length==0) return ItemStack.field_190927_a;

        return templateItem.getResult(baseItem, templateItem.func_190903_i(), items[0], level);
    }
}