package dev.hipposgrumm.armor_trims.gui;

import java.util.List;

import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.item.ArmorTrimSmithingTemplate;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.item.SmithingTemplate;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.inventory.*;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.ApiStatus;

public class SmithingMenuNew extends Container {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 3;
    public static final int MATERIAL_SLOT = 2;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;

    protected final CraftResultInventory resultSlots = new CraftResultInventory();
    protected final IInventory inputSlots = new Inventory(3) {
        public void func_70296_d() {
            super.func_70296_d();
            SmithingMenuNew.this.func_75130_a(this);
        }
    };
    protected final IWorldPosCallable access;
    protected final PlayerEntity player;
    private final World level;

    public SmithingMenuNew(int id, PlayerInventory inventory, IWorldPosCallable access, PlayerEntity player) {
        super(Armortrims.SMITHING_MENU_NEW.get(), id);
        this.level = inventory.field_70458_d.field_70170_p;
        this.access = access;
        this.player = inventory.field_70458_d;
        this.func_75146_a(new Slot(this.inputSlots, INPUT_SLOT, 8, 48));
        this.func_75146_a(new Slot(this.inputSlots, ADDITIONAL_SLOT, 8, 66) {
            @Override
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of(PlayerContainer.field_226615_c_, new ResourceLocation(Armortrims.MODID,"item/empty_slot_smithing_template_armor_trim"));
            }

            @Override
            public boolean func_75214_a(ItemStack item) {
                return item.func_77973_b() instanceof SmithingTemplate;
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, MATERIAL_SLOT, 52, 48));
        this.func_75146_a(new Slot(this.resultSlots, RESULT_SLOT, 106, 48) {
            public boolean func_75214_a(ItemStack item) {
                    return false;
                }

            public boolean func_82869_a(PlayerEntity player) {
                return this.func_75216_d();
            }

            public /*? if >=1.18 {*//*void*//*?} else {*/ItemStack/*?}*/ func_190901_a(PlayerEntity player, ItemStack item) {
                SmithingMenuNew.this.onTake(player, item);
                //? if <1.18
                return item;
            }
        });
        addPlayerInventory(inventory);
    }

    //? if forge {
    /// @apiNote Used by Forge
    @ApiStatus.Internal
    public SmithingMenuNew(int i, PlayerInventory inventory, PacketBuffer friendlyByteBuf) {
        this(i, inventory, IWorldPosCallable.field_221489_a, inventory.field_70458_d);
    }
    //?}

    public SmithingMenuNew(int i, PlayerInventory inventory) {
        this(i, inventory, IWorldPosCallable.field_221489_a, inventory.field_70458_d);
    }

    protected boolean isValidBlock(BlockState state) {
        return state.func_203425_a(Blocks.field_222429_lR);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.access.func_221485_a((level, pos) -> this.isValidBlock(level.func_180495_p(pos)) && player.func_70092_e((double) pos.func_177958_n() + 0.5D, (double) pos.func_177956_o() + 0.5D, (double) pos.func_177952_p() + 0.5D) <= 64.0D, true);
    }

    protected void onTake(PlayerEntity player, ItemStack itemStack) {
        itemStack.func_77980_a(player.field_70170_p, player, itemStack.func_190916_E());
        this.resultSlots.func_201560_d(player);
        this.shrinkStackInSlot(INPUT_SLOT);
        this.shrinkStackInSlot(MATERIAL_SLOT);
        handleAdvancements(itemStack); // Check the advancement before shrinking the stack.
        if (!(Config.dontConsumeSmithingTemplates && this.field_75151_b.get(ADDITIONAL_SLOT).func_75211_c().func_77973_b() instanceof SmithingTemplate)) {
            this.shrinkStackInSlot(ADDITIONAL_SLOT);
        }
        this.access.func_221486_a((level, pos) -> level.func_217379_c(1044, pos, 0));
    }

    private void handleAdvancements(ItemStack itemStack) {
        if (this.inputSlots.func_70301_a(ADDITIONAL_SLOT).func_77973_b() instanceof ArmorTrimSmithingTemplate && this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity) this.player;
            Advancement advancement = player.func_71121_q().func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation(Armortrims.MODID,"trim_with_any_armor_pattern"));
            Advancement advancementChallenge = player.func_71121_q().func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation(Armortrims.MODID,"trim_with_all_armor_patterns"));
            if (advancement != null && !player.func_192039_O().func_192747_a(advancement).func_192105_a()) {
                player.func_192039_O().func_192750_a(advancement, "code_triggered");
            }
            if (advancementChallenge != null) {
                ResourceLocation trim = TrimGetter.getPattern(itemStack);
                if (trim != null) {
                    CriterionProgress criteria = player.func_192039_O().func_192747_a(advancementChallenge).func_192106_c("code_triggered_" + trim.func_110623_a());
                    if (criteria != null && !criteria.func_192151_a()) {
                        player.func_192039_O().func_192750_a(advancementChallenge, "code_triggered_" + trim.func_110623_a());
                    }
                }
            }
        }
    }

    private void shrinkStackInSlot(int slot) {
        ItemStack itemstack = this.inputSlots.func_70301_a(slot);
        itemstack.func_190918_g(1);
        this.inputSlots.func_70299_a(slot, itemstack);
    }

    public void createResult() {
        ItemStack baseItem = this.inputSlots.func_70301_a(INPUT_SLOT);
        ItemStack templateItem = this.inputSlots.func_70301_a(ADDITIONAL_SLOT);
        ItemStack materialItem = this.inputSlots.func_70301_a(MATERIAL_SLOT);
        if (templateItem.func_77973_b() instanceof SmithingTemplate) {
            SmithingTemplate smithingTemplate = (SmithingTemplate) templateItem.func_77973_b();
            this.resultSlots.func_70299_a(0, smithingTemplate.getResult(baseItem, templateItem, materialItem, level));
        } else {
            IInventory vanillaRecipeContainer = new Inventory(2);
            vanillaRecipeContainer.func_70299_a(0, baseItem);
            vanillaRecipeContainer.func_70299_a(1, materialItem);

            List<SmithingRecipe> list = this.level.func_199532_z().func_215370_b(IRecipeType.field_234827_g_, vanillaRecipeContainer, this.level);

            if (list.isEmpty() || (
                    Config.disableVanillaNetheriteUpgrade && materialItem/*? if <1.18.2 {*/.func_77973_b()/*?}*/.func_206844_a(ArmortrimsInternalUtils.NETHERITE_TAG)) // Special Override
            ) {
                this.resultSlots.func_70299_a(0, ItemStack.field_190927_a);
            } else {
                SmithingRecipe selectedRecipe = list.get(0);
                ItemStack itemstack = selectedRecipe.func_77572_b(vanillaRecipeContainer);
                this.resultSlots.func_193056_a(selectedRecipe);
                this.resultSlots.func_70299_a(0, itemstack);
            }
        }
    }

    public void func_75130_a(IInventory container) {
        super.func_75130_a(container);
        if (container == this.inputSlots) {
            this.createResult();
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.access.func_221486_a((level, pos) -> {
            this.func_193327_a(player, /*? if <1.17 {*/level,/*?}*/ this.inputSlots);
        });
    }

    protected int determineSlotToMove(ItemStack item) {
        IInventory crafting = this.inputSlots;
        SmithingTemplate template = null;
        {
            Item t = crafting.func_70301_a(ADDITIONAL_SLOT).func_77973_b();
            if (t instanceof SmithingTemplate) {
                template = (SmithingTemplate) t;
            }
        }
        if (item.func_77973_b() instanceof SmithingTemplate) {
            return ADDITIONAL_SLOT;
        } else if (template != null && template.materials().test(item)) {
            return MATERIAL_SLOT;
        } else if (crafting.func_70301_a(INPUT_SLOT).func_190926_b()) {
            return INPUT_SLOT;
        } else {
            return MATERIAL_SLOT;
        }
    }

    public boolean func_94530_a(ItemStack item, Slot slotId) {
        return slotId.field_75224_c != this.resultSlots && super.func_94530_a(item, slotId);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotId == RESULT_SLOT) {
                if (!this.func_75135_a(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (slotId != INPUT_SLOT && slotId != ADDITIONAL_SLOT && slotId != MATERIAL_SLOT) {
                if (slotId >= INV_SLOT_START && slotId < USE_ROW_SLOT_END) {
                    int i = determineSlotToMove(itemstack1);
                    if (!this.func_75135_a(itemstack1, i, inputSlots.func_70302_i_(), false)) {
                        return ItemStack.field_190927_a;
                    }
                }
            } else if (!this.func_75135_a(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    private void addPlayerInventory(PlayerInventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.func_75146_a(new Slot(playerInventory, l + i * 9 + 9, 8 + l * 18, 97 + i * 18));
            }
        }
        addPlayerHotbar(playerInventory);
    }

    private void addPlayerHotbar(PlayerInventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(playerInventory, i, 8 + i * 18, 155));
        }
    }
}
