package dev.hipposgrumm.armor_trims.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.item.SmithingTemplate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.client.gui.screen.inventory.InventoryScreen.func_228187_a_;

public class SmithingScreenNew extends ContainerScreen<SmithingMenuNew> implements IContainerListener {
    public static final ResourceLocation GUI_SMITHING = new ResourceLocation(Armortrims.MODID, "textures/gui/container/smithing_new.png");

    private LivingEntity preview;

    public SmithingScreenNew(SmithingMenuNew menu, PlayerInventory inventory, ITextComponent title) {
        super(menu, inventory, title);
        this.field_238742_p_ = 60;
        this.field_238743_q_ = 18;
        this.field_147000_g = 179;
        this.field_238745_s_ = this.field_147000_g - 93;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_147002_h.func_75132_a(this);
        this.preview = createPreview();
    }

    public static LivingEntity createPreview() {
        if (Minecraft.func_71410_x().field_71441_e == null) return null;
        LivingEntity preview = new ArmorStandEntity(Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        preview.func_189654_d(true);
        CompoundNBT extraNBT = new CompoundNBT();
        extraNBT.func_74757_a("ShowArms", true);
        extraNBT.func_74757_a("NoBasePlate", true);
        preview.func_70020_e(extraNBT);
        return preview;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_147002_h.func_82847_b(this);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.func_230459_a_(poseStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack poseStack, float delta, int mouseX, int mouseY) {
        //? if >=1.17 {
        /*RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.setShaderTexture(0, SmithingScreenNew.this.GUI_SMITHING);
        *///?} else {
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_SMITHING);
        //?}
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(poseStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (determineCraftingIncomplete()) {
            this.func_238474_b_(poseStack, x + 72, y + 45, this.field_146999_f, 0, 28, 21);
        }
        func_228187_a_(x + 145, y + 75, 30, 50, -50, preview);
    }

    private boolean determineCraftingIncomplete() {
        if (this.field_147002_h.func_75139_a(0).func_75216_d() && !this.field_147002_h.func_75139_a(1).func_75216_d()) {
            return true;
        } else if (!this.field_147002_h.func_75139_a(0).func_75216_d() && this.field_147002_h.func_75139_a(1).func_75216_d()) {
            return true;
        } else if (this.field_147002_h.func_75139_a(1).func_75211_c().func_77973_b() instanceof SmithingTemplate && (!this.field_147002_h.func_75139_a(0).func_75216_d() || !this.field_147002_h.func_75139_a(2).func_75216_d())) {
            return true;
        } else if (this.field_147002_h.func_75139_a(0).func_75216_d() && this.field_147002_h.func_75139_a(1).func_75216_d() && !this.field_147002_h.func_75139_a(3).func_75216_d()) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        if (preview != null) {
            preview.func_70106_y(/*? if >=1.18 {*//*Entity.RemovalReason.DISCARDED*//*?}*/);
        }
    }

    @Override
    //? if >=1.18 {
    /*public void dataChanged(AbstractContainerMenu menu, int index, int value) {}
    *///?} else {
    public void func_71112_a(Container menu, int index, int value) {}

    @Override
    public void func_71110_a(Container menu, NonNullList<ItemStack> nonNullList) {}
    //?}

    @Override
    public void func_71111_a(Container menu, int index, ItemStack stack) {
        if (index==3) updatePreview(this.preview,stack);
    }

    private static final EquipmentSlotType[] previewSlots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET, EquipmentSlotType.OFFHAND};
    public static void updatePreview(@Nullable LivingEntity preview, ItemStack item) {
        if (preview != null) {
            CompoundNBT data = new CompoundNBT();
            for (EquipmentSlotType equipment : previewSlots) {
                preview.func_184201_a(equipment, ItemStack.field_190927_a);
            }

            if (!item.func_190926_b()) {
                EquipmentSlotType slot = /*? if >=1.17 {*//*LivingEntity*//*?} else {*/MobEntity/*?}*/.func_184640_d(item);
                if (slot == EquipmentSlotType.MAINHAND) slot = EquipmentSlotType.OFFHAND;
                data.func_218657_a("LeftArm", new Rotations(slot == EquipmentSlotType.OFFHAND ? -50.0f : 0.0f, 50.0f, 0.0f).func_179414_a());
                preview.func_184201_a(slot, item);
            }

            data.func_74757_a("ShowArms", true);
            data.func_74757_a("NoBasePlate", true);
            preview.func_70020_e(data);
        }
    }
}