package dev.hipposgrumm.armor_trims.loot;

//? if forge {
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
//? if <1.19
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

/// Tutorial by Kaupenjoe
public class EntityLootModifier extends LootModifier {
    private final Item addition;
    private final int count;
    private final float chance;

    protected EntityLootModifier(ILootCondition[] conditionsIn, Item addition, int count, float chance) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
        this.chance = chance/100f;
    }

    @Nonnull
    @Override
    protected /*? if >=1.19 {*//*ObjectArrayList<ItemStack> doApply(ObjectArrayList*//*?} else {*/List<ItemStack> doApply(List/*?}*/<ItemStack> generatedLoot, LootContext context) {
        if (ThreadLocalRandom.current().nextFloat() <= chance) {
            generatedLoot.add(new ItemStack(addition, count));
        }
        return generatedLoot;
    }

    //? if >=1.19 {
    /*public static final Supplier<Codec<EntityLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> codecStart(inst).and(inst.group(
            ForgeRegistries.ITEMS.getCodec().fieldOf("addition").forGetter(m -> m.addition),
            Codec.INT.fieldOf("count").forGetter(m -> m.count),
            Codec.FLOAT.fieldOf("chance").forGetter(m -> m.chance)
    )).apply(inst, EntityLootModifier::new)));
    @Override
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
    *///?} else {
    public static class Serializer extends GlobalLootModifierSerializer<EntityLootModifier> {
         @Override
         public EntityLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
             Item addition = ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h(object, "addition")));
             int count = JSONUtils.func_151203_m(object, "count");
             float chance = JSONUtils.func_151217_k(object, "chance");
             return new EntityLootModifier(conditionsIn, addition, count, chance);
         }

         @Override
         public JsonObject write(EntityLootModifier instance) {
             JsonObject json = makeConditions(instance.conditions);
             json.addProperty("addition", ForgeRegistries.ITEMS.getKey(instance.addition).toString());
             json.addProperty("count", instance.count);
             json.addProperty("chance", instance.chance);
             return json;
         }
    }
    //?}
}
//?}