package dev.hipposgrumm.armor_trims.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.hipposgrumm.armor_trims.api.TrimRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.TrimPattern;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.ArmorTrimPattern;
import dev.hipposgrumm.armor_trims.util.TrimTextureManager;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(BipedArmorLayer.class)
public abstract class MixinHumanoidArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>> extends LayerRenderer<T, M> {
    public MixinHumanoidArmorLayer(IEntityRenderer<T, M> layer) {
        super(layer);
    }

    @Inject(method = "renderArmorPiece", at = @At("TAIL"))
    private void armor_trims$applyTrimOverlay(MatrixStack poseStack, IRenderTypeBuffer buffer, T entity, EquipmentSlotType slot, int i, A model, CallbackInfo ci) {
        ItemStack stack = entity.func_184582_a(slot);
        // Check for trim.
        if (!stack.func_190926_b() && TrimGetter.isTrimmed(stack)) {
            // Make sure it should show.
            if (slot == EquipmentSlotType.HEAD || stack.func_77973_b() instanceof ArmorItem) {
                TrimPattern pattern = TrimRegistry.getTrim(TrimGetter.getPattern(stack));
                // Make sure the trim is an armor trim.
                if (pattern instanceof ArmorTrimPattern) {
                    ArmorTrimPattern armorPattern = (ArmorTrimPattern) pattern;
                    
                    // Define variables.
                    ResourceLocation material = TrimGetter.getMaterial(stack);
                    ResourceLocation location = slot == EquipmentSlotType.LEGS ? armorPattern.getLayer1() : armorPattern.getLayer0();
                    ResourceLocation coloredLocation = TrimTextureManager.get(location, material);
                    if (coloredLocation == null) return;
                    IVertexBuilder shader = ItemRenderer.func_239386_a_(buffer, RenderType.func_239263_a_(coloredLocation), false, stack.func_77962_s());

                    // TrimTextureManager returns the initial location if there is no palette variation for that pattern and material.
                    if (coloredLocation == location) {
                        // Tint in real time.
                        ColorPalette palette = ColorPaletteManager.get(material);
                        if (palette != null) {
                            int color = palette.get(ColorPalette.PALETTE_COLORS[0]);
                            model.func_225598_a_(poseStack, shader, i, OverlayTexture.field_229196_a_, (color >> 16 & 0xFF)/255f, (color >> 8 & 0xFF)/255f, (color & 0xFF)/255f, (color >> 24 & 0xFF)/255f); // Extract R, G, B, A from color.
                            return;
                        }
                    }
                    // Render pre-colored.
                    model.func_225598_a_(poseStack, shader, i, OverlayTexture.field_229196_a_, 1.0F, 1.0F, 1.0F, 1.0F);
                }
            }
        }
    }
}
