package dev.hipposgrumm.armor_trims.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.gui.SmithingMenuNew;
import net.minecraft.block.BlockState;
import net.minecraft.block.SmithingTableBlock;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.inventory.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(SmithingTableBlock.class)
public class MixinSmithingTable {
    @Shadow @Final private static ITextComponent CONTAINER_TITLE;

    @WrapOperation(method = "use", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getMenuProvider(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/MenuProvider;"))
    public INamedContainerProvider armor_trims$openNewGUI(BlockState state, World level, BlockPos pos, Operation<INamedContainerProvider> original) {
        if (Config.enableNewSmithingGUI) {
            return new SimpleNamedContainerProvider((id, inventory, player) -> new SmithingMenuNew(id, inventory, IWorldPosCallable.func_221488_a(level, pos), player), CONTAINER_TITLE);
        }
        return original.call(state, level, pos);
    }
}