package dev.hipposgrumm.armor_trims.recipes;

import com.google.gson.JsonObject;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.item.*;

public class UntrimmingSpecialRecipe extends SpecialRecipe {
    public static final ResourceLocation ID = new ResourceLocation(Armortrims.MODID,"crafting_special_untrimming");

    public UntrimmingSpecialRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(CraftingInventory crafting, World level) {
        boolean hasTrimmedItem = false;
        boolean hasShearsItem = false;

        for(int i = 0; i < crafting.func_70302_i_(); i++) {
            ItemStack item = crafting.func_70301_a(i);
            if (!item.func_190926_b()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(item) ) {
                    hasTrimmedItem = true;
                } else if (item/*? if <1.18.2 {*/.func_77973_b()/*?}*/.func_206844_a(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    hasShearsItem = true;
                }
            }
        }

        return hasTrimmedItem && hasShearsItem;
    }

    public ItemStack assemble(CraftingInventory crafting) {
        ItemStack trimmedItem = ItemStack.field_190927_a;
        ItemStack shearsItem = ItemStack.field_190927_a;

        for(int i = 0; i < crafting.func_70302_i_(); ++i) {
            ItemStack testTrimmedItem = crafting.func_70301_a(i);
            if (!testTrimmedItem.func_190926_b() && TrimGetter.isTrimmed(testTrimmedItem)) {
                trimmedItem = testTrimmedItem;
                break;
            }
        }

        for(int i = 0; i < crafting.func_70302_i_(); ++i) {
            ItemStack testShearsItem = crafting.func_70301_a(i);
            if (!testShearsItem.func_190926_b() && testShearsItem/*? if <1.18.2 {*/.func_77973_b()/*?}*/.func_206844_a(ArmortrimsInternalUtils.SHEARS_TAG)) {
                shearsItem = testShearsItem;
                break;
            }
        }

        ItemStack finalItem = trimmedItem.func_77946_l();
        TrimGetter.clearTrim(finalItem);
        if (shearsItem.func_77952_i()>=shearsItem.func_77958_k()) shearsItem.func_190918_g(1);

        return !Config.enableUntrimming?ItemStack.field_190927_a:finalItem;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory crafting) {
        NonNullList<ItemStack> nonnulllist = NonNullList.func_191197_a(crafting.func_70302_i_(), ItemStack.field_190927_a);
        boolean hasTrimmedItem = false;

        for(int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = crafting.func_70301_a(i);
            if (!itemstack.func_190926_b()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(itemstack)) {
                    hasTrimmedItem = true;
                } else if (itemstack/*? if <1.18.2 {*/.func_77973_b()/*?}*/.func_206844_a(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    ItemStack shearsItem = itemstack.func_77946_l();
                    shearsItem.func_196085_b(itemstack.func_77952_i()-1);
                    nonnulllist.set(i, shearsItem);
                }
            }
        }

        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return (width > 0 && height > 0) && (width > 1 || height > 1); // Two items.
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Armortrims.UNTRIMMING_RECIPE.get();
    }

    public static class Serializer implements IRecipeSerializer<UntrimmingSpecialRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public UntrimmingSpecialRecipe func_199425_a_(ResourceLocation id, JsonObject json) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public UntrimmingSpecialRecipe func_199426_a_(ResourceLocation id, PacketBuffer buf) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public void toNetwork(PacketBuffer buf, UntrimmingSpecialRecipe recipe) {}

        //? if forge {
        public IRecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        public ResourceLocation getRegistryName() {
            return UntrimmingSpecialRecipe.ID;
        }

        public Class<IRecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(IRecipeSerializer.class);
        }

        @SuppressWarnings("unchecked") // Need this wrapper, because generics.
        private static <G> Class<G> castClass(Class<?> cls) {
            return (Class<G>)cls;
        }
        //?}
    }
}