package dev.hipposgrumm.armor_trims.api.base.item;

import dev.hipposgrumm.armor_trims.api.item.UpgradeSmithingTemplate;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
//? if >=1.19 {
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
//?} else {
/*import net.minecraft.network.chat.TranslatableComponent;
*///?}
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;

//? if forge {
import net.minecraftforge.registries.ForgeRegistries;
//?}

import java.lang.ref.WeakReference;
import java.util.List;

public class NetheriteUpgradeSmithingTemplate extends UpgradeSmithingTemplate {
    public NetheriteUpgradeSmithingTemplate(ResourceLocation trimIdentifier, Properties properties) {
        super(trimIdentifier, () -> Ingredient.m_204132_(ArmortrimsInternalUtils.NETHERITE_TAG), /*? if >=1.19 {*/DiamondColored.create/*?} else {*//*new DiamondColored*//*?}*/("tooltip.armor_trims.applyTo.diamond_equipment"), properties);
    }

    public ItemStack getResult(ItemStack baseItem, ItemStack templateItem, ItemStack materialItem, Level level) {
        // Make sure the material matches.
        if (!materials().test(materialItem)) return ItemStack.f_41583_;

        Container vanillaRecipeContainer = new SimpleContainer(2);
        vanillaRecipeContainer.m_6836_(0, baseItem);
        vanillaRecipeContainer.m_6836_(1, materialItem);

        List<UpgradeRecipe> list = level.m_7465_().m_44056_(RecipeType.f_44113_, vanillaRecipeContainer, level);
        if (list.isEmpty()) return ItemStack.f_41583_;

        UpgradeRecipe selectedRecipe = list.get(0);
        return selectedRecipe.m_5874_(vanillaRecipeContainer);
    }

    /// This class allows for the diamond color of the tooltip. A bit unnecessary, but it was fun to write so who cares.
    private static final class DiamondColored /*? if >=1.19 {*/implements Component/*?} else {*//*extends TranslatableComponent*//*?}*/ {
        private static WeakReference<ColorPalette> diamondColor = new WeakReference<>(null);
        //? if >=1.19
        private final MutableComponent base;

        public DiamondColored(String key) {
            //? if >=1.19 {
            base = Component.m_237115_(key);
            //?} else {
            /*super(key);
            *///?}
        }

        //? if >=1.19 {
        public static MutableComponent create(String key) {
            return Component.m_237119_().m_7220_(new DiamondColored(key));
        }
        //?}

        public Style m_7383_() {
            // Get the original Style.
            Style style = /*? if >=1.19 {*/base/*?} else {*//*super*//*?}*/.m_7383_();
            // Make sure a level is loaded before trying to do tag stuff.
            if (Minecraft.m_91087_().f_91073_ == null) return style;
            // Get the color.
            // This color is a WeakReference, meaning this class won't stop it from getting munched by the Garbage Collector.
            ColorPalette color = diamondColor.get();
            // If the color doesn't exist (maybe it got munched by the Garbage Collector).
            if (color == null || color.discarded()) {
                // We need diamond.
                //? if forge {
                ResourceLocation diamond = ForgeRegistries.ITEMS.getKey(Items.f_42415_);
                //?} else {
                /*ResourceLocation diamond = Registry.ITEM.getKey(Items.DIAMOND);
                *///?}

                // Get the color.
                color = ColorPaletteManager.get(diamond);
                if (color == null) return style; // It is very possible for it to not be there.

                // Set the color again. Again, there is nothing here stopping it from being munched by the Garbage Collector.
                // But don't set the color if it's the default one.
                if (color != ColorPalette.DEFAULT) diamondColor = new WeakReference<>(color);
            }
            return style.m_131148_(color.textColor());
        }

        //? if >=1.19 {
        @Override
        public ComponentContents m_214077_() {
            return base.m_214077_();
        }

        @Override
        public List<Component> m_7360_() {
            return base.m_7360_();
        }

        @Override
        public FormattedCharSequence m_7532_() {
            return base.m_7532_();
        }
        //?}
    }
}
