package dev.hipposgrumm.armor_trims.compat.jei;

import dev.hipposgrumm.armor_trims.api.item.UpgradeSmithingTemplate;
import dev.hipposgrumm.armor_trims.api.jei.ArmortrimsRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

//? if forge {
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraftforge.registries.ForgeRegistries;
//?}

public class ItemUpgradeRecipeMaker {
    public static List<ArmortrimsRecipe> getUpgradingRecipes(/*? if forge {*/IIngredientManager ingredientManager/*?}*/) {
        // We need level.
        Level level = Minecraft.m_91087_().f_91073_;
        if (level == null) return Collections.emptyList();

        // Creating a stream this way preserves the original order, while using values().stream() does not.
        List<UpgradeSmithingTemplate> upgradeTemplates = StreamSupport.stream(
                //? if forge {
                ForgeRegistries.ITEMS.spliterator(),
                //?} else {
                /*Registry.ITEM.spliterator(),
                *///?}
                false).filter(
                item -> item instanceof UpgradeSmithingTemplate
        ).map(item -> (UpgradeSmithingTemplate) item).collect(Collectors.toList());

        //? if forge {
        Stream<ItemStack> itemstream = ingredientManager
                .getAllIngredients(VanillaTypes./*? if >=1.17 {*/ITEM_STACK/*?} else {*//*ITEM*//*?}*/).stream();
        //?} else {
        /*Stream<ItemStack> itemstream = StreamSupport
                .stream(Registry.ITEM.spliterator(), false)
                .map(Item::getDefaultInstance);
        *///?}
        return itemstream.flatMap(baseItem -> {
            List<ArmortrimsRecipe> recipes = new ArrayList<>();
            for (UpgradeSmithingTemplate templateItem : upgradeTemplates) {
                ItemStack upgradedItem = getUpgradedItem(level, baseItem.m_41777_(), templateItem);
                if (upgradedItem != null && !upgradedItem.m_41619_()) {
                    recipes.add(new ArmortrimsRecipe(
                            Ingredient.m_43927_(baseItem),
                            Ingredient.m_43929_(templateItem),
                            templateItem.materials(),
                            upgradedItem
                    ));
                }
            }
            return recipes.stream();
        }).collect(Collectors.toList());
    }

    public static ItemStack getUpgradedItem(Level level, ItemStack baseItem, UpgradeSmithingTemplate templateItem) {
        ItemStack[] items = templateItem.materials().m_43908_();
        if (items.length==0) return ItemStack.f_41583_;

        return templateItem.getResult(baseItem, templateItem.m_7968_(), items[0], level);
    }
}