package dev.hipposgrumm.armor_trims.gui;

import java.util.List;

import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.item.ArmorTrimSmithingTemplate;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.item.SmithingTemplate;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.*;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

public class SmithingMenuNew extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 3;
    public static final int MATERIAL_SLOT = 2;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;

    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(3) {
        public void m_6596_() {
            super.m_6596_();
            SmithingMenuNew.this.m_6199_(this);
        }
    };
    protected final ContainerLevelAccess access;
    protected final Player player;
    private final Level level;

    public SmithingMenuNew(int id, Inventory inventory, ContainerLevelAccess access, Player player) {
        super(Armortrims.SMITHING_MENU_NEW.get(), id);
        this.level = inventory.f_35978_.f_19853_;
        this.access = access;
        this.player = inventory.f_35978_;
        this.m_38897_(new Slot(this.inputSlots, INPUT_SLOT, 8, 48));
        this.m_38897_(new Slot(this.inputSlots, ADDITIONAL_SLOT, 8, 66) {
            @Override
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of(InventoryMenu.f_39692_, new ResourceLocation(Armortrims.MODID,"item/empty_slot_smithing_template_armor_trim"));
            }

            @Override
            public boolean m_5857_(ItemStack item) {
                return item.m_41720_() instanceof SmithingTemplate;
            }
        });
        this.m_38897_(new Slot(this.inputSlots, MATERIAL_SLOT, 52, 48));
        this.m_38897_(new Slot(this.resultSlots, RESULT_SLOT, 106, 48) {
            public boolean m_5857_(ItemStack item) {
                    return false;
                }

            public boolean m_8010_(Player player) {
                return this.m_6657_();
            }

            public /*? if >=1.18 {*/void/*?} else {*//*ItemStack*//*?}*/ m_142406_(Player player, ItemStack item) {
                SmithingMenuNew.this.onTake(player, item);
                //? if <1.18
                /*return item;*/
            }
        });
        addPlayerInventory(inventory);
    }

    //? if forge {
    /// @apiNote Used by Forge
    @ApiStatus.Internal
    public SmithingMenuNew(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory, ContainerLevelAccess.f_39287_, inventory.f_35978_);
    }
    //?}

    public SmithingMenuNew(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.f_39287_, inventory.f_35978_);
    }

    protected boolean isValidBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50625_);
    }

    public boolean m_6875_(Player player) {
        return this.access.m_39299_((level, pos) -> this.isValidBlock(level.m_8055_(pos)) && player.m_20275_((double) pos.m_123341_() + 0.5D, (double) pos.m_123342_() + 0.5D, (double) pos.m_123343_() + 0.5D) <= 64.0D, true);
    }

    protected void onTake(Player player, ItemStack itemStack) {
        itemStack.m_41678_(player.f_19853_, player, itemStack.m_41613_());
        this.resultSlots.m_8015_(player);
        this.shrinkStackInSlot(INPUT_SLOT);
        this.shrinkStackInSlot(MATERIAL_SLOT);
        handleAdvancements(itemStack); // Check the advancement before shrinking the stack.
        if (!(Config.dontConsumeSmithingTemplates && this.f_38839_.get(ADDITIONAL_SLOT).m_7993_().m_41720_() instanceof SmithingTemplate)) {
            this.shrinkStackInSlot(ADDITIONAL_SLOT);
        }
        this.access.m_39292_((level, pos) -> level.m_46796_(1044, pos, 0));
    }

    private void handleAdvancements(ItemStack itemStack) {
        if (this.inputSlots.m_8020_(ADDITIONAL_SLOT).m_41720_() instanceof ArmorTrimSmithingTemplate && this.player instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer) this.player;
            Advancement advancement = player.m_9236_().m_7654_().m_129889_().m_136041_(new ResourceLocation(Armortrims.MODID,"trim_with_any_armor_pattern"));
            Advancement advancementChallenge = player.m_9236_().m_7654_().m_129889_().m_136041_(new ResourceLocation(Armortrims.MODID,"trim_with_all_armor_patterns"));
            if (advancement != null && !player.m_8960_().m_135996_(advancement).m_8193_()) {
                player.m_8960_().m_135988_(advancement, "code_triggered");
            }
            if (advancementChallenge != null) {
                ResourceLocation trim = TrimGetter.getPattern(itemStack);
                if (trim != null) {
                    CriterionProgress criteria = player.m_8960_().m_135996_(advancementChallenge).m_8214_("code_triggered_" + trim.m_135815_());
                    if (criteria != null && !criteria.m_12911_()) {
                        player.m_8960_().m_135988_(advancementChallenge, "code_triggered_" + trim.m_135815_());
                    }
                }
            }
        }
    }

    private void shrinkStackInSlot(int slot) {
        ItemStack itemstack = this.inputSlots.m_8020_(slot);
        itemstack.m_41774_(1);
        this.inputSlots.m_6836_(slot, itemstack);
    }

    public void createResult() {
        ItemStack baseItem = this.inputSlots.m_8020_(INPUT_SLOT);
        ItemStack templateItem = this.inputSlots.m_8020_(ADDITIONAL_SLOT);
        ItemStack materialItem = this.inputSlots.m_8020_(MATERIAL_SLOT);
        if (templateItem.m_41720_() instanceof SmithingTemplate) {
            SmithingTemplate smithingTemplate = (SmithingTemplate) templateItem.m_41720_();
            this.resultSlots.m_6836_(0, smithingTemplate.getResult(baseItem, templateItem, materialItem, level));
        } else {
            Container vanillaRecipeContainer = new SimpleContainer(2);
            vanillaRecipeContainer.m_6836_(0, baseItem);
            vanillaRecipeContainer.m_6836_(1, materialItem);

            List<UpgradeRecipe> list = this.level.m_7465_().m_44056_(RecipeType.f_44113_, vanillaRecipeContainer, this.level);

            if (list.isEmpty() || (
                    Config.disableVanillaNetheriteUpgrade && materialItem/*? if <1.18.2 {*//*.getItem()*//*?}*/.m_204117_(ArmortrimsInternalUtils.NETHERITE_TAG)) // Special Override
            ) {
                this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            } else {
                UpgradeRecipe selectedRecipe = list.get(0);
                ItemStack itemstack = selectedRecipe.m_5874_(vanillaRecipeContainer);
                this.resultSlots.m_6029_(selectedRecipe);
                this.resultSlots.m_6836_(0, itemstack);
            }
        }
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        if (container == this.inputSlots) {
            this.createResult();
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, pos) -> {
            this.m_150411_(player, /*? if <1.17 {*//*level,*//*?}*/ this.inputSlots);
        });
    }

    protected int determineSlotToMove(ItemStack item) {
        Container crafting = this.inputSlots;
        SmithingTemplate template = null;
        {
            Item t = crafting.m_8020_(ADDITIONAL_SLOT).m_41720_();
            if (t instanceof SmithingTemplate) {
                template = (SmithingTemplate) t;
            }
        }
        if (item.m_41720_() instanceof SmithingTemplate) {
            return ADDITIONAL_SLOT;
        } else if (template != null && template.materials().test(item)) {
            return MATERIAL_SLOT;
        } else if (crafting.m_8020_(INPUT_SLOT).m_41619_()) {
            return INPUT_SLOT;
        } else {
            return MATERIAL_SLOT;
        }
    }

    public boolean m_5882_(ItemStack item, Slot slotId) {
        return slotId.f_40218_ != this.resultSlots && super.m_5882_(item, slotId);
    }

    public ItemStack m_7648_(Player player, int slotId) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = this.f_38839_.get(slotId);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotId == RESULT_SLOT) {
                if (!this.m_38903_(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotId != INPUT_SLOT && slotId != ADDITIONAL_SLOT && slotId != MATERIAL_SLOT) {
                if (slotId >= INV_SLOT_START && slotId < USE_ROW_SLOT_END) {
                    int i = determineSlotToMove(itemstack1);
                    if (!this.m_38903_(itemstack1, i, inputSlots.m_6643_(), false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot(playerInventory, l + i * 9 + 9, 8 + l * 18, 97 + i * 18));
            }
        }
        addPlayerHotbar(playerInventory);
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(playerInventory, i, 8 + i * 18, 155));
        }
    }
}
