package dev.hipposgrumm.armor_trims.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.item.SmithingTemplate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.client.gui.screens.inventory.InventoryScreen.m_98850_;

public class SmithingScreenNew extends AbstractContainerScreen<SmithingMenuNew> implements ContainerListener {
    public static final ResourceLocation GUI_SMITHING = new ResourceLocation(Armortrims.MODID, "textures/gui/container/smithing_new.png");

    private LivingEntity preview;

    public SmithingScreenNew(SmithingMenuNew menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97728_ = 60;
        this.f_97729_ = 18;
        this.f_97727_ = 179;
        this.f_97731_ = this.f_97727_ - 93;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97732_.m_38893_(this);
        this.preview = createPreview();
    }

    public static LivingEntity createPreview() {
        if (Minecraft.m_91087_().f_91073_ == null) return null;
        LivingEntity preview = new ArmorStand(Minecraft.m_91087_().f_91073_, 0, 0, 0);
        preview.m_20242_(true);
        CompoundTag extraNBT = new CompoundTag();
        extraNBT.m_128379_("ShowArms", true);
        extraNBT.m_128379_("NoBasePlate", true);
        preview.m_20258_(extraNBT);
        return preview;
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_97732_.m_38943_(this);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        RenderSystem.m_69461_();
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float delta, int mouseX, int mouseY) {
        //? if >=1.17 {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.m_157456_(0, SmithingScreenNew.this.GUI_SMITHING);
        //?} else {
        /*RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.minecraft.getTextureManager().bind(GUI_SMITHING);
        *///?}
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (determineCraftingIncomplete()) {
            this.m_93228_(poseStack, x + 72, y + 45, this.f_97726_, 0, 28, 21);
        }
        m_98850_(x + 145, y + 75, 30, 50, -50, preview);
    }

    private boolean determineCraftingIncomplete() {
        if (this.f_97732_.m_38853_(0).m_6657_() && !this.f_97732_.m_38853_(1).m_6657_()) {
            return true;
        } else if (!this.f_97732_.m_38853_(0).m_6657_() && this.f_97732_.m_38853_(1).m_6657_()) {
            return true;
        } else if (this.f_97732_.m_38853_(1).m_7993_().m_41720_() instanceof SmithingTemplate && (!this.f_97732_.m_38853_(0).m_6657_() || !this.f_97732_.m_38853_(2).m_6657_())) {
            return true;
        } else if (this.f_97732_.m_38853_(0).m_6657_() && this.f_97732_.m_38853_(1).m_6657_() && !this.f_97732_.m_38853_(3).m_6657_()) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        if (preview != null) {
            preview.m_142687_(/*? if >=1.18 {*/Entity.RemovalReason.DISCARDED/*?}*/);
        }
    }

    @Override
    //? if >=1.18 {
    public void m_142153_(AbstractContainerMenu menu, int index, int value) {}
    //?} else {
    /*public void setContainerData(AbstractContainerMenu menu, int index, int value) {}

    @Override
    public void refreshContainer(AbstractContainerMenu menu, NonNullList<ItemStack> nonNullList) {}
    *///?}

    @Override
    public void m_7934_(AbstractContainerMenu menu, int index, ItemStack stack) {
        if (index==3) updatePreview(this.preview,stack);
    }

    private static final EquipmentSlot[] previewSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.OFFHAND};
    public static void updatePreview(@Nullable LivingEntity preview, ItemStack item) {
        if (preview != null) {
            CompoundTag data = new CompoundTag();
            for (EquipmentSlot equipment : previewSlots) {
                preview.m_8061_(equipment, ItemStack.f_41583_);
            }

            if (!item.m_41619_()) {
                EquipmentSlot slot = /*? if >=1.17 {*/LivingEntity/*?} else {*//*Mob*//*?}*/.m_147233_(item);
                if (slot == EquipmentSlot.MAINHAND) slot = EquipmentSlot.OFFHAND;
                data.m_128365_("LeftArm", new Rotations(slot == EquipmentSlot.OFFHAND ? -50.0f : 0.0f, 50.0f, 0.0f).m_123155_());
                preview.m_8061_(slot, item);
            }

            data.m_128379_("ShowArms", true);
            data.m_128379_("NoBasePlate", true);
            preview.m_20258_(data);
        }
    }
}