package dev.hipposgrumm.armor_trims.recipes;

import com.google.gson.JsonObject;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.*;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class UntrimmingSpecialRecipe extends CustomRecipe {
    public static final ResourceLocation ID = new ResourceLocation(Armortrims.MODID,"crafting_special_untrimming");

    public UntrimmingSpecialRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(CraftingContainer crafting, Level level) {
        boolean hasTrimmedItem = false;
        boolean hasShearsItem = false;

        for(int i = 0; i < crafting.m_6643_(); i++) {
            ItemStack item = crafting.m_8020_(i);
            if (!item.m_41619_()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(item) ) {
                    hasTrimmedItem = true;
                } else if (item/*? if <1.18.2 {*//*.getItem()*//*?}*/.m_204117_(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    hasShearsItem = true;
                }
            }
        }

        return hasTrimmedItem && hasShearsItem;
    }

    public ItemStack assemble(CraftingContainer crafting) {
        ItemStack trimmedItem = ItemStack.f_41583_;
        ItemStack shearsItem = ItemStack.f_41583_;

        for(int i = 0; i < crafting.m_6643_(); ++i) {
            ItemStack testTrimmedItem = crafting.m_8020_(i);
            if (!testTrimmedItem.m_41619_() && TrimGetter.isTrimmed(testTrimmedItem)) {
                trimmedItem = testTrimmedItem;
                break;
            }
        }

        for(int i = 0; i < crafting.m_6643_(); ++i) {
            ItemStack testShearsItem = crafting.m_8020_(i);
            if (!testShearsItem.m_41619_() && testShearsItem/*? if <1.18.2 {*//*.getItem()*//*?}*/.m_204117_(ArmortrimsInternalUtils.SHEARS_TAG)) {
                shearsItem = testShearsItem;
                break;
            }
        }

        ItemStack finalItem = trimmedItem.m_41777_();
        TrimGetter.clearTrim(finalItem);
        if (shearsItem.m_41773_()>=shearsItem.m_41776_()) shearsItem.m_41774_(1);

        return !Config.enableUntrimming?ItemStack.f_41583_:finalItem;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer crafting) {
        NonNullList<ItemStack> nonnulllist = NonNullList.m_122780_(crafting.m_6643_(), ItemStack.f_41583_);
        boolean hasTrimmedItem = false;

        for(int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = crafting.m_8020_(i);
            if (!itemstack.m_41619_()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(itemstack)) {
                    hasTrimmedItem = true;
                } else if (itemstack/*? if <1.18.2 {*//*.getItem()*//*?}*/.m_204117_(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    ItemStack shearsItem = itemstack.m_41777_();
                    shearsItem.m_41721_(itemstack.m_41773_()-1);
                    nonnulllist.set(i, shearsItem);
                }
            }
        }

        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return (width > 0 && height > 0) && (width > 1 || height > 1); // Two items.
    }

    public RecipeSerializer<?> m_7707_() {
        return Armortrims.UNTRIMMING_RECIPE.get();
    }

    public static class Serializer implements RecipeSerializer<UntrimmingSpecialRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public UntrimmingSpecialRecipe m_6729_(ResourceLocation id, JsonObject json) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public UntrimmingSpecialRecipe m_8005_(ResourceLocation id, FriendlyByteBuf buf) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, UntrimmingSpecialRecipe recipe) {}

        //? if forge {
        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        public ResourceLocation getRegistryName() {
            return UntrimmingSpecialRecipe.ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        @SuppressWarnings("unchecked") // Need this wrapper, because generics.
        private static <G> Class<G> castClass(Class<?> cls) {
            return (Class<G>)cls;
        }
        //?}
    }
}