package dev.hipposgrumm.armor_trims.api.trimming;

import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.TrimPattern;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
//? if >=1.18
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

//? if forge {
import net.minecraftforge.registries.ForgeRegistries;
//?}

public class TrimGetter {
    private static final ResourceLocation EMPTY_TRIM = new ResourceLocation("empty");

    private static final String TAG_TRIM_MATERIAL = "Material";
    private static final String TAG_TRIM_PATTERN = "Pattern";
    private static final String TAG_TRIM = "Trim";

    private static CompoundTag getTrimTag(ItemStack targetItem) {
        CompoundTag tag = targetItem.m_41783_();
        if (tag==null) return new CompoundTag();
        //? if >=1.18 {
        ReaderWithLegacySupport reader = new ReaderWithLegacySupport(TAG_TRIM);
        if (tag.m_196533_(reader) == StreamTagVisitor.ValueResult.CONTINUE) return new CompoundTag();
        return targetItem.m_41737_(reader.get());
        //?} else {
        /*return tag.getCompound(TAG_TRIM);
        *///?}
    }

    public static boolean isTrimmed(ItemStack targetItem) {
        return !getTrimTag(targetItem).m_128456_();
    }

    public static ResourceLocation getMaterial(ItemStack targetItem) {
        CompoundTag tag = getTrimTag(targetItem);
        if (tag==null) return MissingTextureAtlasSprite.m_118071_();
        //? if >=1.18 {
        ReaderWithLegacySupport reader = new ReaderWithLegacySupport(TAG_TRIM_MATERIAL);
        if (tag.m_196533_(reader) == StreamTagVisitor.ValueResult.CONTINUE) return MissingTextureAtlasSprite.m_118071_();
        return new ResourceLocation(reader.get());
        //?} else {
        /*return new ResourceLocation(tag.getString(TAG_TRIM_MATERIAL));
        *///?}
    }

    public static ResourceLocation getPattern(ItemStack targetItem) {
        CompoundTag tag = getTrimTag(targetItem);
        if (tag==null) return EMPTY_TRIM;
        //? if >=1.18 {
        ReaderWithLegacySupport reader = new ReaderWithLegacySupport(TAG_TRIM_PATTERN);
        if (tag.m_196533_(reader) == StreamTagVisitor.ValueResult.CONTINUE) return MissingTextureAtlasSprite.m_118071_();
        ResourceLocation pattern = new ResourceLocation(reader.get());
        //?} else {
        /*ResourceLocation pattern = new ResourceLocation(tag.getString(TAG_TRIM_PATTERN));
        *///?}
        if (pattern.m_135827_().equals("minecraft")) pattern = new ResourceLocation(Armortrims.MODID, pattern.m_135815_());
        return pattern;
    }

    public static void clearTrim(ItemStack targetItem) {
        targetItem.m_41749_("trim");
        targetItem.m_41749_(TAG_TRIM);
    }

    public static void setMaterial(ItemStack targetItem, ItemStack material) {
        //? if forge {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey(material.m_41720_());
        //?} else {
        /*ResourceLocation location = Registry.ITEM.getKey(material.getItem());
        *///?}

        targetItem.m_41698_(TAG_TRIM).m_128359_(TAG_TRIM_MATERIAL, location.toString());
    }

    public static void setPattern(ItemStack targetItem, TrimPattern trim) {
        ResourceLocation patternLoc = trim.getId();
        if (patternLoc == null) return;
        String pattern = patternLoc.toString();
        if (patternLoc.m_135827_().equals(Armortrims.MODID)) pattern = patternLoc.m_135815_();
        targetItem.m_41698_(TAG_TRIM).m_128359_(TAG_TRIM_PATTERN, pattern);
    }

    /**
     *  Returns a copy of the provided itemstack with the trim added.
     */
    public static ItemStack applyTrim(ItemStack targetItem, TrimPattern trim, ItemStack material) {
        ItemStack armorItem;
        if (trim != null) {
            armorItem = targetItem.m_41777_();

            setPattern(armorItem, trim);
            setMaterial(armorItem, material);
            return armorItem;
        } else {
            return ItemStack.f_41583_;
        }
    }

    //? if >=1.18 {
    // Only necessary in previously supported versions.
    private static class ReaderWithLegacySupport implements StreamTagVisitor {
        private final String target;
        private String found;

        public ReaderWithLegacySupport(String target) {
            this.target = target.toLowerCase();
        }

        public String get() {
            return found;
        }

        @Override
        public ValueResult m_196525_() {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196458_(String value) {
            found = value;
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196209_(byte value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196553_(short value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196353_(int value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196295_(long value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196532_(float value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196455_(double value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196152_(byte[] value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196376_(int[] value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196280_(long[] value) {
            return ValueResult.BREAK;
        }

        @Override
        public ValueResult m_196339_(TagType<?> type, int i) {
            return ValueResult.BREAK;
        }

        @Override
        public EntryResult m_196214_(TagType<?> type) {
            return EntryResult.ENTER;
        }

        @Override
        public EntryResult m_196425_(TagType<?> type, String key) {
            if (key.toLowerCase().equals(target)) {
                found = key;
                return EntryResult.ENTER;
            }
            return EntryResult.SKIP;
        }

        @Override
        public EntryResult m_196338_(TagType<?> type, int i) {
            return EntryResult.SKIP;
        }

        @Override
        public ValueResult m_196527_() {
            return found != null ? ValueResult.BREAK : ValueResult.CONTINUE;
        }

        @Override
        public ValueResult m_196213_(TagType<?> type) {
            return ValueResult.BREAK;
        }
    }
    //?}
}