package dev.hipposgrumm.armor_trims.api;

import com.mojang.serialization.Lifecycle;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.base.ItemOverlays;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

/**
 * This class holds item overlays.<br>
 * Item Overlays can be registered with this class.
 * @see ItemOverlays Example
 */
public class OverlayRegistry {
    public static final class_5321<class_2378<ItemOverlay>> ITEM_OVERLAY_REGISTRY_KEY = class_5321.method_29180(new class_2960(Armortrims.MODID,"overlays"));
    public static final class_2370<ItemOverlay> ITEM_OVERLAYS = new class_2370<>(ITEM_OVERLAY_REGISTRY_KEY, Lifecycle.experimental()/*? if >=1.18 {*/, null/*?}*/);
    private static final List<BiFunction<class_1799, ItemOverlay, ItemOverlay>> conditions = new ArrayList<>();

    /// Default item overlay.
    public static ItemOverlay defaultItemOverlay() {
        return ItemOverlays.OTHER;
    }

    /**
     * Register an item overlay.
     * @param id ID of the overlay.
     * @param overlay ItemOverlay data for the overlay.
     * @return Overlay data given.
     */
    public static <T extends ItemOverlay> T registerItemOverlay(class_2960 id, T overlay) {
        return class_2378.method_10230(ITEM_OVERLAYS, id, overlay);
    }

    /**
     * Run a function to return a specific overlay for the item.
     * @param function - BiFunction returning desired ItemOverlay, params are the Item and the Item Overlay currently inputted by previous functions before it.
     */
    public static void addCondition(BiFunction<class_1799, ItemOverlay, ItemOverlay> function) {
        conditions.add(function);
    }

    /**
     * Get an item overlay from an ID.
     * @param id ID of the overlay.
     * @return Overlay from the ID.<br>
     * Null if there is no overlay associated with that ID.
     */
    @Nullable
    public static ItemOverlay getItemOverlay(class_2960 id) {
        return ITEM_OVERLAYS.method_10223(id);
    }

    /**
     * Returns an item overlay based on a provided itemstack.
     * @param item - Itemstack to give the overlay to.
     * @return Item Overlay associated with itemstack. By default, this is OTHER_TRIM.
     */
    public static ItemOverlay fromItem(class_1799 item) {
        ItemOverlay overlay = ItemOverlays.OTHER;
        for (BiFunction<class_1799, ItemOverlay, ItemOverlay> condition:conditions) {
            overlay = condition.apply(item, overlay);
        }
        return overlay;
    }
}
