package dev.hipposgrumm.armor_trims.api;

import com.mojang.serialization.Lifecycle;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.base.TrimPatterns;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.ArmorTrimPattern;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.TrimPattern;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

/**
 * This class holds trim registries.<br>
 * Trims can be registered with this class.
 * @see TrimPatterns Example
 */
public class TrimRegistry {
    public static final class_5321<class_2378<TrimPattern>> ITEM_TRIM_REGISTRY_KEY = class_5321.method_29180(new class_2960(Armortrims.MODID,"trims"));
    public static final class_2370<TrimPattern> ITEM_TRIMS = new class_2370<>(ITEM_TRIM_REGISTRY_KEY, Lifecycle.experimental()/*? if >=1.18 {*/, null/*?}*/);

    /// Default trim pattern.
    public static ArmorTrimPattern defaultTrim() {
        return TrimPatterns.COAST;
    }

    /**
     * Register an item trim.
     * @param id ID of the trim.
     * @param trim TrimPattern data for the trim.
     * @return Trim data given.
     */
    public static <T extends TrimPattern> T registerTrim(class_2960 id, T trim) {
        return class_2378.method_10230(ITEM_TRIMS, id, trim);
    }

    /**
     * Get an item trim from an ID.
     * @param id ID of the trim.
     * @return Trim from the ID.<br>
     * Null if there is no trim associated with that ID.
     */
    @Nullable
    public static TrimPattern getTrim(class_2960 id) {
        return ITEM_TRIMS.method_10223(id);
    }
}
