package dev.hipposgrumm.armor_trims.api.base;

import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

/// Item Overlays
public class ItemOverlays {
    public static final ItemOverlay OTHER = OverlayRegistry.registerItemOverlay(new class_2960(Armortrims.MODID, "other"), new ItemOverlay(new class_2960(Armortrims.MODID, "item/overlay/other_trim")));
    public static final ItemOverlay HEAD  = OverlayRegistry.registerItemOverlay(new class_2960(Armortrims.MODID, "head"),  new ItemOverlay(new class_2960(Armortrims.MODID, "item/overlay/helmet_trim")));
    public static final ItemOverlay CHEST = OverlayRegistry.registerItemOverlay(new class_2960(Armortrims.MODID, "chest"), new ItemOverlay(new class_2960(Armortrims.MODID, "item/overlay/chestplate_trim")));
    public static final ItemOverlay LEGS  = OverlayRegistry.registerItemOverlay(new class_2960(Armortrims.MODID, "legs"),  new ItemOverlay(new class_2960(Armortrims.MODID, "item/overlay/leggings_trim")));
    public static final ItemOverlay FEET  = OverlayRegistry.registerItemOverlay(new class_2960(Armortrims.MODID, "feet"),  new ItemOverlay(new class_2960(Armortrims.MODID, "item/overlay/boots_trim")));

    @ApiStatus.Internal
    public static void register() {
        OverlayRegistry.addCondition((item, overlay) -> {
            class_1792 it = item.method_7909();
            if (it instanceof class_1738) {
                class_1738 armorItem = (class_1738) it;
                switch (armorItem.method_7685()) {
                    // This definitely won't confuse people.
                    case field_6169:  return HEAD;
                    case field_6174: return CHEST;
                    case field_6172:  return LEGS;
                    case field_6166:  return FEET;
                }
            }
            return overlay;
        });
    }
}
