package dev.hipposgrumm.armor_trims.api.item;

import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.ArmorTrimPattern;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

/**
 * Smithing Template designed for Armor Trims
 * Use this when making an Item Trim
 * @see dev.hipposgrumm.armor_trims.api.base.SmithingTemplateItems Example
 */
public class ArmorTrimSmithingTemplate extends SmithingTemplate {
    private final ArmorTrimPattern trim;

    /**
     * Armor Trim Smithing Template
     * @param trim       - A registered Trim Pattern associated with this template. Doesn't have to be an armor trim pattern ({@see ItemUpgradePattern})
     * @param materials  - Materials used by the template - passed as a supplier and accessed during runtime.
     * @param properties - Item Properties
     */
    public ArmorTrimSmithingTemplate(ArmorTrimPattern trim, Supplier<class_1856> materials, class_1793 properties) {
        this(trim, materials, /*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("tooltip.armor_trims.applyTo.armor").method_27692(class_124.field_1078), properties);
    }

    /**
     * Can be overridden to allow changing of the component.
     * @param applyTo - Component following "Apply To" in tooltip
     */
    protected ArmorTrimSmithingTemplate(ArmorTrimPattern trim, Supplier<class_1856> materials, class_2561 applyTo, class_1793 properties) {
        super(trim.getId(), materials, applyTo, properties);
        this.trim = trim;
    }

    /// Public overridable method for getting the trim
    public ArmorTrimPattern trim() {
        return trim;
    }

    /**
     * Result of the recipe.
     * @param baseItem     - Base Item (eg Armor)
     * @param templateItem - Smithing Template (this)
     * @param materialItem - Material (trim material)
     * @param level        - World (used to access recipe data and such)
     * @return Resulting Item
     */
    public class_1799 getResult(class_1799 baseItem, class_1799 templateItem, class_1799 materialItem, class_1937 level) {
        if (baseItem/*? if <1.18 {*//*.getItem()*//*?}*/.method_31573(Armortrims.NON_TRIMMABLE_ITEMS_TAG)) return class_1799.field_8037;

        if (materials().method_8093(materialItem)) {
            return TrimGetter.applyTrim(baseItem, trim(), materialItem);
        } else {
            return class_1799.field_8037;
        }
    }
}
