package dev.hipposgrumm.armor_trims.api.item;

import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.network.chat.*;
import net.minecraft.world.item.*;
import java.util.*;
import java.util.function.Supplier;

//? if forge {
/*import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
*///?}

/**
 * Smithing template for use in the Smithing Table GUI
 * @see dev.hipposgrumm.armor_trims.api.base.SmithingTemplateItems Example
 */
public abstract class SmithingTemplate extends class_1792 {
    protected final Supplier<class_1856> materials;
    protected final class_2960 trimIdentifier;
    protected final class_2561 applyTo;

    /**
     * Smithing Template
     * @param trimIdentifier - A registered Trim Pattern associated with this template. Doesn't have to be an armor trim pattern ({@see ItemUpgradePattern}) and is used for translation.
     * @param materials      - Materials used by the template - passed as a supplier and accessed during runtime.
     * @param applyTo        - Component following "Apply To" in tooltip
     * @param properties     - Item Properties
     */
    public SmithingTemplate(class_2960 trimIdentifier, Supplier<class_1856> materials, class_2561 applyTo, class_1792.class_1793 properties) {
        super(properties);
        this.materials = materials;
        this.trimIdentifier = trimIdentifier;
        this.applyTo = applyTo;
    }

    /**
     * Result of the recipe.
     * @param baseItem     - Base Item (eg Armor)
     * @param templateItem - Smithing Template (this)
     * @param materialItem - Material (trim material)
     * @param level        - World (used to access recipe data and such)
     * @return Resulting Item
     */
    public abstract class_1799 getResult(class_1799 baseItem, class_1799 templateItem, class_1799 materialItem, class_1937 level);

    //? if forge {
    /*/// @apiNote Override {@link #getRecipeRemainder} instead.
    @ApiStatus.Internal
    public final ItemStack getContainerItem(ItemStack item) {
        return getRecipeRemainder(item);
    }

    ///  @apiNote Override {@link #hasCraftingRemainingItem()} instead.
    @ApiStatus.Internal
    public final boolean hasContainerItem(ItemStack stack) {
        return hasCraftingRemainingItem();
    }
    *///?}

    public class_1799 getRecipeRemainder(class_1799 item) {
        return item;
    }

    public boolean method_7857() {
        return true;
    }

    public class_1856 materials() {
        return materials.get();
    }

    @Override
    public class_2561 method_7864(class_1799 itemStack) {
        return /*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("item.armor_trims.smithing_template");
    }

    /// This is where the meat of the code is. It's the trim information of the item. You can change it if you're willing to read it.
    public void method_7851(class_1799 itemstack, class_1937 level, List<class_2561> list, class_1836 flag) {
        super.method_7851(itemstack, level, list, flag);

        if (class_310.method_1551().field_1687 == null) return;

        // Name of Smithing Template
        if (trimIdentifier != null) list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("trims." + trimIdentifier.toString().replace(':', '.')).method_27692(class_124.field_1063));

        // Application
        list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/("").method_27692(class_124.field_1080));
        list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("tooltip.armor_trims.applyTo").method_27692(class_124.field_1080));
        list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ").method_10852(applyTo));

        // Ingredients
        list.add(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("tooltip.armor_trims.ingredients").method_27692(class_124.field_1080));
        class_1799[] materialItems = materials().method_8105();
        if (materialItems.length > 0) {
            if (materialItems.length <= 4 || class_437.method_25442()) { // If fits or shifts.
                int firstIndex = list.size();
                list.addAll(createColoredList(materialItems, flag));
                list.set(firstIndex, /*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ").method_10852(list.get(firstIndex)));
            } else { // Require shift.
                list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ").method_10852(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("tooltip.armor_trims.ingredients.show_more").method_27695(class_124.field_1078, class_124.field_1073)));
            }
        } else { // If none.
            list.add(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ").method_10852(/*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/("tooltip.armor_trims.ingredients.empty").method_27695(class_124.field_1078, class_124.field_1056)));
        }
    }

    /// This creates all the items in a list by their color. You can change it if you're willing to read it.
    protected List<class_5250> createColoredList(class_1799[] list, class_1836 flag) {
        if (list.length >= 3) {
            List<class_5250> itemlist = new ArrayList<>();
            class_5250 item = /*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ");
            for (int i = 0; i < list.length; i++) {
                class_2561 coloredIngredient = colorAndNameIngredient(list[i]);
                if (i == list.length - 1) {
                    item.method_10852(coloredIngredient);
                } else if (i == list.length - 2) {
                    item.method_10852(coloredIngredient).method_10852(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(", & "));
                } else {
                    item.method_10852(coloredIngredient).method_10852(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(", "));
                }
                //? if fabric {
                // This is only needed on Fabric because the UI doesn't wraparound like on Forge.
                if (item.getString().length()>=(flag.method_8035()?Math.max(30,class_2378.field_11142.method_10221(this).toString().length()):30)) {
                    itemlist.add(item);
                    item = /*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/("");
                }
                //?}
            }
            itemlist.add(item);
            itemlist.removeIf(c -> c.getString().equals(" "));
            return itemlist;
        } else if (list.length == 2) {
            class_5250 item = /*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/(" ");
            return Collections.singletonList(item.method_10852(colorAndNameIngredient(list[0]))
                    .method_27693(" & ").method_10852(colorAndNameIngredient(list[1])));
        } else if (list.length == 1) {
            return Collections.singletonList(/*? if >=1.19 {*//*Component.literal*//*?} else {*/new class_2585/*?}*/("").method_10852(colorAndNameIngredient(list[0])));
        } else {
            return null;
        }
    }

    /// Create a component from an itemstack. You can change it if you're willing to read it.
    protected static class_2561 colorAndNameIngredient(class_1799 item) {
        class_5250 output = /*? if >=1.19 {*//*Component.translatable*//*?} else {*/new class_2588/*?}*/(item.method_7922());
        //? if forge {
        /*ResourceLocation name = ForgeRegistries.ITEMS.getKey(item.getItem());
        *///?} else {
        class_2960 name = class_2378.field_11142.method_10221(item.method_7909());
        //?}
        ColorPalette color = ColorPaletteManager.get(name);
        if (color == null) color = ColorPalette.DEFAULT; // Yes this can happen for some reason.
        return output.method_27696(output.method_10866().method_27703(color.textColor()));
    }
}
