package dev.hipposgrumm.armor_trims.api.item;

import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.world.item.*;
import java.util.List;
import java.util.function.Supplier;

/**
 * Smithing Template designed for Item Upgrading, recognized by JEI.
 * @see dev.hipposgrumm.armor_trims.api.base.SmithingTemplateItems Example
 */
public abstract class UpgradeSmithingTemplate extends SmithingTemplate {
    /**
     * Smithing Template
     * @param trimIdentifier - A registered Trim Pattern associated with this template. Doesn't have to be an armor trim pattern ({@see ItemUpgradePattern}) and is used for translation.
     * @param materials      - Materials used by the template - passed as a supplier and accessed during runtime.
     * @param applyTo        - Component following "Apply To" in tooltip
     * @param properties     - Item Properties
     */
    public UpgradeSmithingTemplate(class_2960 trimIdentifier, Supplier<class_1856> materials, class_2561 applyTo, class_1793 properties) {
        super(trimIdentifier, materials, applyTo, properties);
    }

    /**
     * Result of the recipe.
     * @param baseItem     - Base Item (eg Armor)
     * @param templateItem - Smithing Template (this)
     * @param materialItem - Material (trim material)
     * @param level        - World (used to access recipe data and such)
     * @return Resulting Item
     */
    public abstract class_1799 getResult(class_1799 baseItem, class_1799 templateItem, class_1799 materialItem, class_1937 level);
}
