package dev.hipposgrumm.armor_trims.api.trimming;

import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import net.minecraft.class_2960;

/// This is the trim overlay on the trimmed item.
public class ItemOverlay {
    protected final class_2960 location;
    private class_2960 id;

    /**
     * @param location Location of the overlay texture.
     */
    public ItemOverlay(class_2960 location) {
        this.location = location;
    }

    /**
     * Get the ID of this item overlay.
     * @return ID of the item overlay.<br>
     * Null if overlay is not registered.
     */
    @Nullable
    public class_2960 getId() {
        if (id == null) id = OverlayRegistry.ITEM_OVERLAYS.method_10221(this);
        return id;
    }

    /**
     * @return Location of overlay texture.
     */
    public class_2960 textureLocation() {
        return location;
    }

    @Override
    public String toString() {
        return location.toString();
    }
}
