package dev.hipposgrumm.armor_trims.gui;

import java.util.List;

import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.item.ArmorTrimSmithingTemplate;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.item.SmithingTemplate;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_178;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3956;
import net.minecraft.class_5357;
import net.minecraft.world.inventory.*;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.ApiStatus;

public class SmithingMenuNew extends class_1703 {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 3;
    public static final int MATERIAL_SLOT = 2;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;

    protected final class_1731 resultSlots = new class_1731();
    protected final class_1263 inputSlots = new class_1277(3) {
        public void method_5431() {
            super.method_5431();
            SmithingMenuNew.this.method_7609(this);
        }
    };
    protected final class_3914 access;
    protected final class_1657 player;
    private final class_1937 level;

    public SmithingMenuNew(int id, class_1661 inventory, class_3914 access, class_1657 player) {
        super(Armortrims.SMITHING_MENU_NEW.get(), id);
        this.level = inventory.field_7546.field_6002;
        this.access = access;
        this.player = inventory.field_7546;
        this.method_7621(new class_1735(this.inputSlots, INPUT_SLOT, 8, 48));
        this.method_7621(new class_1735(this.inputSlots, ADDITIONAL_SLOT, 8, 66) {
            @Override
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of(class_1723.field_21668, new class_2960(Armortrims.MODID,"item/empty_slot_smithing_template_armor_trim"));
            }

            @Override
            public boolean method_7680(class_1799 item) {
                return item.method_7909() instanceof SmithingTemplate;
            }
        });
        this.method_7621(new class_1735(this.inputSlots, MATERIAL_SLOT, 52, 48));
        this.method_7621(new class_1735(this.resultSlots, RESULT_SLOT, 106, 48) {
            public boolean method_7680(class_1799 item) {
                    return false;
                }

            public boolean method_7674(class_1657 player) {
                return this.method_7681();
            }

            public /*? if >=1.18 {*/void/*?} else {*//*ItemStack*//*?}*/ method_7667(class_1657 player, class_1799 item) {
                SmithingMenuNew.this.onTake(player, item);
                //? if <1.18
                /*return item;*/
            }
        });
        addPlayerInventory(inventory);
    }

    //? if forge {
    /*/// @apiNote Used by Forge
    @ApiStatus.Internal
    public SmithingMenuNew(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory, ContainerLevelAccess.NULL, inventory.player);
    }
    *///?}

    public SmithingMenuNew(int i, class_1661 inventory) {
        this(i, inventory, class_3914.field_17304, inventory.field_7546);
    }

    protected boolean isValidBlock(class_2680 state) {
        return state.method_27852(class_2246.field_16329);
    }

    public boolean method_7597(class_1657 player) {
        return this.access.method_17396((level, pos) -> this.isValidBlock(level.method_8320(pos)) && player.method_5649((double) pos.method_10263() + 0.5D, (double) pos.method_10264() + 0.5D, (double) pos.method_10260() + 0.5D) <= 64.0D, true);
    }

    protected void onTake(class_1657 player, class_1799 itemStack) {
        itemStack.method_7982(player.field_6002, player, itemStack.method_7947());
        this.resultSlots.method_7664(player);
        this.shrinkStackInSlot(INPUT_SLOT);
        this.shrinkStackInSlot(MATERIAL_SLOT);
        handleAdvancements(itemStack); // Check the advancement before shrinking the stack.
        if (!(Config.dontConsumeSmithingTemplates && this.field_7761.get(ADDITIONAL_SLOT).method_7677().method_7909() instanceof SmithingTemplate)) {
            this.shrinkStackInSlot(ADDITIONAL_SLOT);
        }
        this.access.method_17393((level, pos) -> level.method_20290(1044, pos, 0));
    }

    private void handleAdvancements(class_1799 itemStack) {
        if (this.inputSlots.method_5438(ADDITIONAL_SLOT).method_7909() instanceof ArmorTrimSmithingTemplate && this.player instanceof class_3222) {
            class_3222 player = (class_3222) this.player;
            class_161 advancement = player.method_14220().method_8503().method_3851().method_12896(new class_2960(Armortrims.MODID,"trim_with_any_armor_pattern"));
            class_161 advancementChallenge = player.method_14220().method_8503().method_3851().method_12896(new class_2960(Armortrims.MODID,"trim_with_all_armor_patterns"));
            if (advancement != null && !player.method_14236().method_12882(advancement).method_740()) {
                player.method_14236().method_12878(advancement, "code_triggered");
            }
            if (advancementChallenge != null) {
                class_2960 trim = TrimGetter.getPattern(itemStack);
                if (trim != null) {
                    class_178 criteria = player.method_14236().method_12882(advancementChallenge).method_737("code_triggered_" + trim.method_12832());
                    if (criteria != null && !criteria.method_784()) {
                        player.method_14236().method_12878(advancementChallenge, "code_triggered_" + trim.method_12832());
                    }
                }
            }
        }
    }

    private void shrinkStackInSlot(int slot) {
        class_1799 itemstack = this.inputSlots.method_5438(slot);
        itemstack.method_7934(1);
        this.inputSlots.method_5447(slot, itemstack);
    }

    public void createResult() {
        class_1799 baseItem = this.inputSlots.method_5438(INPUT_SLOT);
        class_1799 templateItem = this.inputSlots.method_5438(ADDITIONAL_SLOT);
        class_1799 materialItem = this.inputSlots.method_5438(MATERIAL_SLOT);
        if (templateItem.method_7909() instanceof SmithingTemplate) {
            SmithingTemplate smithingTemplate = (SmithingTemplate) templateItem.method_7909();
            this.resultSlots.method_5447(0, smithingTemplate.getResult(baseItem, templateItem, materialItem, level));
        } else {
            class_1263 vanillaRecipeContainer = new class_1277(2);
            vanillaRecipeContainer.method_5447(0, baseItem);
            vanillaRecipeContainer.method_5447(1, materialItem);

            List<class_5357> list = this.level.method_8433().method_17877(class_3956.field_25388, vanillaRecipeContainer, this.level);

            if (list.isEmpty() || (
                    Config.disableVanillaNetheriteUpgrade && materialItem/*? if <1.18.2 {*//*.getItem()*//*?}*/.method_31573(ArmortrimsInternalUtils.NETHERITE_TAG)) // Special Override
            ) {
                this.resultSlots.method_5447(0, class_1799.field_8037);
            } else {
                class_5357 selectedRecipe = list.get(0);
                class_1799 itemstack = selectedRecipe.method_8116(vanillaRecipeContainer);
                this.resultSlots.method_7662(selectedRecipe);
                this.resultSlots.method_5447(0, itemstack);
            }
        }
    }

    public void method_7609(class_1263 container) {
        super.method_7609(container);
        if (container == this.inputSlots) {
            this.createResult();
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.access.method_17393((level, pos) -> {
            this.method_7607(player, /*? if <1.17 {*//*level,*//*?}*/ this.inputSlots);
        });
    }

    protected int determineSlotToMove(class_1799 item) {
        class_1263 crafting = this.inputSlots;
        SmithingTemplate template = null;
        {
            class_1792 t = crafting.method_5438(ADDITIONAL_SLOT).method_7909();
            if (t instanceof SmithingTemplate) {
                template = (SmithingTemplate) t;
            }
        }
        if (item.method_7909() instanceof SmithingTemplate) {
            return ADDITIONAL_SLOT;
        } else if (template != null && template.materials().method_8093(item)) {
            return MATERIAL_SLOT;
        } else if (crafting.method_5438(INPUT_SLOT).method_7960()) {
            return INPUT_SLOT;
        } else {
            return MATERIAL_SLOT;
        }
    }

    public boolean method_7613(class_1799 item, class_1735 slotId) {
        return slotId.field_7871 != this.resultSlots && super.method_7613(item, slotId);
    }

    public class_1799 method_7601(class_1657 player, int slotId) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(slotId);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotId == RESULT_SLOT) {
                if (!this.method_7616(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (slotId != INPUT_SLOT && slotId != ADDITIONAL_SLOT && slotId != MATERIAL_SLOT) {
                if (slotId >= INV_SLOT_START && slotId < USE_ROW_SLOT_END) {
                    int i = determineSlotToMove(itemstack1);
                    if (!this.method_7616(itemstack1, i, inputSlots.method_5439(), false)) {
                        return class_1799.field_8037;
                    }
                }
            } else if (!this.method_7616(itemstack1, INV_SLOT_START, USE_ROW_SLOT_END, false)) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
        }
        return itemstack;
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(playerInventory, l + i * 9 + 9, 8 + l * 18, 97 + i * 18));
            }
        }
        addPlayerHotbar(playerInventory);
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(playerInventory, i, 8 + i * 18, 155));
        }
    }
}
