package dev.hipposgrumm.armor_trims.mixin;

import dev.hipposgrumm.armor_trims.api.TrimRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.TrimPattern;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.ArmorTrimPattern;
import dev.hipposgrumm.armor_trims.util.TrimTextureManager;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_918;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_970.class)
public abstract class MixinHumanoidArmorLayer<T extends class_1309, M extends class_572<T>, A extends class_572<T>> extends class_3887<T, M> {
    public MixinHumanoidArmorLayer(class_3883<T, M> layer) {
        super(layer);
    }

    @Inject(method = "renderArmorPiece", at = @At("TAIL"))
    private void armor_trims$applyTrimOverlay(class_4587 poseStack, class_4597 buffer, T entity, class_1304 slot, int i, A model, CallbackInfo ci) {
        class_1799 stack = entity.method_6118(slot);
        // Check for trim.
        if (!stack.method_7960() && TrimGetter.isTrimmed(stack)) {
            // Make sure it should show.
            if (slot == class_1304.field_6169 || stack.method_7909() instanceof class_1738) {
                TrimPattern pattern = TrimRegistry.getTrim(TrimGetter.getPattern(stack));
                // Make sure the trim is an armor trim.
                if (pattern instanceof ArmorTrimPattern) {
                    ArmorTrimPattern armorPattern = (ArmorTrimPattern) pattern;
                    
                    // Define variables.
                    class_2960 material = TrimGetter.getMaterial(stack);
                    class_2960 location = slot == class_1304.field_6172 ? armorPattern.getLayer1() : armorPattern.getLayer0();
                    class_2960 coloredLocation = TrimTextureManager.get(location, material);
                    if (coloredLocation == null) return;
                    class_4588 shader = class_918.method_27952(buffer, class_1921.method_25448(coloredLocation), false, stack.method_7958());

                    // TrimTextureManager returns the initial location if there is no palette variation for that pattern and material.
                    if (coloredLocation == location) {
                        // Tint in real time.
                        ColorPalette palette = ColorPaletteManager.get(material);
                        if (palette != null) {
                            int color = palette.get(ColorPalette.PALETTE_COLORS[0]);
                            model.method_2828(poseStack, shader, i, class_4608.field_21444, (color >> 16 & 0xFF)/255f, (color >> 8 & 0xFF)/255f, (color & 0xFF)/255f, (color >> 24 & 0xFF)/255f); // Extract R, G, B, A from color.
                            return;
                        }
                    }
                    // Render pre-colored.
                    model.method_2828(poseStack, shader, i, class_4608.field_21444, 1.0F, 1.0F, 1.0F, 1.0F);
                }
            }
        }
    }
}
