package dev.hipposgrumm.armor_trims.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.model.ItemTrimModels;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_777;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;

@Mixin(value = class_918.class, priority = 1005) // sodium uses overwrite mixins so I have to inject after
public class MixinItemRenderer {
    @Unique private float[] armor_trims$trimColor = null;

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/ItemRenderer;renderModelLists(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/item/ItemStack;IILcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V"))
    private void armor_trims$armorDecoration(class_918 instance, class_1087 model, class_1799 stack, int light, int overlay, class_4587 poseStack, class_4588 shader, Operation<Void> original, @Local(argsOnly = true) class_4597 shaderSource) {
        original.call(instance, model, stack, light, overlay, poseStack, shader);

        if (Armortrims.trimTextures().ready() && TrimGetter.isTrimmed(stack)) {
            ItemOverlay itemOverlay = OverlayRegistry.fromItem(stack);
            class_2960 material = TrimGetter.getMaterial(stack);
            ColorPalette palette = ColorPaletteManager.get(material);
            Pair<class_1087, Boolean> trim = ItemTrimModels.getModel(itemOverlay, palette);
            if (trim == null) return;

            shader = class_918.method_29711(shaderSource, class_4722.method_24076(), true, stack.method_7958());
            if (trim.getSecond()) {
                armor_trims$trimColor = new float[3];
                armor_trims$trimColor[0] = 1;
                armor_trims$trimColor[1] = 1;
                armor_trims$trimColor[2] = 1;
            } else {
                int color = palette.get(ColorPalette.PALETTE_COLORS[0]);
                armor_trims$trimColor = new float[3];
                armor_trims$trimColor[0] = (color >> 16 & 0xFF)/255F;
                armor_trims$trimColor[1] = (color >>  8 & 0xFF)/255F;
                armor_trims$trimColor[2] = (color       & 0xFF)/255F;
            }
            original.call(instance, trim.getFirst(), stack, light, overlay, poseStack, shader);
            armor_trims$trimColor = null;
        }
    }

    @WrapOperation(
            method = "renderQuadList",
            at = @At(
                    //? if forge && >=1.17
                    /*remap = false,*/
                    value = "INVOKE",
                    //? if forge {
                    /*//? if >=1.19 {
                    target = "Lcom/mojang/blaze3d/vertex/VertexConsumer;putBulkData(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFFIIZ)V"
                    //?} elif >=1.17 {
                    /^target = "Lcom/mojang/blaze3d/vertex/VertexConsumer;putBulkData(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFIIZ)V"
                    ^///?} else {
                    /^target = "Lcom/mojang/blaze3d/vertex/VertexConsumer;addVertexData(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFIIZ)V"
                    ^///?}
                    *///?} else {
                    target = "Lcom/mojang/blaze3d/vertex/VertexConsumer;putBulkData(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFII)V"
                    //?}
            )
    )
    private void armor_trims$armorDecorationTint(class_4588 instance, class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, /*? if forge && >=1.19 {*//*float alpha,*//*?}*/ int light, int overlay, /*? if forge {*//*boolean readExistingColor,*//*?}*/ Operation<Void> original) {
        if (armor_trims$trimColor != null) {
            red   = armor_trims$trimColor[0];
            green = armor_trims$trimColor[1];
            blue  = armor_trims$trimColor[2];
        }
        original.call(instance, pose, quad, red, green, blue, /*? if forge && >=1.19 {*//*alpha,*//*?}*/ light, overlay/*? if forge {*//*, readExistingColor*//*?}*/);
    }
}
