package dev.hipposgrumm.armor_trims.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.util.PaletteMaps;
import dev.hipposgrumm.armor_trims.model.ItemTrimModels;
import dev.hipposgrumm.armor_trims.util.TrimTextureManager;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
//? if >=1.19
/*import net.minecraft.server.packs.resources.ResourceMetadata;*/
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.io.InputStream;
import java.util.*;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Mixin(class_1059.class)
public class MixinTextureAtlas {
    @Shadow @Final private class_2960 location;

    @Unique private PaletteMaps armor_trims$paletteMaps;

    @Inject(method = "getBasicSpriteInfos", at = @At("HEAD"))
    private void armor_trims$prepareOverlaySpriteNames(class_3300 resourceManager, Set<class_2960> locations, CallbackInfoReturnable<Collection<class_1058.class_4727>> cir) {
        if (this.location == class_1059.field_5275) {
            armor_trims$paletteMaps = Armortrims.trimTextures().getPaletteMaps(resourceManager);
        }
    }

    @WrapOperation(// targeting lambda in getBasicSpriteInfos
            remap = false,
            //? if fabric {
            method = "method_18160",
            //?} elif >=1.18 {
            /*method = {"m_174717_", "method_18160"},
            *///?} else {
            /*method = {"func_224738_a", "method_18160"},
            *///?}
            at = @At(remap = true, value = "INVOKE", target = "Lnet/minecraft/client/renderer/texture/TextureAtlas;getResourceLocation(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;")
    )
    private class_2960 armor_trims$redirectTrimInfoResourceLocation(class_1059 instance, class_2960 location, Operation<class_2960> original, @Share("data") LocalRef<Pair<class_2960, ColorPalette>> data, @Share("originalLocation") LocalRef<class_2960> originalLocation) {
        if (this.location == class_1059.field_5275) {
            Pair<class_2960, ColorPalette> _data = ItemTrimModels.generated.get(location);
            if (_data != null) {
                originalLocation.set(location);
                location = _data.getFirst();
                data.set(_data);
            }
        }
        return original.call(instance, location);
    }

    @WrapOperation(// targeting lambda in getBasicSpriteInfos
            remap = false,
            //? if fabric {
            method = "method_18160",
            //?} elif >=1.18 {
            /*method = {"method_18160", "m_174717_"},
            *///?} else {
            /*method = {"method_18160", "func_224738_a"},
            *///?}
            at = @At(
                    remap = true,
                    value = "INVOKE",
                    //? if >=1.19 {
                    /*target = "Lnet/minecraft/server/packs/resources/ResourceMetadata;getSection(Lnet/minecraft/server/packs/metadata/MetadataSectionSerializer;)Ljava/util/Optional;"
                    *///?} else {
                    target = "Lnet/minecraft/server/packs/resources/Resource;getMetadata(Lnet/minecraft/server/packs/metadata/MetadataSectionSerializer;)Ljava/lang/Object;"
                    //?}
            )
    )
    private /*? if >=1.19 {*//*Optional<?>*//*?} else {*/Object/*?}*/ armor_trims$addTrimSpriteInfos(/*? if >=1.19 {*//*ResourceMetadata*//*?} else {*/class_3298/*?}*/ instance, class_3270/*? if >=1.19 {*//*<?*//*?} else {*/<class_1079/*?}*/> serializer, Operation</*? if >=1.19 {*//*Optional<?>*//*?} else {*/Object/*?}*/> original, @Share("data") LocalRef<Pair<class_2960, ColorPalette>> data, @Share("originalLocation") LocalRef<class_2960> originalLocation) {
        if (this.location == class_1059.field_5275) {
            Map<class_2960, Map<ColorPalette, Pair<class_1011[], class_1079>>> itemTexturesMap = armor_trims$paletteMaps.getItemTexturesMap();

            Pair<class_2960, ColorPalette> _data = data.get();
            if (_data != null && itemTexturesMap.containsKey(_data.getFirst())) {
                Pair<class_1011[], class_1079> image = itemTexturesMap
                        .get(_data.getFirst())
                        .get(_data.getSecond());
                if (image == null) {
                    String err = String.format("Unable to get metadata for %s", originalLocation.get());
                    Armortrims.LOGGER.error(err);
                    //? if >=1.19 {
                    /*return Optional.empty();
                    *///?} else {
                    return class_1079.field_21768;
                    //?}
                }
                //? if >=1.19 {
                /*return Optional.of(image.getSecond());
                *///?} else {
                return image.getSecond();
                //?}

            }
        }
        return original.call(instance, serializer);
    }

    // Replace resourcelocation with the valid one.
    @WrapOperation(method = "load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/texture/TextureAtlas;getResourceLocation(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;"))
    private class_2960 armor_trims$setActualGeneratedTrimSpriteName(class_1059 instance, class_2960 generated, Operation<class_2960> original, @Share("generated") LocalRef<class_2960> outGenerated, @Share("location") LocalRef<class_2960> outLocation) {
        if (this.location == class_1059.field_5275 && !ItemTrimModels.generated.isEmpty()) {
            Pair<class_2960, ColorPalette> location = ItemTrimModels.generated.get(generated);
            if (location != null) {
                outGenerated.set(generated);
                generated = location.getFirst();
            }
            outLocation.set(generated);
        }
        return original.call(instance, generated);
    }

    @WrapOperation(method = "load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/NativeImage;read(Ljava/io/InputStream;)Lcom/mojang/blaze3d/platform/NativeImage;"))
    private class_1011 armor_trims$setSpriteImage(InputStream stream, Operation<class_1011> original, @Share("generated") LocalRef<class_2960> generated, @Share("location") LocalRef<class_2960> location) {
        class_2960 generatedLocation = generated.get();
        if (generatedLocation != null) {
            return armor_trims$paletteMaps
                    .getItemTexturesMap().get(location.get())
                    .get(ItemTrimModels.generated.get(generatedLocation).getSecond())
                    .getFirst()[0];
        } else {
            return original.call(stream);
        }
    }

    @Inject(method = "load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", at = @At("RETURN"))
    private void armor_trims$rememberGeneratedSprite(class_3300 resourceManager, class_1058.class_4727 info, int storageX, int storageY, int mipLevel, int x, int y, CallbackInfoReturnable<class_1058> cir, @Share("generated") LocalRef<class_2960> generated) {
        class_2960 generatedLocation = generated.get();
        if (generatedLocation != null) {
            ItemTrimModels.generatedSprites.put(generatedLocation, cir.getReturnValue());
        }
    }
}