package dev.hipposgrumm.armor_trims.model;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.util.PaletteMaps;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;

public class ArmorTrimTexture extends class_1043 {
    public final PaletteMaps.Entry info;
    protected int tick = 0;

    protected ArmorTrimTexture(PaletteMaps.Entry info, class_1011 image) {
        super(image);
        this.info = info;
    }

    public static ArmorTrimTexture create(PaletteMaps.Entry info, class_1011[] images, Integer[] order) {
        if (images.length > 1) {
            return new ArmorTrimTexture.Animated(info, images, order);
        } else {
            return new ArmorTrimTexture(info, images[0]);
        }
    }

    public static class Animated extends ArmorTrimTexture implements class_1061 {
        protected final class_1011[] frames;
        protected final Integer[] order;

        protected Animated(PaletteMaps.Entry info, class_1011[] images, Integer[] order) {
            super(info, images[0]);
            this.frames = images;
            this.order = order;
        }

        // Based on TextureAtlas#tick()
        protected void nextFrame() {
            class_1011 pixels = method_4525();
            if (pixels == null) return;

            tick++;
            tick %= order.length;

            int frame = order[tick];
            if (frame < 0 || frame >= frames.length) {
                Armortrims.LOGGER.warn("Invalid frame {} in {} of {}", frame, info.color(), info.id());
            }
            pixels.method_4317(frames[order[tick]]);
            method_4524();
        }

        @Override
        public void method_4622() {
            if (frames.length == 1) return;

            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(this::nextFrame);
            } else {
                this.nextFrame();
            }
        }
    }
}
