package dev.hipposgrumm.armor_trims.model;

import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import dev.hipposgrumm.armor_trims.mixinaccess.DuckModelBakery;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

public class ItemTrimModels {
    private static final Map<ItemOverlay, Map<ColorPalette, class_1087>> bakedModels = new HashMap<>();

    // Map<GeneratedResourceLocation, Pair<OverlayTextureLocation, ColorPalette>>
    public static final Map<class_2960, Pair<class_2960, ColorPalette>> generated = new HashMap<>();

    // Map<OverlayTextureLocation, List<Pair<GeneratedResourceLocation, ColorPalette>>>
    public static final Map<class_2960, List<Pair<class_2960, ColorPalette>>> generatedLocations = new HashMap<>();

    // Map<GeneratedResourceLocation, TextureAtlasSprite>
    public static final Map<class_2960, class_1058> generatedSprites = new ConcurrentHashMap<>();

    public static void onReload() {
        bakedModels.clear();
        generated.clear();
        generatedLocations.clear();
        generatedSprites.clear();
    }

    public static void registerModels(Consumer<class_2960> consumer) {
        consumer.accept(new class_2960(Armortrims.MODID, "item/empty_slot_smithing_template_armor_trim"));

        for (ItemOverlay overlay:OverlayRegistry.ITEM_OVERLAYS) {
            consumer.accept(overlay.textureLocation());
        }
    }

    public static void bakeModels(Map<class_2960, class_1087> map, class_1088 bakery) {
        long time = System.nanoTime();
        try {
            for (ItemOverlay overlay:OverlayRegistry.ITEM_OVERLAYS) {
                class_2960 overlayLocation = overlay.textureLocation();
                Map<ColorPalette, class_1087> models = new HashMap<>();
                models.put(ColorPalette.DEFAULT, map.get(overlayLocation));

                List<Pair<class_2960, ColorPalette>> locations = generatedLocations.get(overlay.textureLocation());
                if (locations != null) for (Pair<class_2960, ColorPalette> location : locations) {
                    ((DuckModelBakery) bakery).armor_trims$setTrimAtlasTexture(location.getFirst());
                    models.put(
                            location.getSecond(),
                            bakery.method_15878(overlayLocation, class_1086.field_5350)
                    );
                }
                bakedModels.put(overlay, models);
            }
        } finally { // In case something happens, don't break the game.
            ((DuckModelBakery)bakery).armor_trims$setTrimAtlasTexture(null);
            Armortrims.LOGGER.debug("Model baking took {} seconds.", (System.nanoTime()-time)/1000000000f);
        }
    }

    public static Function<class_4730, class_1058> getSpriteFunction(Function<class_4730, class_1058> original, class_2960 location) {
        class_1058 sprite = generatedSprites.get(location);
        if (sprite != null) return m -> sprite;
        return original;
    }

    // Returns the model and a boolean depicting if it has color.
    public static Pair<class_1087, Boolean> getModel(ItemOverlay overlay, ColorPalette palette) {
        Map<ColorPalette, class_1087> coloredModels = bakedModels.getOrDefault(overlay, bakedModels.get(OverlayRegistry.defaultItemOverlay()));
        if (coloredModels == null) return null;
        class_1087 model = coloredModels.get(palette);
        if (model != null) {
            return new Pair<>(model, true);
        } else {
            return new Pair<>(coloredModels.get(ColorPalette.DEFAULT), false);
        }
    }
}
