package dev.hipposgrumm.armor_trims.recipes;

import com.google.gson.JsonObject;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.config.Config;
import dev.hipposgrumm.armor_trims.api.trimming.TrimGetter;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.world.item.*;

public class UntrimmingSpecialRecipe extends class_1852 {
    public static final class_2960 ID = new class_2960(Armortrims.MODID,"crafting_special_untrimming");

    public UntrimmingSpecialRecipe(class_2960 location) {
        super(location);
    }

    public boolean matches(class_1715 crafting, class_1937 level) {
        boolean hasTrimmedItem = false;
        boolean hasShearsItem = false;

        for(int i = 0; i < crafting.method_5439(); i++) {
            class_1799 item = crafting.method_5438(i);
            if (!item.method_7960()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(item) ) {
                    hasTrimmedItem = true;
                } else if (item/*? if <1.18.2 {*//*.getItem()*//*?}*/.method_31573(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    hasShearsItem = true;
                }
            }
        }

        return hasTrimmedItem && hasShearsItem;
    }

    public class_1799 assemble(class_1715 crafting) {
        class_1799 trimmedItem = class_1799.field_8037;
        class_1799 shearsItem = class_1799.field_8037;

        for(int i = 0; i < crafting.method_5439(); ++i) {
            class_1799 testTrimmedItem = crafting.method_5438(i);
            if (!testTrimmedItem.method_7960() && TrimGetter.isTrimmed(testTrimmedItem)) {
                trimmedItem = testTrimmedItem;
                break;
            }
        }

        for(int i = 0; i < crafting.method_5439(); ++i) {
            class_1799 testShearsItem = crafting.method_5438(i);
            if (!testShearsItem.method_7960() && testShearsItem/*? if <1.18.2 {*//*.getItem()*//*?}*/.method_31573(ArmortrimsInternalUtils.SHEARS_TAG)) {
                shearsItem = testShearsItem;
                break;
            }
        }

        class_1799 finalItem = trimmedItem.method_7972();
        TrimGetter.clearTrim(finalItem);
        if (shearsItem.method_7919()>=shearsItem.method_7936()) shearsItem.method_7934(1);

        return !Config.enableUntrimming?class_1799.field_8037:finalItem;
    }

    @Override
    public class_2371<class_1799> getRemainingItems(class_1715 crafting) {
        class_2371<class_1799> nonnulllist = class_2371.method_10213(crafting.method_5439(), class_1799.field_8037);
        boolean hasTrimmedItem = false;

        for(int i = 0; i < nonnulllist.size(); ++i) {
            class_1799 itemstack = crafting.method_5438(i);
            if (!itemstack.method_7960()) {
                if (!hasTrimmedItem && TrimGetter.isTrimmed(itemstack)) {
                    hasTrimmedItem = true;
                } else if (itemstack/*? if <1.18.2 {*//*.getItem()*//*?}*/.method_31573(ArmortrimsInternalUtils.SHEARS_TAG)) {
                    class_1799 shearsItem = itemstack.method_7972();
                    shearsItem.method_7974(itemstack.method_7919()-1);
                    nonnulllist.set(i, shearsItem);
                }
            }
        }

        return nonnulllist;
    }

    public boolean method_8113(int width, int height) {
        return (width > 0 && height > 0) && (width > 1 || height > 1); // Two items.
    }

    public class_1865<?> method_8119() {
        return Armortrims.UNTRIMMING_RECIPE.get();
    }

    public static class Serializer implements class_1865<UntrimmingSpecialRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public UntrimmingSpecialRecipe method_8121(class_2960 id, JsonObject json) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public UntrimmingSpecialRecipe method_8122(class_2960 id, class_2540 buf) {
            return new UntrimmingSpecialRecipe(id);
        }

        @Override
        public void toNetwork(class_2540 buf, UntrimmingSpecialRecipe recipe) {}

        //? if forge {
        /*public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        public ResourceLocation getRegistryName() {
            return UntrimmingSpecialRecipe.ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        @SuppressWarnings("unchecked") // Need this wrapper, because generics.
        private static <G> Class<G> castClass(Class<?> cls) {
            return (Class<G>)cls;
        }
        *///?}
    }
}