package dev.hipposgrumm.armor_trims.util;

import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import dev.hipposgrumm.armor_trims.api.TrimRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.TrimPattern;
import dev.hipposgrumm.armor_trims.api.trimming.trim_pattern.ArmorTrimPattern;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_151;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6862;

public class PaletteMaps {
    private final class_3300 resourceManager;
    // Map<OverlayResourceLocation, TextureData>
    private Map<class_2960, Map<ColorPalette, Pair<class_1011[], class_1079>>> itemTexturesMap;

    // These are hashmaps so that the values can be overridden.
    private final Map<String, Entry> tags = new HashMap<>();
    private final Map<String, Entry> items = new HashMap<>();
    private List<Entry> entries;

    public PaletteMaps(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void addTag(String tag, String palette) {
        this.tags.put(tag, new Entry(new class_2960(tag), palette, true));
    }

    public void addItem(String item, String palette) {
        this.items.put(item, new Entry(new class_2960(item), palette, false));
    }

    public synchronized List<Entry> entries() {
        if (entries == null) entries = Stream.concat(tags.values().stream(), items.values().stream()).collect(Collectors.toList());
        return entries;
    }

    public synchronized Map<class_2960, Map<ColorPalette, Pair<class_1011[], class_1079>>> getItemTexturesMap() {
        if (itemTexturesMap == null) processItems();
        return itemTexturesMap;
    }

    synchronized void prepareColors() {
        // Add colors from tags.
        for (Entry tag : tags.values()) {
            if (tag.color != null) continue;
            entries = null;

            try {
                class_2960 location = new class_2960(tag.palette);
                location = new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png");
                //? if >=1.19 {
                /*try {
                    Optional<Resource> resource = resourceManager.getResource(location);
                    if (resource.isEmpty()) {
                        Armortrims.LOGGER.error("Palette at {} not found!", location);
                        return;
                    }
                *///?} else {
                try (class_3298 resource = resourceManager.method_14486(location)) {
                //?}
                    tag.color = ColorPaletteManager.add(
                            //? if >=1.18.2 {
                            class_6862.method_40092(class_2378.field_25108,
                            //?} elif forge {
                            /*ItemTags.createOptional(
                            *///?} else {
                            /*TagRegistry.item(
                            *///?}
                                    tag.id),
                            location,
                            class_1011.method_4309(resource./*? if >=1.19 {*//*get().open*//*?} else {*/method_14482/*?}*/()),
                            resource./*? if >=1.19 {*//*get().metadata().getSection*//*?} else {*/method_14481/*?}*/(class_1079.field_5337)/*? if >=1.19 {*//*.orElse(null)*//*?}*/
                    );
                } catch (class_151 e) {
                    Armortrims.LOGGER.warn("#{} has invalid resourcelocation {}", tag.id, location);
                } catch (Exception e) {
                    Armortrims.LOGGER.error("#{} had a problem while loading {}", tag.id, location);
                }
            } catch (class_151 e) {
                Armortrims.LOGGER.warn("#{} has invalid palette resourcelocation {}", tag.id, tag.palette);
            }
        }

        // Add colors from items.
        for (Entry item : items.values()) {
            if (item.color != null) continue;
            entries = null;

            try {
                class_2960 location = new class_2960(item.palette);
                location = new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png");
                //? if >=1.19 {
                /*try {
                    Optional<Resource> resource = resourceManager.getResource(location);
                    if (resource.isEmpty()) {
                        Armortrims.LOGGER.error("Palette at {} not found!", location);
                        return;
                    }
                *///?} else {
                try (class_3298 resource = resourceManager.method_14486(location)) {
                //?}
                    item.color = ColorPaletteManager.add(
                            item.id,
                            location,
                            class_1011.method_4309(resource./*? if >=1.19 {*//*get().open*//*?} else {*/method_14482/*?}*/()),
                            resource./*? if >=1.19 {*//*get().metadata().getSection*//*?} else {*/method_14481/*?}*/(class_1079.field_5337)/*? if >=1.19 {*//*.orElse(null)*//*?}*/
                    );
                } catch (class_151 e) {
                    Armortrims.LOGGER.warn("{} has invalid resourcelocation {}", item.id, location);
                } catch (Exception e) {
                    Armortrims.LOGGER.error("{} had a problem while loading {}", item.id, location);
                }
            } catch (class_151 e) {
                Armortrims.LOGGER.warn("{} has invalid palette resourcelocation {}", item.id, item.palette);
            }
        }
    }

    void processItems() {
        Map<class_2960, Map<ColorPalette, Pair<class_1011[], class_1079>>> map = new HashMap<>();

        // Create item textures for all palettes.
        List<Entry> entries = entries();
        List<ColorPalette> colors = entries.stream().map(Entry::color).collect(Collectors.toList());
        for (ItemOverlay overlay:OverlayRegistry.ITEM_OVERLAYS) {
            class_2960 location = overlay.textureLocation();
            location = new class_2960(location.method_12836(), "textures/"+location.method_12832()+".png");
            map.put(overlay.textureLocation(), TrimTextureManager.makeTextures(overlay.textureLocation(), location, entries, colors, true));
        }

        this.itemTexturesMap = map;
    }

    void processArmor() {
        // Create armor textures for all palettes.
        List<Entry> entries = entries();
        List<ColorPalette> colors = entries.stream().map(Entry::color).collect(Collectors.toList());
        class_2960 layer;
        for (TrimPattern pattern:TrimRegistry.ITEM_TRIMS) {
            if (pattern instanceof ArmorTrimPattern) {
                ArmorTrimPattern trimPattern = (ArmorTrimPattern) pattern;
                layer = trimPattern.getLayer0();
                TrimTextureManager.makeTextures(layer, layer, entries, colors, false);

                layer = trimPattern.getLayer1();
                TrimTextureManager.makeTextures(layer, layer, entries, colors, false);
            }
        }

        TrimTextureManager.onReloadDone();
    }

    public static class Entry {
        final class_2960 id;
        final String palette;
        final boolean isTag;

        ColorPalette color;

        public Entry(class_2960 id, String palette, boolean isTag) {
            this.id = id;
            this.palette = palette;
            this.isTag = isTag;
        }

        public class_2960 id() {
            return id;
        }

        public ColorPalette color() {
            return color;
        }

        public boolean isTag() {
            return isTag;
        }
    }
}
