package dev.hipposgrumm.armor_trims.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.model.ArmorTrimTexture;
import dev.hipposgrumm.armor_trims.model.ItemTrimModels;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_1059;
import net.minecraft.class_1079;
import net.minecraft.class_1739;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6862;

//? if forge {
/*import net.minecraftforge.registries.ForgeRegistries;
*///?}

// Class for managing all the generated trim textures.
public class TrimTextureManager {
    public static final String TRIM_DEFINITION_LOCATION = "textures/trims/color_palettes.json";

    private PaletteMaps paletteMaps;

    // Map<MaterialTag,Map<TrimTexture,GeneratedResourceLocation>>
    // Textures for tag-defined trims.
    private static final Map<class_2960, Map<class_2960,class_2960>> tagTrimTextures = new HashMap<>();

    // Map<Material,Map<TrimTexture,GeneratedResourceLocation>>
    // Textures for item-defined trims.
    private static final Map<class_2960, Map<class_2960,class_2960>> trimTextures = new HashMap<>();

    // Map<Material,MaterialTag>
    // Map items from their item tags.
    private static final Map<class_2960, class_2960> tagItemTrimTextures = new HashMap<>();

    // Map<TagLocation,Tag>
    // This is because it broke sub-1.18
    private static final Map<class_2960, /*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792>> tagRefs = new HashMap<>();

    private static boolean loading = true;
    private static long count = 0;

    private boolean prepared = false;

    public TrimTextureManager() {}

    public boolean ready() {
        return paletteMaps != null;
    }

    public synchronized PaletteMaps getPaletteMaps(class_3300 resourceManager) {
        if (paletteMaps == null) loadPalettes(resourceManager);
        return paletteMaps;
    }

    private void loadPalettes(class_3300 resourceManager) {
        PaletteMaps paletteMaps = new PaletteMaps(resourceManager);
        for (String namespace:resourceManager.method_14487()) {
            //? if <1.19
            try {
                List<class_3298> resourceList = resourceManager./*? if >=1.19 {*//*getResourceStack*//*?} else {*/method_14489/*?}*/(new class_2960(namespace, TRIM_DEFINITION_LOCATION));
            //? if >=1.19
            /*if (!resourceList.isEmpty()) {*/
                boolean successful = false;
                for (class_3298 resource : resourceList) {
                    try {
                        try {
                            InputStream inputstream = resource./*? if >=1.19 {*//*open*//*?} else {*/method_14482/*?}*/();
                            try {
                                Reader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8); // Not AutoClosable
                                try {
                                    JsonObject parsableJsonObject = class_3518.method_15255(reader);
                                    if (parsableJsonObject.has("tag") && parsableJsonObject.get("tag").isJsonArray())
                                        for (JsonElement tag:parsableJsonObject.get("tag").getAsJsonArray()) {
                                            JsonObject object = tag.getAsJsonObject();
                                            paletteMaps.addTag(object.get("id").getAsString(), object.get("path").getAsString());

                                        }
                                    if (parsableJsonObject.has("item") && parsableJsonObject.get("item").isJsonArray())
                                        for (JsonElement item:parsableJsonObject.get("item").getAsJsonArray()) {
                                            JsonObject object = item.getAsJsonObject();
                                            paletteMaps.addItem(object.get("id").getAsString(), object.get("path").getAsString());
                                        }
                                    successful = true;
                                } catch (Throwable parseError) {
                                    try {
                                        reader.close();
                                    } catch (Throwable closeError) {
                                        parseError.addSuppressed(closeError);
                                    }
                                    throw parseError;
                                }
                                reader.close();
                            } catch (Throwable readError) { // Probably not what this actually may catch, but that is what I made of it.
                                if (inputstream != null) {
                                    try {
                                        inputstream.close();
                                    } catch (Throwable closeError) {
                                        readError.addSuppressed(closeError);
                                    }
                                }
                                throw readError;
                            }
                            if (inputstream != null) inputstream.close();
                        } catch (RuntimeException e) {
                            Armortrims.LOGGER.warn("Invalid {} in namespace: '{}'", TRIM_DEFINITION_LOCATION, namespace);
                        }
                    } catch (Throwable ignored) {}
                    //? if <1.19
                    if (resource != null) resource.close();
                }
                if (successful) Armortrims.LOGGER.debug("Loaded trim palettes definition from {}.", namespace);
                else Armortrims.LOGGER.error("Found trim palettes definition in {}, but it didn't load properly.", namespace);
            //? if >=1.19 {
            /*} else {
            *///?} else {
            } catch (IOException ignored) {
            //?}
                if (Armortrims.MODID.equals(namespace)) Armortrims.LOGGER.error("Palettes definition not found in {}!", namespace);
                else Armortrims.LOGGER.debug("No trim palettes definition in {}.", namespace);
            }
        }
        paletteMaps.prepareColors();
        this.paletteMaps = paletteMaps;
    }

    //@Override
    public Stream<class_2960> getResourcesToLoad() {
        List<class_2960> ids = new ArrayList<>();

        int count = 0;
        PaletteMaps paletteMaps = getPaletteMaps(class_310.method_1551().method_1478());
        Map<class_2960, Map<ColorPalette, Pair<class_1011[], class_1079>>> itemTexturesMap = paletteMaps.getItemTexturesMap();
        for (class_2960 overlayLocation:itemTexturesMap.keySet()) {
            List<Pair<class_2960, ColorPalette>> generated = new ArrayList<>();
            for (PaletteMaps.Entry entry:paletteMaps.entries()) {
                class_2960 id = new class_2960(Armortrims.MODID, "generateditem_" + Long.toString(count, Character.MAX_RADIX));
                count++;

                ColorPalette color = entry.color();
                ItemTrimModels.generated.put(id, new Pair<>(overlayLocation, color));
                generated.add(new Pair<>(id, color));
                ids.add(id);
            }
            ItemTrimModels.generatedLocations.put(overlayLocation, generated);
        }

        return ids.stream();
    }

    public class_1059.class_4007 prepare(Stream<class_2960> res, Function<Stream<class_2960>, class_1059.class_4007> original) {
        // Unready the data.
        this.paletteMaps = null;
        ColorPaletteManager.onReload();
        ItemTrimModels.onReload();

        // Container is redefined by a call here.
        class_1059.class_4007 preparations = original.apply(Stream.concat(res, getResourcesToLoad()));

        loading = true;

        tagTrimTextures.clear();
        trimTextures.clear();

        prepared = true;
        return preparations;
    }

    public void apply() {
        if (!prepared) return;
        paletteMaps.processArmor();
        class_310.method_1551().method_1531().method_4616(new class_2960(Armortrims.MODID, "palette_ticker"), new ColorPaletteManager());
        prepared = false;
    }

    public static Map<ColorPalette, Pair<class_1011[], class_1079>> makeTextures(class_2960 texture, class_2960 location, List<PaletteMaps.Entry> entries, List<ColorPalette> colors, boolean forItem) {
        if (!forItem) {
            RenderSystem.recordRenderCall(() -> {
                class_310.method_1551().method_1531().method_4616(texture, new class_1049(location));
                Armortrims.LOGGER.debug("Registered default for texture {}.", texture);
            });
        }

        //? if >=1.19 {
        /*try {
            Optional<Resource> resource = Minecraft.getInstance().getResourceManager().getResource(location);
            if (resource.isEmpty()) {
                Armortrims.LOGGER.error(String.format("Resource %s is missing!", location));
                return null;
            }
        *///?} else {
        try (class_3298 resource = class_310.method_1551().method_1478().method_14486(location)) {
        //?}
            class_1011 baseImage = class_1011.method_4309(resource./*? if >=1.19 {*//*get().open*//*?} else {*/method_14482/*?}*/());

            Map<ColorPalette, Pair<class_1011[], class_1079>> textures = ColorPalette.apply(colors, baseImage, forItem);

            if (forItem) return textures;

            for (PaletteMaps.Entry entry:entries) {
                // Register the texture.
                class_2960 id = new class_2960(Armortrims.MODID,"generated_"+Long.toString(count,Character.MAX_RADIX));
                count++;

                boolean isTag = entry.isTag();
                Pair<class_1011[], class_1079> images = textures.get(entry.color());
                RenderSystem.recordRenderCall(() -> {
                    if (images.getFirst().length == 0) return;

                    List<Integer> frames = new ArrayList<>();
                    entry.color().forEachFrame((index,time) -> {
                        for (int i=0;i<time;i++) frames.add(index);
                    }, true);
                    class_310.method_1551().method_1531().method_4616(id, ArmorTrimTexture.create(entry, images.getFirst(), frames.toArray(new Integer[0])));

                    if (isTag) {
                        tagRefs.computeIfAbsent(entry.id(),
                                //? if >=1.18.2 {
                                (k) -> class_6862.method_40092(class_2378.field_25108, k)
                                //?} elif forge {
                                /*ItemTags::createOptional
                                *///?} else {
                                /*TagRegistry::item
                                *///?}
                        );
                        tagTrimTextures.compute(entry.id(), (k, map) -> {
                            if (map == null) map = new HashMap<>();
                            map.put(texture, id);
                            return map;
                        });
                    } else {
                        trimTextures.compute(entry.id(), (k, map) -> {
                            if (map == null) map = new HashMap<>();
                            map.put(texture, id);
                            return map;
                        });
                    }

                    Armortrims.LOGGER.debug("Applied palette of {} to texture {}.", (isTag?"#":"")+entry.id(), texture);
                });
            }
        } catch (Exception e) {
            Armortrims.LOGGER.error("Failed to apply any or all color palettes to texture {}.", texture);
        }
        return null;
    }

    // Get the texture to render, with the animation frame already set.
    public static class_2960 get(class_2960 trimTexture, class_2960 material) {
        if (loading) return null;

        if (trimTextures.containsKey(material)) {
            // Explicitly-Defined Trim Texture
            return trimTextures.get(material).getOrDefault(trimTexture, trimTexture);
        } else if (tagItemTrimTextures.containsKey(material)) {
            // Tag-Defined Trim Texture
            class_2960 tag = tagItemTrimTextures.get(material);
            if (tag == null) return trimTexture; // For if not existing.
            Map<class_2960, class_2960> textures = tagTrimTextures.get(tag);
            if (textures == null) return trimTexture;
            return textures.getOrDefault(trimTexture, trimTexture);
        } else {
            // Search all tags for a texture.
            //? if forge {
            /*Item item = ForgeRegistries.ITEMS.getValue(material);
            *///?} else {
            class_1792 item = class_2378.field_11142.method_10223(material);
            //?}
            if (!(item instanceof class_1739)) {
                class_2960 tag = null;
                for (Map.Entry<class_2960, /*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792>> t : tagRefs.entrySet()) if (item/*? if >=1.18.2 {*/.method_7854()/*?}*/.method_31573(t.getValue())) tag = t.getKey();
                // Add item to this list for quicker lookup later.
                tagItemTrimTextures.put(material,tag); // If no tag is matching this will be null.
            }
        }

        return trimTexture;
    }

    public static void onReloadDone() {
        loading = false;
    }

    public static void onReloadData() {
        // On Datapack Reload
        tagItemTrimTextures.clear();
    }
}
