package dev.hipposgrumm.armor_trims.util.color;

import dev.hipposgrumm.armor_trims.Armortrims;
import java.util.*;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_1739;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6862;

//? if forge {
/*import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
*///?}

// This class extends AbstractTexture so that it can be ticked as a texture.
public class ColorPaletteManager extends class_1044 implements class_1061 {
    private static final Map</*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792>, ColorPalette> colorListTags = new HashMap<>();
    // Map<ItemID, ColorPalette>
    private static final Map<class_2960, ColorPalette> colorList = new HashMap<>();

    // This is a shortcut to associate an item with a tag without needing to go through all the tags.
    private static final Map<class_2960, /*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792>> itemTagColorMap = new HashMap<>();
    private static final Set<class_2960> noTaggedColors = new HashSet<>();

    private static final List<ColorPalette> colorPalettes = new ArrayList<>();

    public static void onReload() {
        // Mark all colors as discarded. This only benefits the NetheriteUpgradeSmithingTemplate.DiamondColored component class. It was added pretty late which is why this value isn't used much.
        for (ColorPalette color:colorPalettes) color.discard();
        colorPalettes.clear();

        colorListTags.clear();
        colorList.clear();
        noTaggedColors.clear();
    }

    public static void onReloadData() {
        itemTagColorMap.clear();
        noTaggedColors.clear();
    }

    public static ColorPalette add(class_2960 id, class_1792 item) {
        ColorPalette.SingleColorPalette color = new ColorPalette.SingleColorPalette(id,item);
        if (!color.isValid()) {
            colorList.put(id,ColorPalette.DEFAULT);
            Armortrims.LOGGER.debug("No color created for {}, using default instead.", id);
            return ColorPalette.DEFAULT;
        }
        colorList.put(id,color);
        colorPalettes.add(color);
        return color;
    }

    public static ColorPalette add(/*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792> tag, class_2960 id, class_1011 texture, class_1079 meta) {
        ColorPalette color = new ColorPalette(id,texture,meta);
        colorListTags.put(tag,color);
        colorPalettes.add(color);
        return color;
    }

    public static ColorPalette add(class_2960 item, class_2960 id, class_1011 texture, class_1079 meta) {
        ColorPalette color = new ColorPalette(id,texture,meta);
        colorList.put(item,color);
        colorPalettes.add(color);
        return color;
    }

    //? if forge
    /*private static final ResourceLocation BARRIER_LOCATION = ForgeRegistries.ITEMS.getKey(Items.BARRIER);*/
    public static ColorPalette get(class_2960 resourceLocation) {
        // Missingno = DEFAULT
        if (resourceLocation.equals(class_1047.method_4539())) return ColorPalette.DEFAULT;
        // Barrier also = DEFAULT
        //? if forge
        /*if (resourceLocation.equals(BARRIER_LOCATION)) return ColorPalette.DEFAULT;*/

        if (noTaggedColors.contains(resourceLocation)) {
            // Get color because no tag.
            return colorList.getOrDefault(resourceLocation, ColorPalette.DEFAULT);
        }

        // Check if the item is in a defined tag.
        /*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792> tag = itemTagColorMap.get(resourceLocation);
        if (tag != null) {
            ColorPalette color = colorListTags.get(tag);
            if (color != null) return color;
            // after this means that the color is no longer associated with a tag
            itemTagColorMap.remove(resourceLocation);
        }

        // Assign tag if not set up, or assign color for non-defined color.
        //? if forge {
        /*if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            Item item = ForgeRegistries.ITEMS.getValue(resourceLocation);
        *///?} else {
        if (class_2378.field_11142.method_10250(resourceLocation)) {
            class_1792 item = class_2378.field_11142.method_10223(resourceLocation);
        //?}
            if (item != null && !(item instanceof class_1739)) {
                //? if >=1.18 {
                class_1799 itemInstance = item.method_7854();
                //?} else {
                /*Item itemInstance = item;
                *///?}
                // Check all tags for item. Select last.
                for (/*? if >=1.18.2 {*/class_6862/*?} else {*//*Tag*//*?}*/<class_1792> t:colorListTags.keySet()) if (itemInstance.method_31573(t)) tag = t;
                if (tag != null) {
                    // Tag found, add shortcut.
                    itemTagColorMap.put(resourceLocation,tag);
                    return colorListTags.get(tag);
                }
                // No tag, create color palette.
                noTaggedColors.add(resourceLocation);
                ColorPalette color = colorList.get(resourceLocation);
                if (color == null) color = add(resourceLocation, item);
                return color;
            }
        }

        // When all else fails, DEFAULT.
        colorList.put(resourceLocation,ColorPalette.DEFAULT);
        noTaggedColors.add(resourceLocation);
        return ColorPalette.DEFAULT;
    }

    @Override
    public void method_4622() {
        for (int i=0;i<colorPalettes.size();i++) {
            colorPalettes.get(i).method_4622();
        }
    }


    
    // Abstraction of AbstractTexture
    public void method_4527(boolean blur, boolean mipmap) {}

    public int method_4624() {
        return 0;
    }

    public void method_4528() {}

    public void method_4625(class_3300 resourceManager) {}

    public void method_23207() {}
}
