/*
 * Decompiled with CFR 0.152.
 */
package cn.cp.lib.init;

import cn.cp.lib.CpLibMod;
import cn.cp.lib.init.CpLibModScreens;
import cn.cp.lib.network.MenuStateUpdateMessage;
import cn.cp.lib.world.inventory.JpConfirmMenu;
import cn.cp.lib.world.inventory.ReactorCoreGUIMenu;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CpLibModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"cp_lib");
    public static final RegistryObject<MenuType<JpConfirmMenu>> JP_CONFIRM = REGISTRY.register("jp_confirm", () -> IForgeMenuType.create(JpConfirmMenu::new));
    public static final RegistryObject<MenuType<ReactorCoreGUIMenu>> REACTOR_CORE_GUI = REGISTRY.register("reactor_core_gui", () -> IForgeMenuType.create(ReactorCoreGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CpLibMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CpLibModScreens.ScreenAccessor) {
                    CpLibModScreens.ScreenAccessor accessor = (CpLibModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                CpLibMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

