/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.deadeye;

import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.module.tps.GSTpsModule;
import com.namefix.DeadeyeMod;
import com.namefix.data.DeadeyeTarget;
import com.namefix.data.PlayerSaveData;
import com.namefix.data.PlayerServerData;
import com.namefix.deadeye.DeadeyeEffects;
import com.namefix.deadeye.DeadeyeProfiles;
import com.namefix.handlers.ConfigHandler;
import com.namefix.handlers.KeybindHandler;
import com.namefix.integrations.PointBlankIntegration;
import com.namefix.integrations.SAGIntegration;
import com.namefix.integrations.TACZIntegration;
import com.namefix.network.DeadeyeNetworking;
import com.namefix.utils.Utils;
import com.vicmatskiv.pointblank.item.FireMode;
import com.vicmatskiv.pointblank.item.GunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_5272;
import net.minecraft.class_634;
import org.joml.Vector3f;

public class DeadeyeClient {
    public static PlayerSaveData playerData = new PlayerSaveData();
    public static boolean isEnabled = false;
    public static PlayerServerData.ShootingPhase shootingPhase = PlayerServerData.ShootingPhase.NONE;
    public static float deadeyeEnding = 0.0f;
    public static List<class_1299<?>> deadeyeMarkableEntities = ConfigHandler.LoadDeadeyeMarkableEntities();
    public static List<class_1792> deadeyeMarkingItems = ConfigHandler.LoadDeadeyeMarkingItems();
    static ArrayList<DeadeyeTarget> marks = new ArrayList();
    public static boolean shootingMarks = false;
    static long markWait = 0L;
    static long lerpWait = 0L;
    static long shootWait = 0L;
    static long startLerpingTime = 0L;
    static class_1792 shootStartItem = null;

    private DeadeyeClient() {
    }

    public static void initializeBowProperties() {
        class_5272.method_27879((class_1792)class_1802.field_8102, (class_2960)class_2960.method_43902((String)"minecraft", (String)"pull"), (itemStack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.method_6115() && entity.method_6030() == itemStack) {
                int useTicks = entity.method_6048();
                float adjustedUseTicks = (float)useTicks * (isEnabled ? 4.0f : 1.0f);
                return Math.min(adjustedUseTicks / 20.0f, 1.0f);
            }
            return 0.0f;
        });
        class_5272.method_27879((class_1792)class_1802.field_8399, (class_2960)class_2960.method_43902((String)"minecraft", (String)"pull"), (itemStack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.method_6115() && entity.method_6030() == itemStack) {
                int useTicks = entity.method_6048();
                float adjustedUseTicks = (float)useTicks * (isEnabled ? 4.0f : 1.0f);
                return Math.min(adjustedUseTicks / 20.0f, 1.0f);
            }
            return 0.0f;
        });
    }

    public static void deadeyeListener(class_310 client) {
        while (KeybindHandler.keyDeadeyeToggle.method_1436()) {
            DeadeyeClient.requestDeadeye();
        }
        if (DeadeyeClient.playerData.deadeyeSkill == 1) {
            DeadeyeClient.mark(client);
        } else {
            while (KeybindHandler.keyDeadeyeMark.method_1436()) {
                DeadeyeClient.mark(client);
            }
        }
        while (KeybindHandler.keyDeadeyeShootTargets.method_1436() && !marks.isEmpty()) {
            assert (client.field_1724 != null);
            DeadeyeClient.startShootingTargets(client.field_1724.method_31548().method_7391().method_7909());
        }
        while (KeybindHandler.keyDeadeyeQuickdraw.method_1436() && !isEnabled) {
            DeadeyeClient.performQuickdraw();
        }
        if (client.field_1690.field_1886.method_1434()) {
            if (isEnabled && (DeadeyeClient.playerData.deadeyeSkill == 1 || DeadeyeClient.playerData.deadeyeSkill == 2)) {
                DeadeyeClient.requestDeadeye();
            }
            if (!marks.isEmpty()) {
                DeadeyeClient.startShootingTargets(client.field_1724.method_31548().method_7391().method_7909());
            }
        }
    }

    public static void render(WorldRenderContext worldRenderContext) {
        DeadeyeClient.shootingTick(worldRenderContext);
        DeadeyeEffects.heartbeatTick();
        DeadeyeEffects.updateVariables(worldRenderContext);
    }

    private static void performQuickdraw() {
        class_310 client = class_310.method_1551();
        class_1661 inventory = client.field_1724.method_31548();
        int targetSlot = -1;
        for (int i = 0; i <= 8; ++i) {
            class_1799 stackInSlot = inventory.method_5438(i);
            for (class_1792 targetStack : deadeyeMarkingItems) {
                if (!class_1799.method_7984((class_1799)stackInSlot, (class_1799)targetStack.method_7854())) continue;
                targetSlot = i;
                break;
            }
            if (targetSlot != -1) break;
        }
        DeadeyeClient.requestDeadeye();
        if (targetSlot != -1) {
            inventory.field_7545 = targetSlot;
        }
    }

    private static void shootingTick(WorldRenderContext worldRenderContext) {
        if (class_310.method_1551().method_1493() || !isEnabled) {
            return;
        }
        if (marks.isEmpty() || !shootingMarks) {
            return;
        }
        if (System.currentTimeMillis() < lerpWait) {
            return;
        }
        GSClientController gsclient = GSClientController.getInstance();
        GSTpsModule tps = gsclient.getTpsModule();
        class_310 client = class_310.method_1551();
        float slowdownMultiplier = 20.0f / tps.getTps();
        assert (client.field_1724 != null);
        class_1799 item = client.field_1724.method_6047();
        if (!item.method_7909().equals(shootStartItem)) {
            DeadeyeClient.requestDeadeye();
            return;
        }
        DeadeyeTarget mark = marks.get(0);
        float pPitch = client.field_1724.method_36455();
        float pYaw = client.field_1724.method_36454();
        float interpolationFactor = DeadeyeMod.CONFIG.server.markFocusSpeed() * client.method_1534() * slowdownMultiplier;
        if (System.currentTimeMillis() - startLerpingTime > 3000L) {
            interpolationFactor *= 4.0f;
        }
        if (PointBlankIntegration.isLoaded && PointBlankIntegration.getGunFiremode(item) == FireMode.AUTOMATIC) {
            interpolationFactor *= 8.0f;
        }
        class_241 targetHeading = mark.getCurrentHeading();
        float targetPitch = targetHeading.field_1343;
        float targetYaw = targetHeading.field_1342;
        float shortestYaw = pYaw + class_3532.method_15393((float)(targetYaw - pYaw));
        float newYaw = class_3532.method_16439((float)interpolationFactor, (float)pYaw, (float)shortestYaw);
        float shortestPitch = pPitch + class_3532.method_15393((float)(targetPitch - pPitch));
        float newPitch = class_3532.method_16439((float)interpolationFactor, (float)pPitch, (float)shortestPitch);
        if (System.currentTimeMillis() - startLerpingTime > 10000L) {
            newPitch = targetPitch;
            newYaw = targetYaw;
        }
        client.field_1724.method_36457(newPitch);
        client.field_1724.method_36456(newYaw);
        float wrappedNewPitch = class_3532.method_15393((float)newPitch);
        float wrappedTargetPitch = class_3532.method_15393((float)targetPitch);
        float wrappedNewYaw = class_3532.method_15393((float)newYaw);
        float wrappedTargetYaw = class_3532.method_15393((float)targetYaw);
        if (Math.abs(wrappedTargetPitch - wrappedNewPitch) < 1.0f && Math.abs(wrappedTargetYaw - wrappedNewYaw) < 1.0f) {
            if (shootWait == 0L) {
                shootWait = System.currentTimeMillis() + 250L;
            }
            if (System.currentTimeMillis() < shootWait) {
                return;
            }
            DeadeyeMod.TargetingInteractionType targetingType = Utils.getTargetingInteractionType(item);
            if (targetingType == DeadeyeMod.TargetingInteractionType.POINT_BLANK_GUN && !PointBlankIntegration.canGunShoot(item)) {
                return;
            }
            if (targetingType == DeadeyeMod.TargetingInteractionType.TACZ_GUN && !TACZIntegration.canGunShoot(item)) {
                return;
            }
            if (targetingType == DeadeyeMod.TargetingInteractionType.SAG_GUN && !SAGIntegration.canGunShoot((class_1657)client.field_1724, item)) {
                return;
            }
            assert (client.field_1761 != null);
            switch (targetingType) {
                case BOW: {
                    break;
                }
                case THROWABLE: {
                    client.field_1761.method_2919((class_1657)client.field_1724, client.field_1724.method_6058());
                    break;
                }
                case POINT_BLANK_GUN: {
                    PointBlankIntegration.shootGun((GunItem)item.method_7909(), (class_1657)client.field_1724, mark.target);
                    break;
                }
                case TACZ_GUN: {
                    TACZIntegration.shootGun();
                    break;
                }
                case SAG_GUN: {
                    SAGIntegration.shootGun((class_1657)client.field_1724, item);
                    break;
                }
                case DEFAULT: {
                    class_304.method_1420((class_3675.class_306)client.field_1690.field_1886.method_1429());
                }
            }
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(targetingType.ordinal());
            packet.method_49068(mark.getCurrentOffset().method_46409());
            ClientPlayNetworking.send((class_2960)DeadeyeNetworking.DEADEYE_SHOT_REQUEST, (class_2540)packet);
            if (!marks.isEmpty()) {
                marks.remove(0);
            }
            lerpWait = System.currentTimeMillis() + 100L;
            shootWait = 0L;
            startLerpingTime = System.currentTimeMillis();
        }
    }

    private static void startShootingTargets(class_1792 startItem) {
        shootStartItem = startItem;
        shootingMarks = true;
        startLerpingTime = System.currentTimeMillis();
        lerpWait = System.currentTimeMillis() + 250L;
        shootingPhase = PlayerServerData.ShootingPhase.SHOOTING;
        class_2540 packet = PacketByteBufs.create();
        packet.writeInt(PlayerServerData.ShootingPhase.SHOOTING.ordinal());
        ClientPlayNetworking.send((class_2960)DeadeyeNetworking.DEADEYE_PHASE, (class_2540)packet);
    }

    public static void mark(class_310 client) {
        if (isEnabled && !shootingMarks) {
            int waitAmount;
            int n = waitAmount = DeadeyeClient.playerData.deadeyeSkill == 1 ? 250 : 100;
            if (System.currentTimeMillis() - markWait < (long)waitAmount) {
                return;
            }
            markWait = System.currentTimeMillis();
            assert (client.field_1724 != null);
            class_1799 item = client.field_1724.method_6047();
            if (item == null) {
                return;
            }
            DeadeyeMod.TargetingInteractionType interactionType = Utils.getTargetingInteractionType(item);
            if (!Utils.isInteractionGun(interactionType) && marks.size() >= DeadeyeMod.CONFIG.server.maxMarks()) {
                return;
            }
            if (!deadeyeMarkingItems.contains(item.method_7909()) && !Utils.isInteractionGun(interactionType)) {
                return;
            }
            if (interactionType == DeadeyeMod.TargetingInteractionType.BOW && !client.field_1724.method_7337() && client.field_1724.method_18808(item).method_7947() <= marks.size()) {
                return;
            }
            if (interactionType == DeadeyeMod.TargetingInteractionType.POINT_BLANK_GUN && !PointBlankIntegration.canMarkTargets(item, marks.size()) && marks.isEmpty()) {
                return;
            }
            if (interactionType == DeadeyeMod.TargetingInteractionType.TACZ_GUN && !TACZIntegration.canMarkTargets(item, marks.size()) && marks.isEmpty()) {
                return;
            }
            if (interactionType == DeadeyeMod.TargetingInteractionType.SAG_GUN && !SAGIntegration.canMarkTargets(item, marks.size()) && marks.isEmpty()) {
                return;
            }
            double maxDistance = DeadeyeMod.CONFIG.server.maxTargetDistance();
            class_239 hit = Utils.raycastEntity((class_1657)client.field_1724, maxDistance);
            if (hit == null) {
                return;
            }
            class_3966 eHit = (class_3966)hit;
            if (Objects.requireNonNull(hit.method_17783()) == class_239.class_240.field_1331) {
                class_1297 ent = null;
                if (eHit.method_17782() instanceof class_1309) {
                    ent = eHit.method_17782();
                }
                if (deadeyeMarkableEntities.contains(eHit.method_17782().method_5864())) {
                    ent = eHit.method_17782();
                }
                if (ent == null) {
                    return;
                }
                class_2540 packet = PacketByteBufs.create();
                packet.method_49068(hit.method_17784().method_46409());
                packet.writeInt(ent.method_5628());
                ClientPlayNetworking.send((class_2960)DeadeyeNetworking.DEADEYE_MARK, (class_2540)packet);
            }
        }
    }

    public static void requestDeadeye() {
        class_2540 packet = PacketByteBufs.create();
        packet.writeBoolean(!isEnabled);
        ClientPlayNetworking.send((class_2960)DeadeyeNetworking.DEADEYE_REQUEST, (class_2540)packet);
    }

    public static void receiveDeadeyeUpdate(int status) {
        if (status == DeadeyeMod.DeadeyeStatus.EMPTY.ordinal()) {
            return;
        }
        DeadeyeClient.setDeadeye(DeadeyeMod.DeadeyeStatus.values()[status]);
    }

    public static void receiveDeadeyeMark(Vector3f pos, int entityId) {
        if (!isEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        DeadeyeMod.TargetingInteractionType interactionType = Utils.getTargetingInteractionType(client.field_1724.method_6047());
        class_1297 ent = client.field_1687.method_8469(entityId);
        if (ent == null) {
            return;
        }
        marks.add(new DeadeyeTarget(ent, new class_243(pos)));
        client.field_1724.method_5783(DeadeyeProfiles.getSelectedSoundProfile().paintTargetSound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f, 1.0f);
        class_1799 mainStack = client.field_1724.method_6047();
        if (interactionType == DeadeyeMod.TargetingInteractionType.POINT_BLANK_GUN && marks.size() >= PointBlankIntegration.getGunAmmo(mainStack)) {
            DeadeyeClient.startShootingTargets(mainStack.method_7909());
        }
        if (interactionType == DeadeyeMod.TargetingInteractionType.TACZ_GUN && marks.size() >= TACZIntegration.getGunAmmo(mainStack)) {
            DeadeyeClient.startShootingTargets(mainStack.method_7909());
        }
        if (interactionType == DeadeyeMod.TargetingInteractionType.SAG_GUN && marks.size() >= SAGIntegration.getGunAmmo(mainStack)) {
            DeadeyeClient.startShootingTargets(mainStack.method_7909());
        }
        if (!Utils.isInteractionGun(interactionType) && marks.size() >= DeadeyeMod.CONFIG.server.maxMarks()) {
            DeadeyeClient.startShootingTargets(client.field_1724.method_6047().method_7909());
        }
    }

    public static void receivePhaseUpdate(int phase) {
        class_310 client = class_310.method_1551();
        shootingPhase = PlayerServerData.ShootingPhase.values()[phase];
        if (phase == PlayerServerData.ShootingPhase.SHOOTING.ordinal()) {
            DeadeyeClient.startShootingTargets(client.field_1724.method_31548().method_7391().method_7909());
        }
    }

    public static void setDeadeye(DeadeyeMod.DeadeyeStatus status) {
        class_310 client = class_310.method_1551();
        GSTpsModule tps = GSClientController.getInstance().getTpsModule();
        assert (client.field_1724 != null);
        if (status == DeadeyeMod.DeadeyeStatus.ENABLED) {
            isEnabled = true;
        } else if (status == DeadeyeMod.DeadeyeStatus.DISABLED || status == DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY) {
            isEnabled = false;
        }
        if (isEnabled) {
            DeadeyeClient.calculateDeadeyeEnding();
            tps.cShiftPitch.set(false);
            tps.cNormalMovement.set(false);
            DeadeyeEffects.updateEffects(status);
        } else {
            DeadeyeEffects.updateEffects(status);
            tps.cShiftPitch.set(true);
            tps.cNormalMovement.set(true);
            shootingPhase = PlayerServerData.ShootingPhase.NONE;
            marks.clear();
            shootingMarks = false;
            startLerpingTime = 0L;
            if (status == DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY) {
                DeadeyeClient.playerData.deadeyeMeter = 0.0f;
                DeadeyeClient.playerData.deadeyeCore = 0.0f;
            }
            deadeyeEnding = 0.0f;
        }
    }

    public static void tick(class_310 client) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        assert (client.field_1724 != null);
        if (isEnabled && !shootingMarks) {
            GSClientController gs = GSClientController.getInstance();
            float slowdownMultiplier = 20.0f / gs.getTpsModule().getTps();
            float decreaseAmount = DeadeyeMod.CONFIG.server.deadeyeIdleConsumeAmount() * slowdownMultiplier;
            if (DeadeyeClient.playerData.deadeyeMeter > 0.0f) {
                DeadeyeClient.playerData.deadeyeMeter = class_3532.method_15363((float)(DeadeyeClient.playerData.deadeyeMeter - decreaseAmount), (float)0.0f, (float)DeadeyeClient.getMaxMeter(3));
            } else {
                DeadeyeClient.playerData.deadeyeCore = class_3532.method_15363((float)(DeadeyeClient.playerData.deadeyeCore - decreaseAmount), (float)0.0f, (float)80.0f);
            }
            DeadeyeClient.calculateDeadeyeEnding();
        }
    }

    public static void calculateDeadeyeEnding() {
        deadeyeEnding = class_3532.method_15363((float)(1.0f - (DeadeyeClient.playerData.deadeyeCore / 20.0f + DeadeyeClient.playerData.deadeyeMeter / 20.0f)), (float)0.0f, (float)1.0f);
    }

    public static float getMaxMeter(int tonicLevel) {
        return DeadeyeClient.playerData.deadeyeLevel * 10 + tonicLevel * 20;
    }

    public static void deadeyeMeterUpdate(float amount) {
        DeadeyeClient.playerData.deadeyeMeter = class_3532.method_15363((float)amount, (float)0.0f, (float)DeadeyeClient.getMaxMeter(3));
    }

    public static void deadeyeCoreUpdate(float amount) {
        DeadeyeClient.playerData.deadeyeCore = class_3532.method_15363((float)amount, (float)0.0f, (float)80.0f);
    }

    public static void deadeyeLevelUpdate(int level) {
        DeadeyeClient.playerData.deadeyeLevel = class_3532.method_15340((int)level, (int)0, (int)10);
    }

    public static void receiveInitialSync(float meter, float core, int level) {
        DeadeyeClient.playerData.deadeyeMeter = meter;
        DeadeyeClient.playerData.deadeyeCore = core;
        DeadeyeClient.playerData.deadeyeLevel = level;
    }

    public static void deadeyeSkillUpdate(int skill) {
        DeadeyeClient.playerData.deadeyeSkill = class_3532.method_15340((int)skill, (int)0, (int)3);
    }

    public static void disconnect(class_634 clientPlayNetworkHandler, class_310 client) {
        if (isEnabled) {
            DeadeyeClient.setDeadeye(DeadeyeMod.DeadeyeStatus.DISABLED);
        }
    }
}

