/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.deadeye;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.namefix.DeadeyeMod;
import com.namefix.data.DeadeyeSoundProfile;
import com.namefix.deadeye.DeadeyeClient;
import com.namefix.deadeye.DeadeyeProfiles;
import com.namefix.deadeye.DeadeyeShader;
import com.namefix.sound.SoundBackgroundLoop;
import com.namefix.utils.Utils;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class DeadeyeEffects {
    private static final class_2960 DEADEYE_CORE_BG = class_2960.method_43902((String)"deadeye-mod", (String)"textures/deadeye-core/core-background.png");
    private static final List<class_2960> DEADEYE_CORE = IntStream.rangeClosed(1, 16).mapToObj(i -> class_2960.method_43902((String)"deadeye-mod", (String)String.format("textures/deadeye-core/core%02d.png", i))).toList();
    private static final List<class_2960> DEADEYE_METER_TRACK = IntStream.rangeClosed(1, 10).mapToObj(i -> class_2960.method_43902((String)"deadeye-mod", (String)String.format("textures/meter-track/track%02d.png", i))).toList();
    private static final List<class_2960> DEADEYE_METER = IntStream.rangeClosed(1, 100).mapToObj(i -> class_2960.method_43902((String)"deadeye-mod", (String)String.format("textures/meter/meter%02d.png", i))).toList();
    private static final List<class_2960> DEADEYE_LIGHTLEAK = IntStream.rangeClosed(1, 15).mapToObj(i -> class_2960.method_43902((String)"deadeye-mod", (String)String.format("textures/lightleak/lightleak%02d.png", i))).toList();
    private static final List<Vector3f> meterFortification = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(1.0f, 0.969f, 0.776f), new Vector3f(1.0f, 0.969f, 0.659f), new Vector3f(0.976f, 0.925f, 0.412f)});
    public static int meterX = 0;
    public static int meterY = 0;
    public static int meterSize = 16;
    private static int meterCoreLastIndex = 0;
    private static boolean meterCoreEffect = false;
    private static float meterCoreEffectTime = 0.0f;
    private static float meterCoreLastAmount = 0.0f;
    private static float meterCoreBlink = 0.0f;
    private static float meterLastAmount = 0.0f;
    private static float meterBlink = 0.0f;
    public static long lightleakTimer = 0L;
    public static int lightleakStatus = 0;
    public static boolean lightleakDirection = false;
    static SoundBackgroundLoop soundBackground;
    static SoundBackgroundLoop soundBackground2;
    static boolean heartbeat;
    static long lastHeartbeat;
    static int heartbeatInDuration;
    static int heartbeatOutDuration;
    private static final class_2960 DEADEYE_MARK;
    static int markSize;
    public static float deadeyeFade;
    public static float tonicDuration;

    DeadeyeEffects() {
    }

    public static void heartbeatTick() {
        if (!DeadeyeClient.isEnabled || class_310.method_1551().method_1493()) {
            return;
        }
        class_310 client = class_310.method_1551();
        DeadeyeSoundProfile profile = DeadeyeProfiles.getSelectedSoundProfile();
        assert (client.field_1724 != null);
        if (!heartbeat) {
            if ((double)(System.currentTimeMillis() - lastHeartbeat) > (double)heartbeatInDuration - (double)heartbeatInDuration * ((double)DeadeyeClient.deadeyeEnding / 1.5)) {
                client.field_1724.method_5783(profile.heartbeatInSound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f, 1.0f);
                lastHeartbeat = System.currentTimeMillis();
                heartbeat = true;
            }
        } else if ((double)(System.currentTimeMillis() - lastHeartbeat) > (double)heartbeatOutDuration - (double)heartbeatOutDuration * ((double)DeadeyeClient.deadeyeEnding / 1.5)) {
            client.field_1724.method_5783(profile.heartbeatOutSound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f, 1.0f);
            lastHeartbeat = System.currentTimeMillis();
            heartbeat = false;
        }
    }

    public static void updateVariables(WorldRenderContext context) {
        int increment;
        class_310 client = class_310.method_1551();
        DeadeyeShader.DeadeyeShaderType shaderType = DeadeyeMod.CONFIG.client.deadeyeStyle();
        int n = increment = shaderType.equals((Object)DeadeyeShader.DeadeyeShaderType.RDR2) ? 16 : 8;
        deadeyeFade = DeadeyeClient.isEnabled ? class_3532.method_15363((float)(deadeyeFade + client.method_1534() / 20.0f * (float)increment), (float)0.0f, (float)1.0f) : (!shaderType.equals((Object)DeadeyeShader.DeadeyeShaderType.RDR1) ? class_3532.method_15363((float)(deadeyeFade - client.method_1534() / 20.0f * (float)increment), (float)0.0f, (float)1.0f) : 0.0f);
        tonicDuration = class_3532.method_15363((float)(tonicDuration - client.method_1534() / 20.0f), (float)0.0f, (float)1.0f);
    }

    public static void updateEffects(DeadeyeMod.DeadeyeStatus status) {
        class_310 client = class_310.method_1551();
        DeadeyeSoundProfile profile = DeadeyeProfiles.getSelectedSoundProfile();
        DeadeyeShader.DeadeyeShaderType shaderType = DeadeyeMod.CONFIG.client.deadeyeStyle();
        if (status == DeadeyeMod.DeadeyeStatus.ENABLED) {
            client.field_1724.method_5783(profile.enterSound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f, 1.0f);
            lightleakDirection = client.field_1724.method_6051().method_43056();
            lightleakTimer = System.currentTimeMillis();
            lightleakStatus = 0;
            soundBackground = new SoundBackgroundLoop(profile.backgroundSound, class_3419.field_15256, (class_1657)client.field_1724, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f / 2.0f, true);
            client.method_1483().method_4873((class_1113)soundBackground);
            soundBackground2 = new SoundBackgroundLoop(profile.background2Sound, class_3419.field_15256, (class_1657)client.field_1724, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f / 20.0f, false);
            client.method_1483().method_4873((class_1113)soundBackground2);
            DeadeyeShader.loadDeadeyeProcessor(DeadeyeShader.ShaderType.DEADEYE);
        } else if (status == DeadeyeMod.DeadeyeStatus.DISABLED || status == DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY) {
            client.field_1724.method_5783(profile.exitSound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f, 1.0f);
            if (status == DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY && shaderType.equals((Object)DeadeyeShader.DeadeyeShaderType.RDR2)) {
                client.field_1724.method_5783(profile.exitEmptySound, DeadeyeMod.CONFIG.client.deadeyeVolume() / 100.0f / 20.0f, 1.0f);
            }
            soundBackground.setDone();
            soundBackground2.setDone();
        }
    }

    public static void startTonicEffect() {
        tonicDuration = 1.0f;
        DeadeyeShader.loadDeadeyeProcessor(DeadeyeShader.ShaderType.TONIC);
    }

    public static void renderGraphics(class_332 drawContext, float v) {
        if (DeadeyeMod.CONFIG.client.deadeyeStyle().equals((Object)DeadeyeShader.DeadeyeShaderType.RDR2) && !DeadeyeMod.CONFIG.client.disableDeadeyeEffects() && !DeadeyeMod.CONFIG.client.disableLightleakEffect()) {
            DeadeyeEffects.renderLightleak(drawContext);
        }
        if (DeadeyeClient.isEnabled) {
            DeadeyeEffects.renderMarks(drawContext);
        }
        if (!class_310.method_1551().field_1690.field_1842 && DeadeyeMod.CONFIG.client.meterPosition() != MeterPosition.NONE && DeadeyeClient.playerData.deadeyeSkill > 0) {
            Vector2i meterCoords = DeadeyeEffects.getMeterCoordinates(drawContext, DeadeyeMod.CONFIG.client.meterPosition());
            meterX = meterCoords.x;
            meterY = meterCoords.y;
            DeadeyeEffects.renderCore(drawContext);
            DeadeyeEffects.renderMeter(drawContext);
            drawContext.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static void renderMarks(class_332 drawContext) {
        DeadeyeClient.marks.forEach(mark -> {
            ++mark.renderTick;
            markSize = DeadeyeMod.CONFIG.client.deadeyeMarkSize();
            class_243 markPos = Utils.worldSpaceToScreenSpace(mark.getCurrentOffset());
            if (!Utils.screenSpaceCoordinateIsVisible(markPos)) {
                return;
            }
            if (mark.renderTick < 10) {
                drawContext.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                drawContext.method_51422(0.78f, 0.09f, 0.09f, 1.0f);
            }
            int sizeModifier = 0;
            if (mark.renderTick < 5) {
                sizeModifier = markSize;
            } else if (mark.renderTick < 10) {
                sizeModifier = markSize / 2;
            }
            int posX = (int)Math.round(markPos.field_1352) - markSize / 2 - sizeModifier / 2;
            int posY = (int)Math.round(markPos.field_1351) - markSize / 2 - sizeModifier / 2;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            drawContext.method_25293(DEADEYE_MARK, posX, posY, markSize + sizeModifier, markSize + sizeModifier, 0.0f, 0.0f, 64, 64, 64, 64);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        });
        drawContext.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void renderLightleak(class_332 drawContext) {
        if (DeadeyeClient.isEnabled) {
            if (lightleakStatus == 15) {
                return;
            }
            int width = drawContext.method_51421();
            int height = drawContext.method_51443();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            drawContext.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            drawContext.method_51448().method_46416((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
            drawContext.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            drawContext.method_25291(DEADEYE_LIGHTLEAK.get(lightleakStatus), 0, 0, -90, 0.0f, 0.0f, width, height, lightleakDirection ? -width : width, height);
            drawContext.method_51448().method_22909();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            if (System.currentTimeMillis() - lightleakTimer > 40L) {
                lightleakStatus = class_3532.method_15340((int)(lightleakStatus + 1), (int)0, (int)15);
                lightleakTimer = System.currentTimeMillis();
            }
        }
    }

    private static void renderCore(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        drawContext.method_25293(DEADEYE_CORE_BG, meterX, meterY, meterSize, meterSize, 0.0f, 0.0f, meterSize, meterSize, meterSize, meterSize);
        if (meterCoreLastAmount > 20.0f) {
            float currentCore = DeadeyeClient.playerData.deadeyeCore;
            if (meterCoreLastAmount >= 60.0f && currentCore < 60.0f || meterCoreLastAmount >= 40.0f && currentCore < 40.0f || currentCore < 20.0f) {
                meterCoreBlink = 1.0f;
            }
        }
        meterCoreLastAmount = DeadeyeClient.playerData.deadeyeCore;
        if (meterCoreBlink > 0.0f) {
            meterCoreBlink -= client.method_1534() / 20.0f * 4.0f;
        }
        if (meterCoreBlink > 0.75f || meterCoreBlink < 0.5f && meterCoreBlink > 0.25f) {
            return;
        }
        int coreIndex = class_3532.method_15340((int)Math.round(DeadeyeClient.playerData.deadeyeCore), (int)0, (int)15);
        if (coreIndex < 4) {
            drawContext.method_51422(0.8f, 0.075f, 0.024f, 1.0f);
        } else {
            Vector3f color = DeadeyeEffects.getCoreColor();
            drawContext.method_51422(color.x, color.y, color.z, 1.0f);
        }
        if (meterCoreEffect || meterCoreEffectTime < 0.0f) {
            meterCoreEffectTime += client.method_1534() / 20.0f;
        }
        if (meterCoreEffectTime > 1.0f) {
            meterCoreEffect = false;
            meterCoreEffectTime = -1.0f;
        }
        if (meterCoreLastIndex != coreIndex && !meterCoreEffect && meterCoreLastIndex > coreIndex && meterCoreEffectTime >= 0.0f) {
            meterCoreEffect = true;
            meterCoreEffectTime = 0.0f;
        }
        meterCoreLastIndex = coreIndex;
        float progress = meterCoreEffectTime * 16.0f;
        if (progress > 1.0f) {
            meterCoreEffect = false;
        }
        float scale = 1.0f + (meterCoreEffect ? (progress < 0.5f ? -0.1f * (progress / 0.5f) : -0.1f * (1.0f - (progress - 0.5f) / 0.5f)) : 0.0f);
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)meterX + (float)meterSize / 2.0f, (float)meterY + (float)meterSize / 2.0f, 0.0f);
        drawContext.method_51448().method_22905(scale, scale, 1.0f);
        drawContext.method_51448().method_46416((float)(-meterSize) / 2.0f, (float)(-meterSize) / 2.0f, 0.0f);
        drawContext.method_25291(DEADEYE_CORE.get(coreIndex), 0, 0, -90, 0.0f, 0.0f, meterSize, meterSize, meterSize, meterSize);
        drawContext.method_51448().method_22909();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static void renderMeter(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        float deadeyeMeter = DeadeyeClient.playerData.deadeyeMeter;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        if (DeadeyeClient.playerData.deadeyeLevel > 0) {
            drawContext.method_51422(0.33f, 0.31f, 0.31f, 1.0f);
            drawContext.method_25293(DEADEYE_METER_TRACK.get(class_3532.method_15340((int)(DeadeyeClient.playerData.deadeyeLevel - 1), (int)0, (int)9)), meterX, meterY, meterSize, meterSize, 0.0f, 0.0f, meterSize, meterSize, meterSize, meterSize);
        }
        boolean tonic = false;
        if (meterLastAmount > DeadeyeClient.getMaxMeter(0)) {
            tonic = true;
            if (meterLastAmount >= DeadeyeClient.getMaxMeter(2) && deadeyeMeter < DeadeyeClient.getMaxMeter(2) || meterLastAmount >= DeadeyeClient.getMaxMeter(1) && deadeyeMeter < DeadeyeClient.getMaxMeter(1) || deadeyeMeter < DeadeyeClient.getMaxMeter(0)) {
                meterBlink = 1.0f;
            }
        }
        if (deadeyeMeter > DeadeyeClient.getMaxMeter(0) && deadeyeMeter > meterLastAmount) {
            meterBlink = 1.0f;
        }
        meterLastAmount = deadeyeMeter;
        if (meterBlink > 0.0f) {
            meterBlink -= client.method_1534() / 20.0f * 4.0f;
        }
        if (meterBlink > 0.75f || meterBlink < 0.5f && meterBlink > 0.25f) {
            return;
        }
        Vector3f color = DeadeyeEffects.getMeterColor();
        drawContext.method_51422(color.x, color.y, color.z, 1.0f);
        if (Math.round(deadeyeMeter) > 0) {
            int meterIndex = tonic ? 99 : class_3532.method_15340((int)Math.round(deadeyeMeter), (int)0, (int)99);
            drawContext.method_25293(DEADEYE_METER.get(meterIndex), meterX, meterY, meterSize, meterSize, 0.0f, 0.0f, meterSize, meterSize, meterSize, meterSize);
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static Vector3f getMeterColor() {
        if (DeadeyeClient.playerData.deadeyeMeter > DeadeyeClient.getMaxMeter(2)) {
            return meterFortification.get(meterFortification.size() - 1);
        }
        if (DeadeyeClient.playerData.deadeyeMeter > DeadeyeClient.getMaxMeter(1)) {
            return meterFortification.get(1);
        }
        if (DeadeyeClient.playerData.deadeyeMeter > DeadeyeClient.getMaxMeter(0)) {
            return meterFortification.get(0);
        }
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    private static Vector3f getCoreColor() {
        if (DeadeyeClient.playerData.deadeyeCore > 60.0f) {
            return meterFortification.get(meterFortification.size() - 1);
        }
        if (DeadeyeClient.playerData.deadeyeCore > 40.0f) {
            return meterFortification.get(1);
        }
        if (DeadeyeClient.playerData.deadeyeCore > 20.0f) {
            return meterFortification.get(0);
        }
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    private static Vector2i getMeterCoordinates(class_332 ctx, MeterPosition pos) {
        switch (pos.ordinal()) {
            case 1: {
                return new Vector2i(4, 4);
            }
            case 2: {
                return new Vector2i(ctx.method_51421() - 20, 4);
            }
            case 3: {
                return new Vector2i(4, ctx.method_51443() - 20);
            }
            case 4: {
                return new Vector2i(ctx.method_51421() - 20, ctx.method_51443() - 20);
            }
            case 0: {
                return new Vector2i(ctx.method_51421() / 4 - 20, ctx.method_51443() - 20);
            }
        }
        return new Vector2i(0, 0);
    }

    static {
        heartbeat = false;
        lastHeartbeat = System.currentTimeMillis();
        heartbeatInDuration = 1150;
        heartbeatOutDuration = 350;
        DEADEYE_MARK = class_2960.method_43902((String)"deadeye-mod", (String)"textures/cross.png");
        markSize = DeadeyeMod.CONFIG.client.deadeyeMarkSize();
        deadeyeFade = 0.0f;
        tonicDuration = 0.0f;
    }

    public static enum MeterPosition {
        NEAR_HOTBAR,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        NONE;

    }
}

