/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.deadeye;

import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.module.tps.GSTpsModule;
import com.namefix.DeadeyeMod;
import com.namefix.data.DeadeyeTarget;
import com.namefix.data.PlayerSaveData;
import com.namefix.data.PlayerServerData;
import com.namefix.data.StateSaverAndLoader;
import com.namefix.handlers.ConfigHandler;
import com.namefix.handlers.GameruleHandler;
import com.namefix.integrations.PointBlankIntegration;
import com.namefix.integrations.SAGIntegration;
import com.namefix.integrations.TACZIntegration;
import com.namefix.network.DeadeyeNetworking;
import com.namefix.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.elidhan.anim_guns.item.GunItem;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DeadeyeServer {
    public static Map<UUID, PlayerServerData> deadeyeUsers = new HashMap<UUID, PlayerServerData>();
    public static List<class_1299<?>> deadeyeMarkableEntities = ConfigHandler.LoadDeadeyeMarkableEntities();
    public static List<class_1792> deadeyeItems = ConfigHandler.LoadDeadeyeMarkingItems();

    public static void receiveDeadeyeRequest(class_3222 player, MinecraftServer server, boolean status) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        if (status) {
            if (player.method_37908().method_8450().method_8355(GameruleHandler.DISABLE_DEADEYE) || playerState.deadeyeSkill <= 0) {
                return;
            }
            if (playerState.deadeyeMeter <= 0.0f && playerState.deadeyeCore <= 0.0f) {
                class_2540 packet = PacketByteBufs.create();
                packet.writeInt(DeadeyeMod.DeadeyeStatus.EMPTY.ordinal());
                ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet);
                return;
            }
            DeadeyeServer.updateDeadeyeStatus(server, player, DeadeyeMod.DeadeyeStatus.ENABLED);
        } else {
            DeadeyeServer.updateDeadeyeStatus(server, player, DeadeyeMod.DeadeyeStatus.DISABLED);
        }
    }

    public static void updateDeadeyeStatus(MinecraftServer server, class_3222 player, DeadeyeMod.DeadeyeStatus status) {
        GSServerController gs = GSServerController.getInstance();
        GSTpsModule tps = gs.getTpsModule();
        if (status == DeadeyeMod.DeadeyeStatus.ENABLED) {
            deadeyeUsers.put(player.method_5667(), new PlayerServerData());
            if (DeadeyeMod.CONFIG.server.deadeyeSlowdown()) {
                tps.setTps(5.0f);
            }
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(DeadeyeMod.DeadeyeStatus.ENABLED.ordinal());
            ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet);
        } else {
            deadeyeUsers.remove(player.method_5667());
            if (DeadeyeMod.CONFIG.server.deadeyeSlowdown() && deadeyeUsers.isEmpty()) {
                tps.setTps(20.0f);
            }
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(status.ordinal());
            ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet);
        }
    }

    public static void receiveMarkRequest(MinecraftServer server, class_3222 player, Vector3f pos, int entityId) {
        if (!deadeyeUsers.containsKey(player.method_5667())) {
            return;
        }
        PlayerServerData data = deadeyeUsers.get(player.method_5667());
        class_1799 heldItem = player.method_6047();
        if (heldItem == null) {
            return;
        }
        DeadeyeMod.TargetingInteractionType interactionType = Utils.getTargetingInteractionType(heldItem);
        if (interactionType == DeadeyeMod.TargetingInteractionType.POINT_BLANK_GUN && !PointBlankIntegration.canMarkTargets(heldItem, data.markList.size())) {
            return;
        }
        if (interactionType == DeadeyeMod.TargetingInteractionType.TACZ_GUN && !TACZIntegration.canMarkTargets(heldItem, data.markList.size())) {
            return;
        }
        if (interactionType == DeadeyeMod.TargetingInteractionType.SAG_GUN && !SAGIntegration.canMarkTargets(heldItem, data.markList.size())) {
            return;
        }
        if (!Utils.isInteractionGun(interactionType) && data.markList.size() >= DeadeyeMod.CONFIG.server.maxMarks()) {
            return;
        }
        if (interactionType == DeadeyeMod.TargetingInteractionType.BOW && !player.method_7337() && !player.method_31548().method_7382(class_3489.field_18317)) {
            DeadeyeServer.updateDeadeyeStatus(server, player, DeadeyeMod.DeadeyeStatus.DISABLED);
            return;
        }
        if (!deadeyeItems.contains(heldItem.method_7909()) && !Utils.isInteractionGun(interactionType)) {
            return;
        }
        class_1297 ent = player.method_37908().method_8469(entityId);
        if (ent == null) {
            return;
        }
        if (!(ent instanceof class_1309) && !deadeyeMarkableEntities.contains(ent.method_5864())) {
            return;
        }
        DeadeyeServer.updatePhase(player, PlayerServerData.ShootingPhase.MARKED);
        class_243 v3pos = new class_243(pos);
        DeadeyeTarget target = new DeadeyeTarget(ent, v3pos);
        data.markList.add(target);
        class_2540 packet = PacketByteBufs.create();
        packet.method_49068(pos);
        packet.writeInt(entityId);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_MARK, (class_2540)packet);
        if (!player.method_7337() && interactionType == DeadeyeMod.TargetingInteractionType.BOW && player.method_18808(heldItem).method_7947() <= data.markList.size()) {
            DeadeyeServer.updatePhase(player, PlayerServerData.ShootingPhase.SHOOTING);
        }
        if (!Utils.isInteractionGun(interactionType) && data.markList.size() >= DeadeyeMod.CONFIG.server.maxMarks()) {
            DeadeyeServer.updatePhase(player, PlayerServerData.ShootingPhase.SHOOTING);
        }
    }

    public static void receivePhaseUpdate(class_3222 player, int phase) {
        if (!deadeyeUsers.containsKey(player.method_5667())) {
            return;
        }
        PlayerServerData data = deadeyeUsers.get(player.method_5667());
        if (data.shootingPhase.ordinal() < phase) {
            data.shootingPhase = PlayerServerData.ShootingPhase.values()[phase];
        }
    }

    public static void receiveShot(MinecraftServer server, class_3222 player, int interactionType, Vector3f shootPos) {
        class_3218 world = (class_3218)player.method_37908();
        if (!deadeyeUsers.containsKey(player.method_5667())) {
            return;
        }
        PlayerServerData data = deadeyeUsers.get(player.method_5667());
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        DeadeyeMod.TargetingInteractionType interactionTypes = DeadeyeMod.TargetingInteractionType.values()[interactionType];
        class_243 pos = player.method_33571();
        class_1799 item = player.method_6047();
        if (data.shootingItem != null && !data.shootingItem.method_7909().equals(item.method_7909())) {
            DeadeyeServer.updateDeadeyeStatus(server, player, DeadeyeMod.DeadeyeStatus.DISABLED);
            return;
        }
        if (!player.method_7337() && interactionTypes == DeadeyeMod.TargetingInteractionType.BOW && !player.method_31548().method_7382(class_3489.field_18317)) {
            return;
        }
        data.shootingPhase = PlayerServerData.ShootingPhase.SHOOTING;
        switch (interactionTypes) {
            case BOW: {
                class_1811 ranged = (class_1811)item.method_7909();
                class_1799 projectileItem = player.method_18808(item).method_46651(1);
                class_1667 arrow = new class_1667((class_1937)world, pos.field_1352, pos.field_1351, pos.field_1350);
                arrow.method_7432((class_1297)player);
                Vector3f motion = shootPos.sub((Vector3fc)player.method_33571().method_46409());
                arrow.method_45319(new class_243(motion.mul(DeadeyeMod.CONFIG.server.markProjectileSpeedMultiplier())));
                world.method_8649((class_1297)arrow);
                class_3414 shootSound = item.method_7909() instanceof class_1753 ? class_3417.field_14600 : class_3417.field_15187;
                int i = ranged.method_7881(item);
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), shootSound, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + class_1753.method_7722((int)i) * 0.5f);
                player.method_7259(class_3468.field_15372.method_14956((Object)item.method_7909()));
                if (player.method_7337()) break;
                player.method_18808(item).method_7934(1);
                break;
            }
            case SAG_GUN: {
                GunItem gun = (GunItem)item.method_7909();
                gun.shoot(player.method_37908(), (class_1657)player, item);
            }
        }
        if (!data.markList.isEmpty()) {
            data.markList.remove(0);
        }
        if (data.markList.isEmpty()) {
            DeadeyeServer.updateDeadeyeStatus(server, player, playerState.deadeyeMeter <= 0.0f && playerState.deadeyeCore <= 0.0f ? DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY : DeadeyeMod.DeadeyeStatus.DISABLED);
        }
    }

    public static void updatePhase(class_3222 player, PlayerServerData.ShootingPhase phase) {
        if (!deadeyeUsers.containsKey(player.method_5667())) {
            return;
        }
        DeadeyeServer.deadeyeUsers.get((Object)player.method_5667()).shootingPhase = phase;
        class_2540 packet = PacketByteBufs.create();
        packet.writeInt(phase.ordinal());
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_PHASE, (class_2540)packet);
    }

    public static void onPlayerConnect(class_3244 serverPlayNetworkHandler, PacketSender packetSender, MinecraftServer minecraftServer) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)serverPlayNetworkHandler.field_14140);
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(playerState.deadeyeMeter);
        packet.writeFloat(playerState.deadeyeCore);
        packet.writeInt(playerState.deadeyeLevel);
        ServerPlayNetworking.send((class_3222)serverPlayNetworkHandler.field_14140, (class_2960)DeadeyeNetworking.INITIAL_SYNC, (class_2540)packet);
    }

    public static void onPlayerDisconnect(class_3244 serverPlayNetworkHandler, MinecraftServer minecraftServer) {
        DeadeyeServer.updateDeadeyeStatus(minecraftServer, serverPlayNetworkHandler.field_14140, DeadeyeMod.DeadeyeStatus.DISABLED);
    }

    public static void setDeadeyeMeter(class_3222 player, float amount) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        if (amount < 0.0f) {
            amount = DeadeyeServer.getMaxDeadeye(playerState);
        }
        playerState.deadeyeMeter = amount;
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(amount);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_METER, (class_2540)packet);
    }

    public static void setMeterTonicLevel(class_3222 player, int level) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        playerState.deadeyeMeter = playerState.deadeyeLevel * 10 + level * 20;
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(playerState.deadeyeMeter);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_METER, (class_2540)packet);
    }

    public static void setDeadeyeCore(class_3222 player, float amount) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        playerState.deadeyeCore = amount;
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(amount);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_CORE, (class_2540)packet);
    }

    public static void addDeadeyeCore(class_3222 player, float amount, boolean meterCap) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        playerState.deadeyeCore = meterCap && playerState.deadeyeCore + amount > 20.0f ? 20.0f : class_3532.method_15363((float)(playerState.deadeyeCore + amount), (float)0.0f, (float)80.0f);
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(playerState.deadeyeCore);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_CORE, (class_2540)packet);
    }

    public static void setDeadeyeLevel(class_3222 player, int level) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        playerState.deadeyeLevel = level;
        playerState.deadeyeXp = 0.0f;
        class_2540 packet = PacketByteBufs.create();
        packet.writeInt(level);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_LEVEL, (class_2540)packet);
    }

    public static void setDeadeyeSkill(class_3222 player, int skill) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        playerState.deadeyeSkill = skill;
        class_2540 packet = PacketByteBufs.create();
        packet.writeInt(skill);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_SKILL, (class_2540)packet);
    }

    public static void addDeadeyeXP(class_3222 player, float xp) {
        PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
        if (playerState.deadeyeLevel >= 10) {
            return;
        }
        playerState.deadeyeXp += xp;
        if (player.method_37908().method_8450().method_8355(GameruleHandler.DISABLE_DEADEYE_LEVELING)) {
            return;
        }
        boolean leveledUp = false;
        while (playerState.deadeyeXp >= DeadeyeServer.calculateNeededXP(playerState.deadeyeLevel)) {
            playerState.deadeyeXp -= DeadeyeServer.calculateNeededXP(playerState.deadeyeLevel);
            ++playerState.deadeyeLevel;
            leveledUp = true;
        }
        if (leveledUp) {
            player.method_43496((class_2561)class_2561.method_43469((String)"text.deadeye-mod.levelup", (Object[])new Object[]{playerState.deadeyeLevel}));
            class_2540 packet = PacketByteBufs.create();
            packet.writeInt(playerState.deadeyeLevel);
            ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_LEVEL, (class_2540)packet);
        }
    }

    public static float calculateNeededXP(int level) {
        return (float)level * 10.0f;
    }

    public static void deadeyeMeterKillReward(class_1309 livingEntity, class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        if (deadeyeUsers.get(player.method_5667()) != null) {
            DeadeyeServer.addDeadeyeXP(player, 0.5f);
            return;
        }
        PlayerSaveData playerData = StateSaverAndLoader.getPlayerState((class_1309)player);
        if (playerData.deadeyeMeter > (float)(playerData.deadeyeLevel * 10)) {
            return;
        }
        playerData.deadeyeMeter = class_3532.method_15363((float)(playerData.deadeyeMeter + DeadeyeMod.CONFIG.server.deadeyeKillRefillAmount()), (float)0.0f, (float)(playerData.deadeyeLevel * 10));
        class_2540 packet = PacketByteBufs.create();
        packet.writeFloat(playerData.deadeyeMeter);
        ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_METER, (class_2540)packet);
    }

    public static float getMaxDeadeye(PlayerSaveData playerData) {
        return (float)(playerData.deadeyeLevel * 10) + 60.0f;
    }

    public static void onTick(MinecraftServer minecraftServer) {
        GSServerController gs = GSServerController.getInstance();
        GSTpsModule tps = gs.getTpsModule();
        Iterator<Map.Entry<UUID, PlayerServerData>> iterator = deadeyeUsers.entrySet().iterator();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        while (iterator.hasNext()) {
            class_2540 packet;
            Map.Entry<UUID, PlayerServerData> entry = iterator.next();
            UUID user = entry.getKey();
            PlayerServerData data = entry.getValue();
            class_3222 player = minecraftServer.method_3760().method_14602(user);
            assert (player != null);
            PlayerSaveData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
            if (player.method_29504()) {
                packet = PacketByteBufs.create();
                packet.writeInt(DeadeyeMod.DeadeyeStatus.DISABLED.ordinal());
                ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet);
                toRemove.add(user);
                continue;
            }
            if (data.shootingPhase != PlayerServerData.ShootingPhase.SHOOTING) {
                if (TACZIntegration.isLoaded) {
                    TACZIntegration.setDrawCooldown(player);
                }
                float slowdownMultiplier = 20.0f / tps.getTps();
                float decreaseAmount = DeadeyeMod.CONFIG.server.deadeyeIdleConsumeAmount() * slowdownMultiplier;
                DeadeyeServer.addDeadeyeXP(player, 0.001f * slowdownMultiplier);
                if (playerState.deadeyeMeter > 0.0f) {
                    playerState.deadeyeMeter = class_3532.method_15363((float)(playerState.deadeyeMeter - decreaseAmount), (float)0.0f, (float)DeadeyeServer.getMaxDeadeye(playerState));
                } else {
                    playerState.deadeyeCore = class_3532.method_15363((float)(playerState.deadeyeCore - decreaseAmount), (float)0.0f, (float)80.0f);
                }
                if (playerState.deadeyeMeter != 0.0f || playerState.deadeyeCore != 0.0f) continue;
                if (data.shootingPhase != PlayerServerData.ShootingPhase.MARKED) {
                    class_2540 packet2 = PacketByteBufs.create();
                    packet2.writeInt(DeadeyeMod.DeadeyeStatus.DISABLED_EMPTY.ordinal());
                    ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet2);
                    toRemove.add(user);
                    continue;
                }
                DeadeyeServer.setDeadeyeMeter(player, 0.0f);
                DeadeyeServer.setDeadeyeCore(player, 0.0f);
                DeadeyeServer.updatePhase(player, PlayerServerData.ShootingPhase.SHOOTING);
                continue;
            }
            if (data.shootingItem == null || data.shootingItem.method_7909().equals(player.method_6047().method_7909())) continue;
            packet = PacketByteBufs.create();
            packet.writeInt(DeadeyeMod.DeadeyeStatus.DISABLED.ordinal());
            ServerPlayNetworking.send((class_3222)player, (class_2960)DeadeyeNetworking.DEADEYE_UPDATE, (class_2540)packet);
            toRemove.add(user);
        }
        for (UUID user : toRemove) {
            deadeyeUsers.remove(user);
            if (!deadeyeUsers.isEmpty() || !DeadeyeMod.CONFIG.server.deadeyeSlowdown()) continue;
            tps.setTps(20.0f);
        }
    }
}

