/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.integrations;

import com.namefix.DeadeyeMod;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.item.FireMode;
import com.vicmatskiv.pointblank.item.FireModeInstance;
import com.vicmatskiv.pointblank.item.GunItem;
import java.lang.reflect.Method;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class PointBlankIntegration {
    public static boolean isLoaded = false;
    private static Method tryFireMethod = null;
    private static boolean reflectionInitialized = false;

    public static void initialize() {
        isLoaded = true;
        PointBlankIntegration.initializeReflection();
    }

    private static void initializeReflection() {
        if (reflectionInitialized) {
            return;
        }
        reflectionInitialized = true;
        try {
            for (Method method : GunItem.class.getMethods()) {
                if (!method.getName().equals("tryFire") || method.getParameterCount() != 3) continue;
                tryFireMethod = method;
                tryFireMethod.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            DeadeyeMod.LOGGER.error("Failed to initialize reflection for Point Blank: {}", (Object)e.getMessage());
        }
    }

    public static boolean isItemGun(class_1799 stack) {
        if (!isLoaded) {
            return false;
        }
        return stack.method_7909() instanceof GunItem;
    }

    public static void shootGun(GunItem gun, class_1657 player, class_1297 target) {
        if (tryFireMethod == null) {
            return;
        }
        try {
            tryFireMethod.invoke((Object)gun, player, player.method_6047(), target);
        }
        catch (Exception e) {
            DeadeyeMod.LOGGER.error("Failed tryFire reflection for Point Blank: {}", (Object)e.getMessage());
        }
    }

    public static boolean canMarkTargets(class_1799 item, int markCount) {
        return markCount < PointBlankIntegration.getGunAmmo(item);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canGunShoot(class_1799 item) {
        if (!(item.method_7909() instanceof GunItem)) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        GunClientState state = GunClientState.getState((class_1657)player, (class_1799)item, (int)player.method_31548().field_7545, (boolean)false);
        FireMode fireMode = PointBlankIntegration.getGunFiremode(item);
        if (fireMode == FireMode.AUTOMATIC && state.isIdle()) {
            return true;
        }
        if (fireMode == FireMode.AUTOMATIC) {
            return state.isFiring();
        }
        return state.isIdle();
    }

    public static int getGunAmmo(class_1799 item) {
        if (!(item.method_7909() instanceof GunItem)) {
            return 0;
        }
        return GunItem.getAmmo((class_1799)item, (FireModeInstance)GunItem.getFireModeInstance((class_1799)item));
    }

    public static FireMode getGunFiremode(class_1799 item) {
        if (!(item.method_7909() instanceof GunItem)) {
            return null;
        }
        return GunItem.getFireModeInstance((class_1799)item).getType();
    }

    public static int getMaxAmmo(class_1799 item) {
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return 0;
        }
        GunItem gun = (GunItem)class_17922;
        return gun.getMaxAmmoCapacity(item, GunItem.getFireModeInstance((class_1799)item));
    }
}

