/*
 * Decompiled with CFR 0.152.
 */
package com.meekdev.openheads.client;

import com.meekdev.openheads.VoiceChatIntegration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;

public class OpenheadsClient
implements ClientModInitializer {
    public static final Map<Integer, Float> HEAD_ROTATIONS = new HashMap<Integer, Float>();
    private static final Map<Integer, Float> CURRENT_SCALES = new HashMap<Integer, Float>();

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void onClientTick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        client.field_1687.method_18456().forEach(player -> {
            float lerpSpeed;
            float currentSquish;
            float newSquish;
            int id = player.method_5628();
            VoiceChatIntegration.AudioData audioData = VoiceChatIntegration.getAudioData(player.method_5667());
            float targetSquish = 0.0f;
            if (audioData != null) {
                targetSquish = this.normalizeVolume(audioData.volume) * 35.0f;
            }
            if (Math.abs(newSquish = this.lerp(currentSquish, targetSquish, lerpSpeed = targetSquish > (currentSquish = CURRENT_SCALES.getOrDefault(id, Float.valueOf(0.0f)).floatValue()) ? 0.5f : 0.35f)) > 0.5f) {
                CURRENT_SCALES.put(id, Float.valueOf(newSquish));
                HEAD_ROTATIONS.put(id, Float.valueOf(newSquish));
            } else {
                CURRENT_SCALES.remove(id);
                HEAD_ROTATIONS.remove(id);
            }
        });
        Iterator<Map.Entry<Integer, Float>> iterator = CURRENT_SCALES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Float> entry = iterator.next();
            if (this.isPlayerInWorld(client, entry.getKey())) continue;
            iterator.remove();
            HEAD_ROTATIONS.remove(entry.getKey());
        }
    }

    private boolean isPlayerInWorld(class_310 client, int playerId) {
        if (client.field_1687 == null) {
            return false;
        }
        return client.field_1687.method_18456().stream().anyMatch(p -> p.method_5628() == playerId);
    }

    private float normalizeVolume(double volumeDb) {
        double minDb = -50.0;
        double maxDb = -5.0;
        double clamped = Math.max(minDb, Math.min(maxDb, volumeDb));
        return (float)((clamped - minDb) / (maxDb - minDb));
    }

    private float lerp(float start, float end, float alpha) {
        return start + (end - start) * alpha;
    }
}

