/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mod.maxbogomol.fluffy_fur.FluffyFur;
import mod.maxbogomol.fluffy_fur.FluffyFurClient;
import mod.maxbogomol.fluffy_fur.client.gui.components.FluffyFurLogoRenderer;
import mod.maxbogomol.fluffy_fur.client.gui.screen.FluffyFurMod;
import mod.maxbogomol.fluffy_fur.client.gui.screen.FluffyFurModsHandler;
import mod.maxbogomol.fluffy_fur.client.gui.screen.FluffyFurPanorama;
import mod.maxbogomol.fluffy_fur.config.FluffyFurClientConfig;
import mod.maxbogomol.fluffy_fur.util.ColorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class FluffyFurMenuScreen
extends Screen {
    public Screen lastScreen;
    public CubeMap CUBE_MAP = new CubeMap(new ResourceLocation("fluffy_fur", "textures/gui/title/background/panorama"));
    public PanoramaRenderer panorama = new PanoramaRenderer(this.CUBE_MAP);
    public FluffyFurLogoRenderer logoRenderer;
    public long fadeInStart;
    private static final ResourceLocation LOGO = new ResourceLocation("fluffy_fur", "textures/gui/menu/title/fluffy_fur.png");
    public static ResourceLocation BACKGROUND = new ResourceLocation("fluffy_fur", "textures/gui/menu_background.png");
    public static int ticks = 0;
    public static List<FluffyFurMod> mods = new ArrayList<FluffyFurMod>();
    public static List<FluffyFurPanorama> panoramas = new ArrayList<FluffyFurPanorama>();
    public static int descriptionScroll = 0;
    public static int panoramasScroll = 0;
    public static int modsScroll = 0;
    public static int selectedPanorama = 0;
    public static int selectedMod = 0;

    public FluffyFurMenuScreen(Screen lastScreen) {
        super((Component)Component.m_237119_());
        this.lastScreen = lastScreen;
        this.logoRenderer = new FluffyFurLogoRenderer(LOGO, false);
        if (lastScreen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)lastScreen;
            this.copyPanorama(titleScreen);
        }
        this.fadeInStart = Util.m_137550_();
        mods = FluffyFurModsHandler.getSortedMods();
        panoramas = FluffyFurModsHandler.getSortedPanoramas();
        FluffyFurPanorama panorama = FluffyFurModsHandler.getPanorama((String)FluffyFurClientConfig.PANORAMA.get());
        if (panorama != null && panoramas.contains(panorama)) {
            selectedPanorama = panoramas.indexOf(panorama);
        }
        descriptionScroll = 0;
    }

    public void copyPanorama(TitleScreen titleScreen) {
        this.CUBE_MAP = TitleScreen.f_96716_;
        this.panorama = new PanoramaRenderer(this.CUBE_MAP);
        this.panorama.f_244569_ = titleScreen.f_96729_.f_244569_;
        this.panorama.f_244463_ = titleScreen.f_96729_.f_244463_;
    }

    public void setLocalPanorama(FluffyFurPanorama panorama) {
        float spin = this.panorama.f_244569_;
        float bob = this.panorama.f_244463_;
        ResourceLocation base = new ResourceLocation("textures/gui/title/background/panorama");
        if (panorama.getTexture() != null) {
            base = panorama.getTexture();
        }
        this.CUBE_MAP = new CubeMap(base);
        this.panorama = new PanoramaRenderer(this.CUBE_MAP);
        this.panorama.f_244569_ = spin;
        this.panorama.f_244463_ = bob;
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> {
            this.f_96541_.m_91152_(this.lastScreen);
            Screen patt4149$temp = this.lastScreen;
            if (patt4149$temp instanceof TitleScreen) {
                TitleScreen titleScreen = (TitleScreen)patt4149$temp;
                titleScreen.f_96729_.f_244569_ = this.panorama.f_244569_;
                titleScreen.f_96729_.f_244463_ = this.panorama.f_244463_;
            }
        }).m_252987_(this.f_96543_ / 2 - 80, this.f_96544_ / 4 + 152, 160, 20).m_253136_());
    }

    public void m_86600_() {
        ++ticks;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        float f = (float)(Util.m_137550_() - this.fadeInStart) / 250.0f;
        this.panorama.m_110003_(partialTicks, 1.0f);
        Screen screen = this.lastScreen;
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            titleScreen.f_263781_.m_280037_(gui, this.f_96543_, 1.0f - f);
        }
        this.logoRenderer.m_280037_(gui, this.f_96543_, f);
        FluffyFurMenuScreen.drawDescription(gui, this.f_96543_ / 2 - 80, this.f_96544_ / 4 + 48, mouseX, mouseY, partialTicks);
        FluffyFurMenuScreen.drawPanoramaList(gui, this.f_96543_ / 2 - 204, this.f_96544_ / 4 + 48, mouseX, mouseY, partialTicks);
        FluffyFurMenuScreen.drawModList(gui, this.f_96543_ / 2 + 84, this.f_96544_ / 4 + 48, mouseX, mouseY, partialTicks);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    public static void drawDescription(GuiGraphics gui, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int index;
        gui.m_280163_(BACKGROUND, x, y, 0.0f, 0.0f, 160, 100, 256, 256);
        FluffyFurMod mod = mods.get(selectedMod);
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent component = Component.m_237113_((String)mod.getName()).m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(mod.getNameColor()))).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)("v" + mod.getVersion())).m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(mod.getVersionColor()))));
        FluffyFurMenuScreen.drawBlackBackground(gui, x + 80, y - 12, font.m_92852_((FormattedText)component) + 8, mouseX, mouseY, partialTicks);
        gui.m_280653_(font, (Component)component, x + 80, y - 11, 0xFFFFFF);
        List<Component> lines = FluffyFurMenuScreen.getDescription(mod);
        int links = mod.getLinks().size();
        int l = lines.size() - links;
        for (int i = 0; i < 9 && (index = descriptionScroll + i) >= 0 && index <= lines.size() - 1; ++i) {
            MutableComponent line = Component.m_237119_().m_7220_(lines.get(index));
            if (index >= l && mouseX >= x + 5) {
                Objects.requireNonNull(font);
                if (mouseY >= y + 5 + i * (9 + 1) && mouseX <= x + 5 + font.m_92852_((FormattedText)line)) {
                    Objects.requireNonNull(font);
                    Objects.requireNonNull(font);
                    if (mouseY < y + 5 + (i * (9 + 1) + 9)) {
                        line.m_130940_(ChatFormatting.UNDERLINE);
                    }
                }
            }
            Objects.requireNonNull(font);
            gui.m_280430_(font, (Component)line, x + 5, y + 5 + i * (9 + 1), 0xFFFFFF);
        }
        int s = lines.size() - 9;
        if (s > 0) {
            float slider = (float)descriptionScroll / (float)s;
            FluffyFurMenuScreen.drawSlider(gui, x + 147, y + 4, slider, mouseX, mouseY, partialTicks);
        }
    }

    public static void drawPanoramaList(GuiGraphics gui, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int index;
        gui.m_280163_(BACKGROUND, x, y, 0.0f, 100.0f, 120, 100, 256, 256);
        int s = panoramas.size() - 5;
        if (s > 0) {
            float slider = (float)panoramasScroll / (float)s;
            FluffyFurMenuScreen.drawSlider(gui, x + 107, y + 4, slider, mouseX, mouseY, partialTicks);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent component = Component.m_237115_((String)"gui.fluffy_fur.menu.panoramas");
        FluffyFurMenuScreen.drawBlackBackground(gui, x + 60, y - 12, font.m_92852_((FormattedText)component) + 8, mouseX, mouseY, partialTicks);
        gui.m_280653_(font, (Component)component, x + 60, y - 11, 0xFFFFFF);
        for (int i = 0; i < 5 && (index = panoramasScroll + i) >= 0 && index <= panoramas.size() - 1; ++i) {
            FluffyFurPanorama panorama = panoramas.get(index);
            MutableComponent name = Component.m_237119_().m_7220_(panorama.getName());
            if (selectedPanorama == index) {
                name.m_130940_(ChatFormatting.UNDERLINE);
            }
            gui.m_280480_(panorama.getItem(), x + 2, y + 2 + i * 20);
            gui.m_280430_(font, (Component)name, x + 20, y + 6 + i * 20, 0xFFFFFF);
            if (mouseX < x || mouseY < y || mouseX > x + 120 || mouseY >= y + 100 || mouseX < x + 2 || mouseY < y + 2 + i * 20 || mouseX > x + 102 || mouseY >= y + 22 + i * 20) continue;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(panorama.getName());
            if (panorama.getMod() != null) {
                list.add(Component.m_237119_());
                list.add(Component.m_237115_((String)"gui.fluffy_fur.menu.mod").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)panorama.getMod().getName()).m_130940_(ChatFormatting.GRAY)));
            }
            if (panorama == FluffyFurClient.VANILLA_PANORAMA) {
                list.add(Component.m_237119_());
                list.add(Component.m_237113_((String)"Minecraft").m_130940_(ChatFormatting.GRAY));
            }
            gui.m_280677_(Minecraft.m_91087_().f_91062_, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void drawModList(GuiGraphics gui, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int index;
        gui.m_280163_(BACKGROUND, x, y, 0.0f, 100.0f, 120, 100, 256, 256);
        int s = mods.size() - 5;
        if (s > 0) {
            float slider = (float)modsScroll / (float)s;
            FluffyFurMenuScreen.drawSlider(gui, x + 107, y + 4, slider, mouseX, mouseY, partialTicks);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent component = Component.m_237115_((String)"gui.fluffy_fur.menu.mods");
        FluffyFurMenuScreen.drawBlackBackground(gui, x + 60, y - 12, font.m_92852_((FormattedText)component) + 8, mouseX, mouseY, partialTicks);
        gui.m_280653_(font, (Component)component, x + 60, y - 11, 0xFFFFFF);
        if (FluffyFur.mcreatorModsCount > 0) {
            component = Component.m_237115_((String)"gui.fluffy_fur.menu.mcreator_mods").m_130946_(" " + FluffyFur.mcreatorModsCount);
            FluffyFurMenuScreen.drawBlackBackground(gui, x + 60, y - 24, font.m_92852_((FormattedText)component) + 8, mouseX, mouseY, partialTicks);
            gui.m_280653_(font, (Component)component, x + 60, y - 23, 0xFFFFFF);
            if ((float)mouseX >= (float)(x + 60) - (float)font.m_92852_((FormattedText)component) / 2.0f - 4.0f && mouseY >= y - 24 && (float)mouseX <= (float)(x + 60) + (float)font.m_92852_((FormattedText)component) / 2.0f + 4.0f && mouseY < y - 14) {
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                for (String string : FluffyFur.mcreatorModsList) {
                    list.add(Component.m_237113_((String)string));
                }
                gui.m_280677_(Minecraft.m_91087_().f_91062_, list, Optional.empty(), mouseX, mouseY);
            }
        }
        for (int i = 0; i < 5 && (index = modsScroll + i) >= 0 && index <= mods.size() - 1; ++i) {
            FluffyFurMod mod = mods.get(index);
            gui.m_280480_(mod.getItem(), x + 2, y + 2 + i * 20);
            MutableComponent name = Component.m_237119_().m_130946_(mod.getName());
            if (mod.getDev().equals("MaxBogomol")) {
                name = name.m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(ColorUtil.rainbowColor(((float)ticks + partialTicks) * 0.005f))));
            }
            if (mod.getId().equals("implosion")) {
                name = name.m_130948_(Style.f_131099_.m_178520_(ColorUtil.packColor(255, 132, 190, 224)));
            }
            if (selectedMod == index) {
                name.m_130940_(ChatFormatting.UNDERLINE);
            }
            gui.m_280430_(font, (Component)name, x + 20, y + 6 + i * 20, 0xFFFFFF);
            if (mouseX < x || mouseY < y || mouseX > x + 120 || mouseY >= y + 100 || mouseX < x + 2 || mouseY < y + 2 + i * 20 || mouseX > x + 102 || mouseY >= y + 22 + i * 20) continue;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237113_((String)mod.getName()));
            list.add(Component.m_237119_());
            list.add(Component.m_237115_((String)"gui.fluffy_fur.menu.id").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)mod.getId()).m_130940_(ChatFormatting.GRAY)));
            list.add(Component.m_237115_((String)"gui.fluffy_fur.menu.version").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)mod.getVersion()).m_130940_(ChatFormatting.GRAY)));
            if (mod.getEdition() > 0) {
                list.add(Component.m_237115_((String)"gui.fluffy_fur.menu.edition").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(mod.getEdition())).m_130940_(ChatFormatting.GRAY)));
            }
            list.add(Component.m_237115_((String)"gui.fluffy_fur.menu.autor").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)mod.getDev()).m_130940_(ChatFormatting.GRAY)));
            gui.m_280677_(Minecraft.m_91087_().f_91062_, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void drawSlider(GuiGraphics gui, int x, int y, float progress, int mouseX, int mouseY, float partialTicks) {
        int i = (int)(progress * 80.0f);
        gui.m_280163_(BACKGROUND, x, y, 160.0f, 0.0f, 10, 92, 256, 256);
        gui.m_280163_(BACKGROUND, x + 1, y + 1 + i, 170.0f, 0.0f, 8, 10, 256, 256);
    }

    public static void drawBlackBackground(GuiGraphics gui, int x, int y, int size, float alpha, int mouseX, int mouseY, float partialTicks) {
        if (size < 4) {
            size = 4;
        }
        if (size % 2 != 0) {
            ++size;
        }
        RenderSystem.enableBlend();
        gui.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        gui.m_280163_(BACKGROUND, x - size / 2, y, 178.0f, 0.0f, 1, 10, 256, 256);
        gui.m_280411_(BACKGROUND, x - size / 2 + 1, y, size - 2, 10, 179.0f, 0.0f, 1, 10, 256, 256);
        gui.m_280163_(BACKGROUND, x + size / 2 - 1, y, 178.0f, 0.0f, 1, 10, 256, 256);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawBlackBackground(GuiGraphics gui, int x, int y, int size, int mouseX, int mouseY, float partialTicks) {
        FluffyFurMenuScreen.drawBlackBackground(gui, x, y, size, 0.5f, mouseX, mouseY, partialTicks);
    }

    public static List<Component> getDescription(FluffyFurMod mod) {
        String text = mod.getDescription().getString();
        int w = 145;
        Font font = Minecraft.m_91087_().f_91062_;
        ArrayList<Component> lines = new ArrayList<Component>();
        String[] words = text.split(" ");
        Object line = "";
        for (String s : words) {
            if (s.equals("\n")) {
                lines.add((Component)Component.m_237113_((String)line));
                line = "";
                continue;
            }
            if (font.m_92895_((String)line) + font.m_92895_(s) > w) {
                lines.add((Component)Component.m_237113_((String)line));
                line = s + " ";
                continue;
            }
            line = (String)line + s + " ";
        }
        if (!((String)line).isEmpty()) {
            lines.add((Component)Component.m_237113_((String)line));
        }
        if (mod.getLinks().size() > 0) {
            lines.add((Component)Component.m_237119_());
            lines.add((Component)Component.m_237115_((String)"gui.fluffy_fur.menu.links").m_130940_(ChatFormatting.GRAY));
            for (FluffyFurMod.Link link : mod.getLinks()) {
                lines.add(link.getComponent());
            }
        }
        return lines;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.descriptionMouseClicked(this.f_96543_ / 2 - 80, this.f_96544_ / 4 + 48, mouseX, mouseY, button)) {
            return true;
        }
        if (this.panoramaListMouseClicked(this.f_96543_ / 2 - 204, this.f_96544_ / 4 + 48, mouseX, mouseY, button)) {
            return true;
        }
        if (this.modListMouseClicked(this.f_96543_ / 2 + 84, this.f_96544_ / 4 + 48, mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean descriptionMouseClicked(int x, int y, double mouseX, double mouseY, int button) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 160) && mouseY < (double)(y + 100)) {
            int index;
            FluffyFurMod mod = mods.get(selectedMod);
            List<Component> lines = FluffyFurMenuScreen.getDescription(mod);
            int links = mod.getLinks().size();
            int l = lines.size() - links;
            for (int i = 0; i < 9 && (index = descriptionScroll + i) >= 0 && index <= lines.size() - 1; ++i) {
                MutableComponent line = Component.m_237119_().m_7220_(lines.get(index));
                if (index < l || !(mouseX >= (double)(x + 5))) continue;
                Objects.requireNonNull(this.f_96547_);
                if (!(mouseY >= (double)(y + 5 + i * (9 + 1))) || !(mouseX <= (double)(x + 5 + this.f_96547_.m_92852_((FormattedText)line)))) continue;
                Objects.requireNonNull(this.f_96547_);
                Objects.requireNonNull(this.f_96547_);
                if (!(mouseY < (double)(y + 5 + (i * (9 + 1) + 9)))) continue;
                this.linkTo(mod.getLinks().get(index - l).getLink());
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)1.0f, (float)0.25f));
                return true;
            }
        }
        return false;
    }

    public boolean panoramaListMouseClicked(int x, int y, double mouseX, double mouseY, int button) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 120) && mouseY < (double)(y + 100)) {
            int index;
            for (int i = 0; i < 5 && (index = panoramasScroll + i) >= 0 && index <= panoramas.size() - 1; ++i) {
                if (!(mouseX >= (double)(x + 2)) || !(mouseY >= (double)(y + 2 + i * 20)) || !(mouseX <= (double)(x + 102)) || !(mouseY < (double)(y + 22 + i * 20))) continue;
                selectedPanorama = index;
                FluffyFurModsHandler.setPanorama(panoramas.get(selectedPanorama));
                this.setLocalPanorama(panoramas.get(selectedPanorama));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)1.0f, (float)0.25f));
                return true;
            }
        }
        return false;
    }

    public boolean modListMouseClicked(int x, int y, double mouseX, double mouseY, int button) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 120) && mouseY < (double)(y + 100)) {
            int index;
            for (int i = 0; i < 5 && (index = modsScroll + i) >= 0 && index <= mods.size() - 1; ++i) {
                if (!(mouseX >= (double)(x + 2)) || !(mouseY >= (double)(y + 2 + i * 20)) || !(mouseX <= (double)(x + 102)) || !(mouseY < (double)(y + 22 + i * 20))) continue;
                selectedMod = index;
                descriptionScroll = 0;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)1.0f, (float)0.25f));
                return true;
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.descriptionMouseScrolled(this.f_96543_ / 2 - 80, this.f_96544_ / 4 + 48, mouseX, mouseY, delta)) {
            return true;
        }
        if (this.panoramaListMouseScrolled(this.f_96543_ / 2 - 204, this.f_96544_ / 4 + 48, mouseX, mouseY, delta)) {
            return true;
        }
        if (this.modListMouseScrolled(this.f_96543_ / 2 + 84, this.f_96544_ / 4 + 48, mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean descriptionMouseScrolled(int x, int y, double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 160) && mouseY < (double)(y + 100)) {
            List<Component> lines = FluffyFurMenuScreen.getDescription(mods.get(selectedMod));
            int add = (int)delta;
            if (descriptionScroll - add < 0) {
                return false;
            }
            if (descriptionScroll - add > lines.size() - 9) {
                return false;
            }
            descriptionScroll -= add;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)2.0f, (float)0.1f));
            return true;
        }
        return false;
    }

    public boolean panoramaListMouseScrolled(int x, int y, double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 120) && mouseY < (double)(y + 100)) {
            int add = (int)delta;
            if (panoramasScroll - add < 0) {
                return false;
            }
            if (panoramasScroll - add > panoramas.size() - 5) {
                return false;
            }
            panoramasScroll -= add;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)2.0f, (float)0.1f));
            return true;
        }
        return false;
    }

    public boolean modListMouseScrolled(int x, int y, double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 120) && mouseY < (double)(y + 100)) {
            int add = (int)delta;
            if (modsScroll - add < 0) {
                return false;
            }
            if (modsScroll - add > mods.size() - 5) {
                return false;
            }
            modsScroll -= add;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.get()), (float)2.0f, (float)0.1f));
            return true;
        }
        return false;
    }

    public void linkTo(String url) {
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(click -> {
            if (click) {
                Util.m_137581_().m_137646_(url);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, url, true));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }
}

