/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.gui.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mod.maxbogomol.fluffy_fur.FluffyFurClient;
import mod.maxbogomol.fluffy_fur.client.gui.components.FluffyFurLogoRenderer;
import mod.maxbogomol.fluffy_fur.client.gui.screen.FluffyFurMod;
import mod.maxbogomol.fluffy_fur.client.gui.screen.FluffyFurPanorama;
import mod.maxbogomol.fluffy_fur.config.FluffyFurClientConfig;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;

public class FluffyFurModsHandler {
    public static Map<String, FluffyFurMod> mods = new HashMap<String, FluffyFurMod>();
    public static Map<String, FluffyFurPanorama> panoramas = new HashMap<String, FluffyFurPanorama>();

    public static void registerMod(FluffyFurMod mod) {
        mods.put(mod.getId(), mod);
    }

    public static FluffyFurMod getMod(String id) {
        return mods.get(id);
    }

    public static List<FluffyFurMod> getMods() {
        return mods.values().stream().toList();
    }

    public static void registerPanorama(FluffyFurPanorama panorama) {
        panoramas.put(panorama.getId(), panorama);
    }

    public static FluffyFurPanorama getPanorama(String id) {
        return panoramas.get(id);
    }

    public static List<FluffyFurPanorama> getPanoramas() {
        return new ArrayList<FluffyFurPanorama>(panoramas.values());
    }

    public static List<FluffyFurMod> getSortedMods() {
        ArrayList<FluffyFurMod> sorted = new ArrayList<FluffyFurMod>();
        ArrayList<String> main = new ArrayList<String>();
        ArrayList<String> sort = new ArrayList<String>();
        for (String id : mods.keySet()) {
            if (id.equals(FluffyFurClient.MOD_INSTANCE.getId())) continue;
            if (FluffyFurModsHandler.getMod(id).getDev().equals("MaxBogomol")) {
                main.add(id);
                continue;
            }
            sort.add(id);
        }
        Collections.sort(main);
        Collections.sort(sort);
        sorted.add(FluffyFurClient.MOD_INSTANCE);
        for (String id : main) {
            sorted.add(FluffyFurModsHandler.getMod(id));
        }
        for (String id : sort) {
            sorted.add(FluffyFurModsHandler.getMod(id));
        }
        return sorted;
    }

    public static List<FluffyFurPanorama> getSortedPanoramas() {
        ArrayList<FluffyFurPanorama> sorted = new ArrayList<FluffyFurPanorama>();
        List<FluffyFurPanorama> panoramas = FluffyFurModsHandler.getPanoramas();
        List<FluffyFurMod> sortedMods = FluffyFurModsHandler.getSortedMods();
        ArrayList<FluffyFurPanorama> added = new ArrayList<FluffyFurPanorama>();
        for (FluffyFurMod mod : sortedMods) {
            ArrayList<FluffyFurPanorama> modPanoramas = new ArrayList<FluffyFurPanorama>();
            ArrayList<Integer> sorts = new ArrayList<Integer>();
            for (FluffyFurPanorama panorama : panoramas) {
                if (panorama.getMod() != mod) continue;
                sorts.add(panorama.getSort());
                modPanoramas.add(panorama);
                added.add(panorama);
            }
            Collections.sort(sorts);
            Iterator<FluffyFurPanorama> iterator = sorts.iterator();
            while (iterator.hasNext()) {
                int sort = (Integer)((Object)iterator.next());
                for (FluffyFurPanorama panorama : modPanoramas) {
                    if (panorama.getSort() != sort) continue;
                    sorted.add(panorama);
                }
            }
        }
        sorted.add(0, FluffyFurClient.VANILLA_PANORAMA);
        for (FluffyFurPanorama panorama : panoramas) {
            if (added.contains(panorama) || panorama == FluffyFurClient.VANILLA_PANORAMA) continue;
            sorted.add(panorama);
        }
        return sorted;
    }

    public static FluffyFurPanorama getPanorama() {
        return FluffyFurModsHandler.getPanorama((String)FluffyFurClientConfig.PANORAMA.get());
    }

    public static void setPanorama(FluffyFurPanorama panorama) {
        FluffyFurClientConfig.PANORAMA.set((Object)panorama.getId());
    }

    public static void setOpenPanorama(TitleScreen titleScreen, FluffyFurPanorama panorama) {
        float spin = titleScreen.f_96729_.f_244569_;
        float bob = titleScreen.f_96729_.f_244463_;
        ResourceLocation base = new ResourceLocation("textures/gui/title/background/panorama");
        ResourceLocation overlay = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
        if (panorama.getTexture() != null) {
            base = panorama.getTexture();
        }
        TitleScreen.f_96716_ = new CubeMap(base);
        titleScreen.f_96729_ = new PanoramaRenderer(TitleScreen.f_96716_);
        TitleScreen.f_96718_ = overlay;
        if (panorama.getLogo() != null && ((Boolean)FluffyFurClientConfig.PANORAMA_LOGO.get()).booleanValue()) {
            titleScreen.f_263781_ = new FluffyFurLogoRenderer(panorama.getLogo(), titleScreen.f_263781_.f_263708_);
        } else if (titleScreen.f_263781_ instanceof FluffyFurLogoRenderer) {
            titleScreen.f_263781_ = new LogoRenderer(titleScreen.f_263781_.f_263708_);
        }
        titleScreen.f_96729_.f_244569_ = spin;
        titleScreen.f_96729_.f_244463_ = bob;
    }
}

