/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.component.ParticleBehaviorComponent;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.LightParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpriteParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.options.GenericParticleOptions;
import mod.maxbogomol.fluffy_fur.registry.client.FluffyFurRenderTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GenericParticle
extends TextureSheetParticle {
    public static final Random random = new Random();
    public RenderType renderType;
    public ParticleRenderType particleRenderType;
    public MultiBufferSource bufferSource;
    public VertexFormat format;
    public ParticleBehavior behavior;
    public ParticleBehaviorComponent behaviorComponent;
    public ColorParticleData colorData;
    public GenericParticleData transparencyData;
    public GenericParticleData scaleData;
    public SpinParticleData spinData;
    public LightParticleData lightData;
    public SpriteParticleData spriteData;
    public Collection<Consumer<GenericParticle>> tickActors;
    public Collection<Consumer<GenericParticle>> renderActors;
    public GenericParticleOptions.DiscardFunctionType discardFunctionType;
    public boolean reachedPositiveAlpha;
    public boolean reachedPositiveScale;
    public boolean shouldCull;
    public boolean shouldRenderTraits;
    public ParticleEngine.MutableSpriteSet spriteSet;
    public float st;
    public float mt;
    public float et;
    public float ss;
    public float ms;
    public float es;
    public float sr;
    public float mr;
    public float er;
    public float randomSpin;
    public float uo;
    public float vo;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericParticle(ClientLevel level, GenericParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double z, double vx, double vy, double vz) {
        super(level, x, y, z, vx, vy, vz);
        this.m_107264_(x, y, z);
        this.renderType = options.renderType;
        this.particleRenderType = options.particleRenderType;
        this.bufferSource = options.bufferSource;
        this.format = options.format;
        this.colorData = options.colorData;
        this.transparencyData = GenericParticleData.constrictTransparency(options.transparencyData);
        this.scaleData = options.scaleData;
        this.spinData = options.spinData;
        this.lightData = options.lightData;
        this.spriteData = options.spriteData;
        this.tickActors = options.tickActors;
        this.renderActors = options.renderActors;
        this.discardFunctionType = options.discardFunctionType;
        this.f_107215_ = vx;
        this.f_107216_ = vy;
        this.f_107217_ = vz;
        this.m_107257_(options.lifetime + random.nextInt(options.additionalLifetime + 1));
        this.f_107226_ = options.gravity;
        if (options.additionalGravity > 0.0f) {
            this.f_107226_ += random.nextFloat(options.additionalGravity);
        }
        this.f_172258_ = options.friction;
        if (options.additionalFriction > 0.0f) {
            this.f_172258_ += random.nextFloat(options.additionalFriction);
        }
        this.shouldCull = options.shouldCull;
        this.shouldRenderTraits = options.shouldRenderTraits;
        this.f_107219_ = options.hasPhysics;
        this.spriteSet = spriteSet;
        this.f_107231_ = this.spinData.spinOffset + this.spinData.startingValue;
        this.randomSpin = GenericParticle.pickRandomValue(0.0f, this.spinData.rsp1, this.spinData.rsp2);
        if (random.nextBoolean()) {
            this.randomSpin = -this.randomSpin;
        }
        this.f_107231_ += GenericParticle.pickRandomRollValue(0.0f, this.spinData.rso1, this.spinData.rso2);
        float r1 = GenericParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        this.st = GenericParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        this.mt = GenericParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        this.et = GenericParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        this.ss = GenericParticle.pickRandomValue(this.scaleData.startingValue, this.scaleData.rs1, this.scaleData.rs2);
        this.ms = GenericParticle.pickRandomValue(this.scaleData.middleValue, this.scaleData.rm1, this.scaleData.rm2);
        this.es = GenericParticle.pickRandomValue(this.scaleData.endingValue, this.scaleData.re1, this.scaleData.re2);
        this.sr = GenericParticle.pickRandomValue(this.spinData.startingValue, this.spinData.rs1, this.spinData.rs2);
        this.mr = GenericParticle.pickRandomValue(this.spinData.middleValue, this.spinData.rm1, this.spinData.rm2);
        this.er = GenericParticle.pickRandomValue(this.spinData.endingValue, this.spinData.re1, this.spinData.re2);
        this.behavior = options.behavior;
        if (this.behavior != null) {
            this.behavior.init(this);
        }
        this.uo = random.nextFloat();
        this.vo = random.nextFloat();
        this.spriteData.init(this);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r1)), (int)(255.0f * Math.min(1.0f, g1)), (int)(255.0f * Math.min(1.0f, b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r2)), (int)(255.0f * Math.min(1.0f, g2)), (int)(255.0f * Math.min(1.0f, b2)), this.hsv2);
        options.spawnActors.forEach(actor -> actor.accept(this));
        this.updateTraits();
    }

    public static float pickRandomValue(float value, float value1, float value2) {
        if (value1 >= 0.0f && value2 >= 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public static float pickRandomRollValue(float value, float value1, float value2) {
        if (value1 != 0.0f || value2 != 0.0f) {
            return value1 != value2 ? random.nextFloat(Math.min(value1, value2), Math.max(value1, value2)) : value1;
        }
        return value;
    }

    public void pickColor(float coeff) {
        float h = Mth.m_14189_((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.m_107253_(r, g, b);
    }

    public void updateTraits() {
        boolean shouldAttemptRemoval;
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.f_107224_, this.f_107225_), 0.0f, 1.0f, 1.0f));
        this.f_107663_ = this.scaleData.getValue(this.f_107224_, this.f_107225_, this.ss, this.ms, this.es);
        this.f_107230_ = this.transparencyData.getValue(this.f_107224_, this.f_107225_, this.st, this.mt, this.et);
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = this.f_107231_ + this.spinData.getValue(this.f_107224_, this.f_107225_, this.sr, this.mr, this.er) + this.randomSpin;
        if (this.behavior != null) {
            this.behavior.updateTraits(this);
        }
        boolean bl = shouldAttemptRemoval = this.discardFunctionType == GenericParticleOptions.DiscardFunctionType.INVISIBLE;
        if (this.discardFunctionType == GenericParticleOptions.DiscardFunctionType.ENDING_CURVE_INVISIBLE && (this.scaleData.getProgress(this.f_107224_, this.f_107225_) > 0.5f || this.transparencyData.getProgress(this.f_107224_, this.f_107225_) > 0.5f)) {
            shouldAttemptRemoval = true;
        }
        if (shouldAttemptRemoval && (this.reachedPositiveAlpha && this.f_107230_ <= 0.0f || this.reachedPositiveScale && this.f_107663_ <= 0.0f)) {
            this.m_107274_();
            return;
        }
        if (!this.reachedPositiveAlpha && this.f_107230_ > 0.0f) {
            this.reachedPositiveAlpha = true;
        }
        if (!this.reachedPositiveScale && this.f_107663_ > 0.0f) {
            this.reachedPositiveScale = true;
        }
    }

    public void m_5989_() {
        this.updateTraits();
        this.spriteData.tick(this);
        super.m_5989_();
        this.tickActors.forEach(a -> a.accept(this));
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        if (this.shouldRenderTraits) {
            this.updateRenderTraits(partialTicks);
        }
        this.spriteData.renderTick(this, partialTicks);
        this.renderActors.forEach(actor -> actor.accept(this));
        if (this.behavior == null) {
            super.m_5744_(this.renderType != null ? FluffyFurRenderTypes.getDelayedRender().m_6299_(this.renderType) : vertexConsumer, camera, partialTicks);
        } else {
            this.behavior.render(this, this.renderType != null ? FluffyFurRenderTypes.getDelayedRender().m_6299_(this.renderType) : vertexConsumer, camera, partialTicks);
        }
    }

    public void updateRenderTraits(float partialTicks) {
        float time = (float)this.f_107224_ + partialTicks;
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(time, this.f_107225_), 0.0f, 1.0f, 1.0f));
        this.f_107663_ = this.scaleData.getValue(time, this.f_107225_, this.ss, this.ms, this.es);
        this.f_107230_ = this.transparencyData.getValue(time, this.f_107225_, this.st, this.mt, this.et);
    }

    public ParticleRenderType m_7556_() {
        return this.particleRenderType;
    }

    public boolean shouldCull() {
        return this.shouldCull;
    }

    public int m_6355_(float partialTicks) {
        return this.lightData.getLight(this, (Level)this.f_107208_, partialTicks);
    }

    public float m_5970_() {
        return this.spriteData.getU0(this);
    }

    public float m_5952_() {
        return this.spriteData.getU1(this);
    }

    public float m_5951_() {
        return this.spriteData.getV0(this);
    }

    public float m_5950_() {
        return this.spriteData.getV1(this);
    }

    public float getRoll() {
        return this.f_107231_;
    }

    public float getORoll() {
        return this.f_107204_;
    }

    public float getRed() {
        return this.f_107227_;
    }

    public float getGreen() {
        return this.f_107228_;
    }

    public float getBlue() {
        return this.f_107229_;
    }

    public float getAlpha() {
        return this.f_107230_;
    }

    public float getSize() {
        return this.f_107663_;
    }

    public double getX() {
        return this.f_107212_;
    }

    public double getY() {
        return this.f_107213_;
    }

    public double getZ() {
        return this.f_107214_;
    }

    public double getXOld() {
        return this.f_107209_;
    }

    public double getYOld() {
        return this.f_107210_;
    }

    public double getZOld() {
        return this.f_107211_;
    }

    public double getXMotion() {
        return this.f_107215_;
    }

    public double getYMotion() {
        return this.f_107216_;
    }

    public double getZMotion() {
        return this.f_107217_;
    }

    public Vec3 getPosition() {
        return new Vec3(this.getX(), this.getY(), this.getZ());
    }

    public void setPosition(Vec3 pos) {
        this.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public Vec3 getSpeed() {
        return new Vec3(this.getXMotion(), this.getYMotion(), this.getZMotion());
    }

    public void setSpeed(Vec3 speed) {
        this.m_172260_(speed.f_82479_, speed.f_82480_, speed.f_82481_);
    }

    public int m_107273_() {
        return this.f_107225_;
    }

    public int getAge() {
        return this.f_107224_;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.f_107406_.size() && spriteIndex >= 0) {
            this.m_108337_((TextureAtlasSprite)this.spriteSet.f_107406_.get(spriteIndex));
        }
    }
}

