/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import mod.maxbogomol.fluffy_fur.client.particle.GenericParticle;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.LightParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpriteParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.options.GenericParticleOptions;
import mod.maxbogomol.fluffy_fur.util.RenderUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Math;

public class ParticleBuilder {
    public static final Random random = new Random();
    public final GenericParticleOptions options;
    double vx = 0.0;
    double vy = 0.0;
    double vz = 0.0;
    double fvx = 0.0;
    double fvy = 0.0;
    double fvz = 0.0;
    double fdx = 0.0;
    double fdy = 0.0;
    double fdz = 0.0;
    double maxXSpeed = 0.0;
    double maxYSpeed = 0.0;
    double maxZSpeed = 0.0;
    double maxXDist = 0.0;
    double maxYDist = 0.0;
    double maxZDist = 0.0;
    boolean force = true;
    boolean distanceSpawn = true;
    double distance = 100.0;
    public Collection<ParticleBuilder> additionalBuilders = new ArrayList<ParticleBuilder>();

    protected ParticleBuilder(GenericParticleOptions options) {
        this.options = options;
    }

    public GenericParticleOptions getParticleOptions() {
        return this.options;
    }

    public ParticleBuilder setRenderType(RenderType renderType) {
        this.options.renderType = renderType;
        return this;
    }

    public ParticleBuilder setParticleRenderType(ParticleRenderType particleRenderType) {
        this.options.renderType = null;
        this.options.particleRenderType = particleRenderType;
        return this;
    }

    public ParticleBuilder setBufferSource(MultiBufferSource bufferSource) {
        this.options.bufferSource = bufferSource;
        return this;
    }

    public ParticleBuilder setFormat(VertexFormat format) {
        this.options.format = format;
        return this;
    }

    public ParticleBuilder setBehavior(ParticleBehavior behavior) {
        this.options.behavior = behavior;
        return this;
    }

    public ParticleBuilder setColorData(ColorParticleData colorData) {
        this.options.colorData = colorData;
        return this;
    }

    public ParticleBuilder setTransparencyData(GenericParticleData transparencyData) {
        this.options.transparencyData = transparencyData;
        return this;
    }

    public ParticleBuilder setScaleData(GenericParticleData scaleData) {
        this.options.scaleData = scaleData;
        return this;
    }

    public ParticleBuilder setSpinData(SpinParticleData spinData) {
        this.options.spinData = spinData;
        return this;
    }

    public ParticleBuilder setLightData(LightParticleData lightData) {
        this.options.lightData = lightData;
        return this;
    }

    public ParticleBuilder setSpriteData(SpriteParticleData spriteData) {
        this.options.spriteData = spriteData;
        return this;
    }

    public ParticleBuilder addTickActor(Consumer<GenericParticle> particleActor) {
        this.getParticleOptions().tickActors.add(particleActor);
        return this;
    }

    public ParticleBuilder addSpawnActor(Consumer<GenericParticle> particleActor) {
        this.getParticleOptions().spawnActors.add(particleActor);
        return this;
    }

    public ParticleBuilder addRenderActor(Consumer<GenericParticle> particleActor) {
        this.getParticleOptions().renderActors.add(particleActor);
        return this;
    }

    public ParticleBuilder clearActors() {
        return this.clearTickActor().clearSpawnActors().clearRenderActors();
    }

    public ParticleBuilder clearTickActor() {
        this.getParticleOptions().tickActors.clear();
        return this;
    }

    public ParticleBuilder clearSpawnActors() {
        this.getParticleOptions().spawnActors.clear();
        return this;
    }

    public ParticleBuilder clearRenderActors() {
        this.getParticleOptions().renderActors.clear();
        return this;
    }

    public ParticleBuilder setDiscardFunction(GenericParticleOptions.DiscardFunctionType discardFunctionType) {
        this.options.discardFunctionType = discardFunctionType;
        return this;
    }

    public ParticleBuilder setLifetime(int lifetime) {
        this.options.lifetime = lifetime;
        return this;
    }

    public ParticleBuilder setLifetime(int lifetime, int additionalLifetime) {
        this.options.lifetime = lifetime;
        this.options.additionalLifetime = additionalLifetime;
        return this;
    }

    public ParticleBuilder setGravity(float gravity) {
        this.options.gravity = gravity;
        return this;
    }

    public ParticleBuilder setGravity(float gravity, float additionalGravity) {
        this.options.gravity = gravity;
        this.options.additionalGravity = additionalGravity;
        return this;
    }

    public ParticleBuilder setFriction(float friction) {
        this.options.friction = friction;
        return this;
    }

    public ParticleBuilder setFriction(float friction, float additionalFriction) {
        this.options.friction = friction;
        this.options.additionalFriction = additionalFriction;
        return this;
    }

    public ParticleBuilder enableCull() {
        return this.setShouldCull(true);
    }

    public ParticleBuilder disableCull() {
        return this.setShouldCull(false);
    }

    public ParticleBuilder setShouldCull(boolean shouldCull) {
        this.options.shouldCull = shouldCull;
        return this;
    }

    public ParticleBuilder enableRenderTraits() {
        return this.setShouldRenderTraits(true);
    }

    public ParticleBuilder disableRenderTraits() {
        return this.setShouldRenderTraits(false);
    }

    public ParticleBuilder setShouldRenderTraits(boolean shouldRenderTraits) {
        this.options.shouldRenderTraits = shouldRenderTraits;
        return this;
    }

    public ParticleBuilder enablePhysics() {
        return this.setHasPhysics(true);
    }

    public ParticleBuilder disablePhysics() {
        return this.setHasPhysics(false);
    }

    public ParticleBuilder setHasPhysics(boolean hasPhysics) {
        this.options.hasPhysics = hasPhysics;
        return this;
    }

    public ParticleBuilder randomVelocity(double maxSpeed) {
        this.randomVelocity(maxSpeed, maxSpeed, maxSpeed);
        return this;
    }

    public ParticleBuilder randomVelocity(double maxHSpeed, double maxVSpeed) {
        this.randomVelocity(maxHSpeed, maxVSpeed, maxHSpeed);
        return this;
    }

    public ParticleBuilder randomVelocity(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
        this.maxXSpeed = maxXSpeed;
        this.maxYSpeed = maxYSpeed;
        this.maxZSpeed = maxZSpeed;
        return this;
    }

    public ParticleBuilder flatRandomVelocity(double fvx, double fvy, double fvz) {
        this.fvx = fvx;
        this.fvy = fvy;
        this.fvz = fvz;
        return this;
    }

    public ParticleBuilder addVelocity(double vx, double vy, double vz) {
        this.vx += vx;
        this.vy += vy;
        this.vz += vz;
        return this;
    }

    public ParticleBuilder setVelocity(double vx, double vy, double vz) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        return this;
    }

    public ParticleBuilder randomOffset(double maxDistance) {
        this.randomOffset(maxDistance, maxDistance, maxDistance);
        return this;
    }

    public ParticleBuilder randomOffset(double maxHDist, double maxVDist) {
        this.randomOffset(maxHDist, maxVDist, maxHDist);
        return this;
    }

    public ParticleBuilder randomOffset(double maxXDist, double maxYDist, double maxZDist) {
        this.maxXDist = maxXDist;
        this.maxYDist = maxYDist;
        this.maxZDist = maxZDist;
        return this;
    }

    public ParticleBuilder flatRandomOffset(double fdx, double fdy, double fdz) {
        this.fdx = fdx;
        this.fdy = fdy;
        this.fdz = fdz;
        return this;
    }

    public ParticleBuilder enableForce() {
        return this.setForce(true);
    }

    public ParticleBuilder disableForce() {
        return this.setForce(false);
    }

    public ParticleBuilder setForce(boolean force) {
        this.force = force;
        return this;
    }

    public ParticleBuilder setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    public ParticleBuilder enableDistanceSpawn() {
        return this.setDistanceSpawn(true);
    }

    public ParticleBuilder disableDistanceSpawn() {
        return this.setDistanceSpawn(false);
    }

    public ParticleBuilder setDistanceSpawn(boolean distanceSpawn) {
        this.distanceSpawn = distanceSpawn;
        return this;
    }

    public ParticleBuilder addAdditionalBuilder(ParticleBuilder builder) {
        this.additionalBuilders.add(builder);
        return this;
    }

    public ParticleBuilder clearAdditionalBuilders() {
        this.additionalBuilders.clear();
        return this;
    }

    public ParticleBuilder spawn(Level level, Vec3 pos) {
        double yaw = (double)random.nextFloat() * java.lang.Math.PI * 2.0;
        double pitch = (double)random.nextFloat() * java.lang.Math.PI - 1.5707963267948966;
        double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
        double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
        double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
        double vx = this.vx + Math.sin((double)yaw) * Math.cos((double)pitch) * xSpeed;
        double vy = this.vy + Math.sin((double)pitch) * ySpeed;
        double vz = this.vz + Math.cos((double)yaw) * Math.cos((double)pitch) * zSpeed;
        double yaw2 = (double)random.nextFloat() * java.lang.Math.PI * 2.0;
        double pitch2 = (double)random.nextFloat() * java.lang.Math.PI - 1.5707963267948966;
        double xDist = (double)random.nextFloat() * this.maxXDist;
        double yDist = (double)random.nextFloat() * this.maxYDist;
        double zDist = (double)random.nextFloat() * this.maxZDist;
        double dx = Math.sin((double)yaw2) * Math.cos((double)pitch2) * xDist;
        double dy = Math.sin((double)pitch2) * yDist;
        double dz = Math.cos((double)yaw2) * Math.cos((double)pitch2) * zDist;
        double fdx = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fdx;
        double fdy = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fdy;
        double fdz = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fdz;
        double fvx = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fvx;
        double fvy = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fvy;
        double fvz = (double)(random.nextFloat() * 2.0f - 1.0f) * this.fvz;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double xx = pos.m_7096_() + dx + fdx;
        double yy = pos.m_7098_() + dy + fdy;
        double zz = pos.m_7094_() + dz + fdz;
        if (!this.distanceSpawn || Math.sqrt((double)camera.m_90583_().m_82531_(xx, yy, zz)) <= this.distance) {
            level.m_6493_((ParticleOptions)this.options, this.force, xx, yy, zz, vx + fvx, vy + fvy, vz + fvz);
            for (ParticleBuilder builder : this.additionalBuilders) {
                level.m_6493_((ParticleOptions)builder.getParticleOptions(), builder.force, xx, yy, zz, vx + fvx, vy + fvy, vz + fvz);
            }
        }
        return this;
    }

    public ParticleBuilder repeat(Level level, Vec3 pos, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawn(level, pos);
        }
        return this;
    }

    public ParticleBuilder repeat(Level level, Vec3 pos, int n, float chance) {
        for (int i = 0; i < n; ++i) {
            if (!(random.nextFloat() < chance)) continue;
            this.spawn(level, pos);
        }
        return this;
    }

    public ParticleBuilder spawn(Level level, double x, double y, double z) {
        return this.spawn(level, new Vec3(x, y, z));
    }

    public ParticleBuilder repeat(Level level, double x, double y, double z, int n) {
        return this.repeat(level, new Vec3(x, y, z), n);
    }

    public ParticleBuilder repeat(Level level, double x, double y, double z, int n, float chance) {
        return this.repeat(level, new Vec3(x, y, z), n, chance);
    }

    public ParticleBuilder spawnLine(Level level, Vec3 from, Vec3 to) {
        Vec3 pos = from.m_165921_(to, (double)random.nextFloat());
        this.spawn(level, pos);
        return this;
    }

    public ParticleBuilder repeatLine(Level level, Vec3 from, Vec3 to, int n) {
        for (int i = 0; i < n; ++i) {
            this.spawnLine(level, from, to);
        }
        return this;
    }

    public ParticleBuilder repeatLine(Level level, Vec3 from, Vec3 to, int n, float chance) {
        for (int i = 0; i < n; ++i) {
            if (!(random.nextFloat() < chance)) continue;
            this.spawnLine(level, from, to);
        }
        return this;
    }

    public ParticleBuilder spawnVoxelShape(Level level, Vec3 pos, VoxelShape voxelShape, int n, float chance) {
        voxelShape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v = pos;
            Vec3 b = pos.m_82520_(x1, y1, z1);
            Vec3 e = pos.m_82520_(x2, y2, z2);
            this.repeatLine(level, b, v.m_82520_(x2, y1, z1), n, chance);
            this.repeatLine(level, b, v.m_82520_(x1, y2, z1), n, chance);
            this.repeatLine(level, b, v.m_82520_(x1, y1, z2), n, chance);
            this.repeatLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x2, y2, z1), n, chance);
            this.repeatLine(level, v.m_82520_(x1, y2, z1), v.m_82520_(x1, y2, z2), n, chance);
            this.repeatLine(level, e, v.m_82520_(x2, y2, z1), n, chance);
            this.repeatLine(level, e, v.m_82520_(x1, y2, z2), n, chance);
            this.repeatLine(level, e, v.m_82520_(x2, y1, z2), n, chance);
            this.repeatLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y1, z2), n, chance);
            this.repeatLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x2, y1, z2), n, chance);
            this.repeatLine(level, v.m_82520_(x2, y1, z1), v.m_82520_(x2, y2, z1), n, chance);
            this.repeatLine(level, v.m_82520_(x1, y1, z2), v.m_82520_(x1, y2, z2), n, chance);
        });
        return this;
    }

    public ParticleBuilder spawnVoxelShape(Level level, Vec3 pos, VoxelShape voxelShape, int n) {
        return this.spawnVoxelShape(level, pos, voxelShape, n, 1.0f);
    }

    public ParticleBuilder spawnVoxelShape(Level level, Vec3 pos, VoxelShape voxelShape) {
        return this.spawnVoxelShape(level, pos, voxelShape, 5, 1.0f);
    }

    public ParticleBuilder spawnVoxelShape(Level level, double x, double y, double z, VoxelShape voxelShape, int n, float chance) {
        return this.spawnVoxelShape(level, new Vec3(x, y, z), voxelShape, n, chance);
    }

    public ParticleBuilder spawnVoxelShape(Level level, double x, double y, double z, VoxelShape voxelShape, int n) {
        return this.spawnVoxelShape(level, new Vec3(x, y, z), voxelShape, n, 1.0f);
    }

    public ParticleBuilder spawnVoxelShape(Level level, double x, double y, double z, VoxelShape voxelShape) {
        return this.spawnVoxelShape(level, new Vec3(x, y, z), voxelShape, 5, 1.0f);
    }

    public ParticleBuilder spawnBoykisser(Level level, Vec3 pos, int xSize, int ySize, float size, float lineSize, float smallLineSize, float eyebrowsLineSize, float mouthLineSize, float blushLineSize) {
        for (int y = 0; y < ySize; ++y) {
            for (int x = 0; x < ySize; ++x) {
                if (!RenderUtil.boykisserPos((float)x / (float)xSize, (float)y / (float)ySize, lineSize, smallLineSize, eyebrowsLineSize, mouthLineSize, blushLineSize)) continue;
                this.spawn(level, pos.m_7096_() + (double)(((float)xSize / 2.0f - (float)x) * size), pos.m_7098_() - (double)(((float)ySize / 2.0f - (float)y) * size), pos.m_7094_());
            }
        }
        return this;
    }

    public ParticleBuilder spawnBoykisser(Level level, Vec3 pos, int xSize, int ySize, float size, ParticleBuilder blushBuilder, float lineSize, float smallLineSize, float eyebrowsLineSize, float mouthLineSize, float blushLineSize) {
        for (int y = 0; y < ySize; ++y) {
            for (int x = 0; x < ySize; ++x) {
                if (RenderUtil.boykisserBlushlessPos((float)x / (float)xSize, (float)y / (float)ySize, lineSize, smallLineSize, eyebrowsLineSize, mouthLineSize)) {
                    this.spawn(level, pos.m_7096_() + (double)(((float)xSize / 2.0f - (float)x) * size), pos.m_7098_() - (double)(((float)ySize / 2.0f - (float)y) * size), pos.m_7094_());
                }
                if (!RenderUtil.boykisserBlushPos((float)x / (float)xSize, (float)y / (float)ySize, blushLineSize)) continue;
                blushBuilder.spawn(level, pos.m_7096_() + (double)(((float)xSize / 2.0f - (float)x) * size), pos.m_7098_() - (double)(((float)ySize / 2.0f - (float)y) * size), pos.m_7094_());
            }
        }
        return this;
    }

    public static ParticleBuilder create(ParticleType<?> type) {
        return new ParticleBuilder(new GenericParticleOptions(type));
    }

    public static ParticleBuilder create(RegistryObject<?> type) {
        return new ParticleBuilder(new GenericParticleOptions((ParticleType)type.get()));
    }

    public static ParticleBuilder create(GenericParticleOptions options) {
        return new ParticleBuilder(options);
    }
}

