/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.behavior;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import mod.maxbogomol.fluffy_fur.client.particle.GenericParticle;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.SparkParticleBehaviorBuilder;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.component.ParticleBehaviorComponent;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.component.SparkParticleBehaviorComponent;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.client.render.RenderBuilder;
import net.minecraft.client.Camera;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class SparkParticleBehavior
extends ParticleBehavior {
    public ColorParticleData colorData;
    public GenericParticleData transparencyData;
    public GenericParticleData scaleData;
    public boolean secondColor;
    public Vec3 startPos;
    public Vec3 endPos;

    public SparkParticleBehavior(ColorParticleData colorData, GenericParticleData transparencyData, GenericParticleData scaleData, boolean secondColor, Vec3 startPos, Vec3 endPos, SpinParticleData xSpinData, SpinParticleData ySpinData, SpinParticleData zSpinData, float xOffset, float yOffset, float zOffset, boolean firstSide, boolean secondSide, boolean camera, boolean xRotCam, boolean yRotCam) {
        super(xSpinData, ySpinData, zSpinData, xOffset, yOffset, zOffset, firstSide, secondSide, camera, xRotCam, yRotCam);
        this.colorData = colorData;
        this.transparencyData = transparencyData;
        this.scaleData = scaleData;
        this.secondColor = secondColor;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    @Override
    public SparkParticleBehavior copy() {
        return new SparkParticleBehavior(this.colorData, this.transparencyData, this.scaleData, this.secondColor, this.startPos, this.endPos, this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }

    public static SparkParticleBehaviorBuilder create() {
        return new SparkParticleBehaviorBuilder(0.0f, 0.0f, 0.0f);
    }

    public static SparkParticleBehaviorBuilder create(float xOffset, float yOffset, float zOffset) {
        return new SparkParticleBehaviorBuilder((float)Math.toRadians(xOffset), (float)Math.toRadians(yOffset), (float)Math.toRadians(zOffset));
    }

    @Override
    public SparkParticleBehaviorComponent getComponent() {
        return new SparkParticleBehaviorComponent();
    }

    public SparkParticleBehaviorComponent getSparkComponent(GenericParticle particle) {
        ParticleBehaviorComponent particleBehaviorComponent = particle.behaviorComponent;
        if (particleBehaviorComponent instanceof SparkParticleBehaviorComponent) {
            SparkParticleBehaviorComponent behaviorComponent = (SparkParticleBehaviorComponent)particleBehaviorComponent;
            return behaviorComponent;
        }
        return this.getComponent();
    }

    @Override
    public void init(GenericParticle particle) {
        super.init(particle);
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        float r1 = GenericParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        component.st = GenericParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        component.mt = GenericParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        component.et = GenericParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        component.ss = GenericParticle.pickRandomValue(this.scaleData.startingValue, this.scaleData.rs1, this.scaleData.rs2);
        component.ms = GenericParticle.pickRandomValue(this.scaleData.middleValue, this.scaleData.rm1, this.scaleData.rm2);
        component.es = GenericParticle.pickRandomValue(this.scaleData.endingValue, this.scaleData.re1, this.scaleData.re2);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r1)), (int)(255.0f * Math.min(1.0f, g1)), (int)(255.0f * Math.min(1.0f, b1)), component.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r2)), (int)(255.0f * Math.min(1.0f, g2)), (int)(255.0f * Math.min(1.0f, b2)), component.hsv2);
    }

    public void pickColor(GenericParticle particle, float coeff) {
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        float h = Mth.m_14189_((float)coeff, (float)(360.0f * component.hsv1[0]), (float)(360.0f * component.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)coeff, (float)component.hsv1[1], (float)component.hsv2[1]);
        float v = Mth.m_14179_((float)coeff, (float)component.hsv1[2], (float)component.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.setColor(particle, r, g, b);
    }

    public void setColor(GenericParticle particle, float r, float g, float b) {
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        component.r = r;
        component.g = g;
        component.b = b;
    }

    @Override
    public void updateTraits(GenericParticle particle) {
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        component.xd = particle.f_107215_;
        component.yd = particle.f_107216_;
        component.zd = particle.f_107217_;
        this.pickColor(particle, this.colorData.colorCurveEasing.ease(this.colorData.getProgress(particle.f_107224_, particle.f_107225_), 0.0f, 1.0f, 1.0f));
        component.a = this.transparencyData.getValue(particle.f_107224_, particle.f_107225_, component.st, component.mt, component.et);
        component.size = this.scaleData.getValue(particle.f_107224_, particle.f_107225_, component.ss, component.ms, component.es);
    }

    @Override
    public void updateRenderTraits(GenericParticle particle, float partialTicks) {
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        float time = (float)particle.f_107224_ + partialTicks;
        this.pickColor(particle, this.colorData.colorCurveEasing.ease(this.colorData.getProgress(time, particle.f_107225_), 0.0f, 1.0f, 1.0f));
        component.a = this.transparencyData.getValue(time, particle.f_107225_, component.st, component.mt, component.et);
        component.size = this.scaleData.getValue(time, particle.f_107225_, component.ss, component.ms, component.es);
    }

    @Override
    public void render(GenericParticle particle, VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        if (particle.shouldRenderTraits) {
            this.updateRenderTraits(particle, partialTicks);
        }
        Vec3 pos = this.getPosition(particle, renderInfo, partialTicks);
        SparkParticleBehaviorComponent component = this.getSparkComponent(particle);
        float x = (float)Mth.m_14139_((double)partialTicks, (double)component.xd, (double)particle.f_107215_) * component.size;
        float y = (float)Mth.m_14139_((double)partialTicks, (double)component.yd, (double)particle.f_107216_) * component.size;
        float z = (float)Mth.m_14139_((double)partialTicks, (double)component.zd, (double)particle.f_107217_) * component.size;
        float width = particle.m_5902_(partialTicks);
        Vec3 from = this.getStartPosition(particle, x, y, z, pos);
        Vec3 to = this.getEndPosition(particle, x, y, z, pos);
        RenderBuilder builder = RenderBuilder.create().setFormat(DefaultVertexFormat.f_85813_).setVertexConsumer(vertexConsumer).setUV(particle.m_5970_(), particle.m_5951_(), particle.m_5952_(), particle.m_5950_()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).setLight(particle.m_6355_(partialTicks));
        if (this.secondColor) {
            builder.setSecondColorRaw(component.r, component.g, component.b).setSecondAlpha(component.a);
        }
        builder.renderBeam(null, from, to, width, Vec3.f_82478_);
    }

    public Vec3 getStartPosition(GenericParticle particle, float x, float y, float z, Vec3 pos) {
        if (this.startPos == null) {
            return new Vec3((double)(-x), (double)(-y), (double)(-z)).m_82549_(pos);
        }
        return this.startPos.m_82549_(pos);
    }

    public Vec3 getEndPosition(GenericParticle particle, float x, float y, float z, Vec3 pos) {
        if (this.endPos == null) {
            return new Vec3((double)x, (double)y, (double)z).m_82549_(pos);
        }
        return this.endPos.m_82549_(pos);
    }
}

