/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.behavior;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Function;
import mod.maxbogomol.fluffy_fur.client.particle.GenericParticle;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ICustomBehaviorParticleRender;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.TrailParticleBehaviorBuilder;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.component.ParticleBehaviorComponent;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.component.TrailParticleBehaviorComponent;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.client.render.RenderBuilder;
import mod.maxbogomol.fluffy_fur.client.render.trail.TrailPoint;
import mod.maxbogomol.fluffy_fur.client.render.trail.TrailPointBuilder;
import mod.maxbogomol.fluffy_fur.registry.client.FluffyFurParticles;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TrailParticleBehavior
extends ParticleBehavior
implements ICustomBehaviorParticleRender {
    public ColorParticleData colorData;
    public GenericParticleData transparencyData;
    public boolean secondColor;
    public int trailSize;
    Function<Float, Float> widthFunc;

    public TrailParticleBehavior(ColorParticleData colorData, GenericParticleData transparencyData, boolean secondColor, int trailSize, Function<Float, Float> widthFunc, SpinParticleData xSpinData, SpinParticleData ySpinData, SpinParticleData zSpinData, float xOffset, float yOffset, float zOffset, boolean firstSide, boolean secondSide, boolean camera, boolean xRotCam, boolean yRotCam) {
        super(xSpinData, ySpinData, zSpinData, xOffset, yOffset, zOffset, firstSide, secondSide, camera, xRotCam, yRotCam);
        this.colorData = colorData;
        this.transparencyData = transparencyData;
        this.secondColor = secondColor;
        this.trailSize = trailSize;
        this.widthFunc = widthFunc;
    }

    @Override
    public TrailParticleBehavior copy() {
        return new TrailParticleBehavior(this.colorData, this.transparencyData, this.secondColor, this.trailSize, this.widthFunc, this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }

    public static TrailParticleBehaviorBuilder create() {
        return new TrailParticleBehaviorBuilder(0.0f, 0.0f, 0.0f);
    }

    public static TrailParticleBehaviorBuilder create(float xOffset, float yOffset, float zOffset) {
        return new TrailParticleBehaviorBuilder((float)Math.toRadians(xOffset), (float)Math.toRadians(yOffset), (float)Math.toRadians(zOffset));
    }

    @Override
    public TrailParticleBehaviorComponent getComponent() {
        return new TrailParticleBehaviorComponent();
    }

    public TrailParticleBehaviorComponent getTrailComponent(GenericParticle particle) {
        ParticleBehaviorComponent particleBehaviorComponent = particle.behaviorComponent;
        if (particleBehaviorComponent instanceof TrailParticleBehaviorComponent) {
            TrailParticleBehaviorComponent behaviorComponent = (TrailParticleBehaviorComponent)particleBehaviorComponent;
            return behaviorComponent;
        }
        return this.getComponent();
    }

    @Override
    public void init(GenericParticle particle) {
        super.init(particle);
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.trailPointBuilder = TrailPointBuilder.create(this.trailSize);
        float r1 = GenericParticle.pickRandomValue(this.colorData.r1, this.colorData.rr11, this.colorData.rr12);
        float g1 = GenericParticle.pickRandomValue(this.colorData.g1, this.colorData.rg11, this.colorData.rg12);
        float b1 = GenericParticle.pickRandomValue(this.colorData.b1, this.colorData.rb11, this.colorData.rb12);
        float r2 = GenericParticle.pickRandomValue(this.colorData.r2, this.colorData.rr21, this.colorData.rr22);
        float g2 = GenericParticle.pickRandomValue(this.colorData.g2, this.colorData.rg21, this.colorData.rg22);
        float b2 = GenericParticle.pickRandomValue(this.colorData.b2, this.colorData.rb21, this.colorData.rb21);
        component.st = GenericParticle.pickRandomValue(this.transparencyData.startingValue, this.transparencyData.rs1, this.transparencyData.rs2);
        component.mt = GenericParticle.pickRandomValue(this.transparencyData.middleValue, this.transparencyData.rm1, this.transparencyData.rm2);
        component.et = GenericParticle.pickRandomValue(this.transparencyData.endingValue, this.transparencyData.re1, this.transparencyData.re2);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r1)), (int)(255.0f * Math.min(1.0f, g1)), (int)(255.0f * Math.min(1.0f, b1)), component.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, r2)), (int)(255.0f * Math.min(1.0f, g2)), (int)(255.0f * Math.min(1.0f, b2)), component.hsv2);
    }

    public void pickColor(GenericParticle particle, float coeff) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        float h = Mth.m_14189_((float)coeff, (float)(360.0f * component.hsv1[0]), (float)(360.0f * component.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)coeff, (float)component.hsv1[1], (float)component.hsv2[1]);
        float v = Mth.m_14179_((float)coeff, (float)component.hsv1[2], (float)component.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.setColor(particle, r, g, b);
    }

    public void setColor(GenericParticle particle, float r, float g, float b) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.r = r;
        component.g = g;
        component.b = b;
    }

    @Override
    public void updateTraits(GenericParticle particle) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        component.trailPointBuilder.addTrailPoint(particle.getPosition());
        component.trailPointBuilder.tickTrailPoints();
        this.pickColor(particle, this.colorData.colorCurveEasing.ease(this.colorData.getProgress(particle.f_107224_, particle.f_107225_), 0.0f, 1.0f, 1.0f));
        component.a = this.transparencyData.getValue(particle.f_107224_, particle.f_107225_, component.st, component.mt, component.et);
    }

    @Override
    public void updateRenderTraits(GenericParticle particle, float partialTicks) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        this.pickColor(particle, this.colorData.colorCurveEasing.ease(this.colorData.getProgress(particle.f_107224_, particle.f_107225_), 0.0f, 1.0f, 1.0f));
        component.a = this.transparencyData.getValue(particle.f_107224_, particle.f_107225_, component.st, component.mt, component.et);
    }

    @Override
    public void render(GenericParticle particle, VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        if (particle.shouldRenderTraits) {
            this.updateRenderTraits(particle, partialTicks);
        }
        FluffyFurParticles.addBehaviorParticleList(particle, this);
    }

    @Override
    public void render(GenericParticle particle, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        TrailParticleBehaviorComponent component = this.getTrailComponent(particle);
        ArrayList<TrailPoint> trail = new ArrayList<TrailPoint>(component.trailPointBuilder.getTrailPoints());
        if (trail.size() > 2 && particle.getAge() > component.trailPointBuilder.trailLength.get()) {
            TrailPoint position = (TrailPoint)trail.get(0);
            TrailPoint nextPosition = (TrailPoint)trail.get(1);
            float x = (float)Mth.m_14139_((double)partialTicks, (double)position.getPosition().f_82479_, (double)nextPosition.getPosition().f_82479_);
            float y = (float)Mth.m_14139_((double)partialTicks, (double)position.getPosition().f_82480_, (double)nextPosition.getPosition().f_82480_);
            float z = (float)Mth.m_14139_((double)partialTicks, (double)position.getPosition().f_82481_, (double)nextPosition.getPosition().f_82481_);
            trail.set(0, new TrailPoint(new Vec3((double)x, (double)y, (double)z)));
        }
        float x = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107209_, (double)particle.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107210_, (double)particle.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTicks, (double)particle.f_107211_, (double)particle.f_107214_);
        if (trail.size() > 0) {
            trail.set(trail.size() - 1, new TrailPoint(new Vec3((double)x, (double)y, (double)z)));
        }
        RenderBuilder builder = RenderBuilder.create();
        if (particle.bufferSource != null) {
            builder.replaceBufferSource(particle.bufferSource);
        }
        builder.setRenderType(particle.renderType);
        if (particle.format != null) {
            builder.setFormat(particle.format);
        }
        builder.setSided(this.firstSide, this.secondSide).setUV(particle.m_5970_(), particle.m_5951_(), particle.m_5952_(), particle.m_5950_()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).setLight(particle.m_6355_(partialTicks));
        if (this.secondColor) {
            builder.setSecondColorRaw(component.r, component.g, component.b).setSecondAlpha(component.a);
        }
        builder.renderTrail(poseStack, trail, f -> Float.valueOf(this.widthFunc.apply((Float)f).floatValue() * (particle.getSize() / 2.0f)));
    }
}

