/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.behavior;

import java.util.function.Function;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.ParticleBehaviorBuilder;
import mod.maxbogomol.fluffy_fur.client.particle.behavior.TrailParticleBehavior;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.options.GenericParticleOptions;

public class TrailParticleBehaviorBuilder
extends ParticleBehaviorBuilder {
    public ColorParticleData colorData = GenericParticleOptions.DEFAULT_COLOR;
    public GenericParticleData transparencyData = GenericParticleOptions.DEFAULT_GENERIC;
    public boolean secondColor = false;
    public int trailSize = 10;
    public Function<Float, Float> widthFunc = f -> f;

    protected TrailParticleBehaviorBuilder(float xOffset, float yOffset, float zOffset) {
        super(xOffset, yOffset, zOffset);
    }

    @Override
    public TrailParticleBehaviorBuilder setXSpinData(SpinParticleData xSpinData) {
        this.xSpinData = xSpinData;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder setYSpinData(SpinParticleData ySpinData) {
        this.ySpinData = ySpinData;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder setZSpinData(SpinParticleData zSpinData) {
        this.zSpinData = zSpinData;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder enableSided() {
        return this.setSided(true);
    }

    @Override
    public TrailParticleBehaviorBuilder disableSided() {
        return this.setSided(false);
    }

    @Override
    public TrailParticleBehaviorBuilder setSided(boolean side) {
        return this.setFirstSide(side).setSecondSide(side);
    }

    @Override
    public TrailParticleBehaviorBuilder enableFirstSide() {
        return this.setFirstSide(true);
    }

    @Override
    public TrailParticleBehaviorBuilder disableFirstSide() {
        return this.setFirstSide(false);
    }

    @Override
    public TrailParticleBehaviorBuilder setFirstSide(boolean side) {
        this.firstSide = side;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder enableSecondSide() {
        return this.setSecondSide(true);
    }

    @Override
    public TrailParticleBehaviorBuilder disableSecondSide() {
        return this.setSecondSide(false);
    }

    @Override
    public TrailParticleBehaviorBuilder setSecondSide(boolean side) {
        this.secondSide = side;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder setSide(boolean firstSide, boolean secondSide) {
        return this.setFirstSide(firstSide).setSecondSide(secondSide);
    }

    @Override
    public TrailParticleBehaviorBuilder enableCamera() {
        return this.setCamera(true);
    }

    @Override
    public TrailParticleBehaviorBuilder disableCamera() {
        return this.setCamera(false);
    }

    @Override
    public TrailParticleBehaviorBuilder setCamera(boolean camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public TrailParticleBehaviorBuilder setCameraRotation(boolean xRotCam, boolean yRotCam) {
        this.xRotCam = xRotCam;
        this.yRotCam = yRotCam;
        return this;
    }

    public TrailParticleBehaviorBuilder setColorData(ColorParticleData colorData) {
        this.colorData = colorData;
        return this;
    }

    public TrailParticleBehaviorBuilder setTransparencyData(GenericParticleData transparencyData) {
        this.transparencyData = transparencyData;
        return this;
    }

    public TrailParticleBehaviorBuilder enableSecondColor() {
        return this.setSecondColor(true);
    }

    public TrailParticleBehaviorBuilder disableSecondColor() {
        return this.setSecondColor(false);
    }

    public TrailParticleBehaviorBuilder setSecondColor(boolean secondColor) {
        this.secondColor = secondColor;
        return this;
    }

    public TrailParticleBehaviorBuilder setTrailSize(int trailSize) {
        this.trailSize = trailSize;
        return this;
    }

    public TrailParticleBehaviorBuilder setWidthFunction(Function<Float, Float> widthFunc) {
        this.widthFunc = widthFunc;
        return this;
    }

    @Override
    public ParticleBehavior build() {
        return new TrailParticleBehavior(this.colorData, this.transparencyData, this.secondColor, this.trailSize, this.widthFunc, this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }
}

