/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.data;

import java.awt.Color;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleDataBuilder;
import mod.maxbogomol.fluffy_fur.common.easing.Easing;
import net.minecraft.util.Mth;

public class ColorParticleData {
    public final float r1;
    public final float g1;
    public final float b1;
    public final float r2;
    public final float g2;
    public final float b2;
    public final float rr11;
    public final float rr12;
    public final float rb11;
    public final float rb12;
    public final float rg11;
    public final float rg12;
    public final float rr21;
    public final float rr22;
    public final float rb21;
    public final float rb22;
    public final float rg21;
    public final float rg22;
    public final float colorCoefficient;
    public final Easing colorCurveEasing;
    public float coefficientMultiplier = 1.0f;

    protected ColorParticleData(float r1, float g1, float b1, float r2, float g2, float b2, float rr11, float rr12, float rb11, float rb12, float rg11, float rg12, float rr21, float rr22, float rb21, float rb22, float rg21, float rg22, float colorCoefficient, Easing colorCurveEasing) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.rr11 = rr11;
        this.rr12 = rr12;
        this.rb11 = rb11;
        this.rb12 = rb12;
        this.rg11 = rg11;
        this.rg12 = rg12;
        this.rr21 = rr21;
        this.rr22 = rr22;
        this.rb21 = rb21;
        this.rb22 = rb22;
        this.rg21 = rg21;
        this.rg22 = rg22;
        this.colorCoefficient = colorCoefficient;
        this.colorCurveEasing = colorCurveEasing;
    }

    public ColorParticleData multiplyCoefficient(float coefficientMultiplier) {
        this.coefficientMultiplier *= coefficientMultiplier;
        return this;
    }

    public ColorParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        this.coefficientMultiplier = coefficientMultiplier;
        return this;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.m_14036_((float)(age * this.colorCoefficient * this.coefficientMultiplier / lifetime), (float)0.0f, (float)1.0f);
    }

    public ColorParticleDataBuilder copy() {
        return ColorParticleData.create(this.r1, this.g1, this.b1, this.r2, this.g2, this.b2).setCoefficient(this.colorCoefficient).setEasing(this.colorCurveEasing);
    }

    public static ColorParticleDataBuilder create(float r1, float g1, float b1, float r2, float g2, float b2) {
        return new ColorParticleDataBuilder(r1, g1, b1, r2, g2, b2);
    }

    public static ColorParticleDataBuilder create(float r, float g, float b) {
        return new ColorParticleDataBuilder(r, g, b, r, g, b);
    }

    public static ColorParticleDataBuilder create(Color start, Color end) {
        return ColorParticleData.create((float)start.getRed() / 255.0f, (float)start.getGreen() / 255.0f, (float)start.getBlue() / 255.0f, (float)end.getRed() / 255.0f, (float)end.getGreen() / 255.0f, (float)end.getBlue() / 255.0f);
    }

    public static ColorParticleDataBuilder create(Color color) {
        return ColorParticleData.create((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public static ColorParticleDataBuilder create() {
        return ColorParticleData.create(0.0f, 0.0f, 0.0f);
    }
}

