/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.data;

import java.awt.Color;
import mod.maxbogomol.fluffy_fur.client.particle.data.ColorParticleData;
import mod.maxbogomol.fluffy_fur.common.easing.Easing;

public class ColorParticleDataBuilder {
    protected float r1;
    protected float g1;
    protected float b1;
    protected float r2;
    protected float g2;
    protected float b2;
    protected float rr11 = -1.0f;
    protected float rr12 = -1.0f;
    protected float rb11 = -1.0f;
    protected float rb12 = -1.0f;
    protected float rg11 = -1.0f;
    protected float rg12 = -1.0f;
    protected float rr21 = -1.0f;
    protected float rr22 = -1.0f;
    protected float rb21 = -1.0f;
    protected float rb22 = -1.0f;
    protected float rg21 = -1.0f;
    protected float rg22 = -1.0f;
    protected float colorCoefficient = 1.0f;
    protected Easing colorCurveEasing = Easing.LINEAR;

    protected ColorParticleDataBuilder(float r1, float g1, float b1, float r2, float g2, float b2) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
    }

    public ColorParticleDataBuilder setCoefficient(float coefficient) {
        this.colorCoefficient = coefficient;
        return this;
    }

    public ColorParticleDataBuilder setEasing(Easing easing) {
        this.colorCurveEasing = easing;
        return this;
    }

    public ColorParticleDataBuilder setRandomColor(float rr11, float rr12, float rb11, float rb12, float rg11, float rg12, float rr21, float rr22, float rb21, float rb22, float rg21, float rg22) {
        this.rr11 = rr11;
        this.rr12 = rr12;
        this.rb11 = rb11;
        this.rb12 = rb12;
        this.rg11 = rg11;
        this.rg12 = rg12;
        this.rr21 = rr21;
        this.rr22 = rr22;
        this.rb21 = rb21;
        this.rb22 = rb22;
        this.rg21 = rg21;
        this.rg22 = rg22;
        return this;
    }

    public ColorParticleDataBuilder setRandomColor(float rr11, float rr12, float rb11, float rb12, float rg11, float rg12) {
        this.rr11 = rr11;
        this.rr12 = rr12;
        this.rb11 = rb11;
        this.rb12 = rb12;
        this.rg11 = rg11;
        this.rg12 = rg12;
        return this;
    }

    public ColorParticleDataBuilder setRandomColor(Color start1, Color start2, Color end1, Color end2) {
        this.setRandomColor((float)start1.getRed() / 255.0f, (float)start2.getRed() / 255.0f, (float)start1.getGreen() / 255.0f, (float)start2.getGreen() / 255.0f, (float)start1.getBlue() / 255.0f, (float)start2.getBlue() / 255.0f, (float)end1.getRed() / 255.0f, (float)end2.getRed() / 255.0f, (float)end1.getGreen() / 255.0f, (float)end2.getGreen() / 255.0f, (float)end1.getBlue() / 255.0f, (float)end2.getBlue() / 255.0f);
        return this;
    }

    public ColorParticleDataBuilder setRandomColor(Color start1, Color start2) {
        this.setRandomColor((float)start1.getRed() / 255.0f, (float)start2.getRed() / 255.0f, (float)start1.getGreen() / 255.0f, (float)start2.getGreen() / 255.0f, (float)start1.getBlue() / 255.0f, (float)start2.getBlue() / 255.0f);
        return this;
    }

    public ColorParticleDataBuilder setRandomColor() {
        this.setRandomColor(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        return this;
    }

    public ColorParticleDataBuilder setRandomColorFlat() {
        this.setRandomColor(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        return this;
    }

    public ColorParticleData build() {
        return new ColorParticleData(this.r1, this.g1, this.b1, this.r2, this.g2, this.b2, this.rr11, this.rr12, this.rb11, this.rb12, this.rg11, this.rg12, this.rr21, this.rr22, this.rb21, this.rb22, this.rg21, this.rg22, this.colorCoefficient, this.colorCurveEasing);
    }
}

