/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.data;

import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleData;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleDataBuilder;
import mod.maxbogomol.fluffy_fur.common.easing.Easing;
import net.minecraft.util.RandomSource;

public class SpinParticleData
extends GenericParticleData {
    public final float spinOffset;
    public final float rsp1;
    public final float rsp2;
    public final float rso1;
    public final float rso2;

    protected SpinParticleData(float spinOffset, float rsp1, float rsp2, float rso1, float rso2, float startingValue, float middleValue, float endingValue, float rs1, float rs2, float rm1, float rm2, float re1, float re2, float coefficient, Easing startToMiddleEasing, Easing middleToEndEasing) {
        super(startingValue, middleValue, endingValue, rs1, rs2, rm1, rm2, re1, re2, coefficient, startToMiddleEasing, middleToEndEasing);
        this.spinOffset = spinOffset;
        this.rsp1 = rsp1;
        this.rsp2 = rsp2;
        this.rso1 = rso1;
        this.rso2 = rso2;
    }

    @Override
    public SpinParticleData copy() {
        return new SpinParticleData(this.spinOffset, this.rsp1, this.rsp2, this.rso1, this.rso2, this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing).overrideValueMultiplier(this.valueMultiplier).overrideCoefficientMultiplier(this.coefficientMultiplier);
    }

    @Override
    public SpinParticleData bake() {
        return new SpinParticleData(this.spinOffset, this.rsp1, this.rsp2, this.rso1, this.rso2, this.startingValue * this.valueMultiplier, this.middleValue * this.valueMultiplier, this.endingValue * this.valueMultiplier, this.rs1 * this.valueMultiplier, this.rs2 * this.valueMultiplier, this.rm1 * this.valueMultiplier, this.rm2 * this.valueMultiplier, this.re1 * this.valueMultiplier, this.re2 * this.valueMultiplier, this.coefficient * this.coefficientMultiplier, this.startToMiddleEasing, this.middleToEndEasing);
    }

    @Override
    public SpinParticleData overrideValueMultiplier(float valueMultiplier) {
        return (SpinParticleData)super.overrideValueMultiplier(valueMultiplier);
    }

    @Override
    public SpinParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        return (SpinParticleData)super.overrideCoefficientMultiplier(coefficientMultiplier);
    }

    public static SpinParticleDataBuilder create() {
        return new SpinParticleDataBuilder(0.0f, 0.0f, 0.0f);
    }

    public static SpinParticleDataBuilder create(float value) {
        return new SpinParticleDataBuilder(value, value, -1.0f);
    }

    public static SpinParticleDataBuilder create(float startingValue, float endingValue) {
        return new SpinParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static SpinParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new SpinParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static SpinParticleDataBuilder createRandomDirection(RandomSource random, float value) {
        return new SpinParticleDataBuilder(value *= random.m_188499_() ? 1.0f : -1.0f, value, -1.0f);
    }

    public static SpinParticleDataBuilder createRandomDirection(RandomSource random, float startingValue, float endingValue) {
        int direction = random.m_188499_() ? 1 : -1;
        return new SpinParticleDataBuilder(startingValue *= (float)direction, endingValue *= (float)direction, -1.0f);
    }

    public static SpinParticleDataBuilder createRandomDirection(RandomSource random, float startingValue, float middleValue, float endingValue) {
        int direction = random.m_188499_() ? 1 : -1;
        return new SpinParticleDataBuilder(startingValue *= (float)direction, middleValue *= (float)direction, endingValue *= (float)direction);
    }
}

