/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.data;

import java.util.Random;
import mod.maxbogomol.fluffy_fur.client.particle.data.GenericParticleDataBuilder;
import mod.maxbogomol.fluffy_fur.client.particle.data.SpinParticleData;
import mod.maxbogomol.fluffy_fur.common.easing.Easing;
import net.minecraft.util.RandomSource;

public class SpinParticleDataBuilder
extends GenericParticleDataBuilder {
    protected float spinOffset;
    protected float rsp1 = 0.0f;
    protected float rsp2 = 0.0f;
    protected float rso1 = 0.0f;
    protected float rso2 = 0.0f;
    public static final Random random = new Random();

    protected SpinParticleDataBuilder(float startingValue, float middleValue, float endingValue) {
        super(startingValue, middleValue, endingValue);
    }

    public SpinParticleDataBuilder setSpinOffset(float spinOffset) {
        this.spinOffset = spinOffset;
        return this;
    }

    public SpinParticleDataBuilder randomSpinOffset(RandomSource random) {
        this.spinOffset = random.m_188501_() * 6.28f;
        return this;
    }

    public SpinParticleDataBuilder setSpinOffsetDegrees(float spinOffset) {
        this.spinOffset = (float)Math.toRadians(spinOffset);
        return this;
    }

    public SpinParticleDataBuilder randomOffset() {
        this.rso2 = 6.28f;
        return this;
    }

    public SpinParticleDataBuilder randomOffset(float spinOffset) {
        this.rso2 = spinOffset;
        return this;
    }

    public SpinParticleDataBuilder randomOffset(float spinOffset1, float spinOffset2) {
        this.rso1 = spinOffset1;
        this.rso2 = spinOffset2;
        return this;
    }

    public SpinParticleDataBuilder randomOffsetDegrees(float spinOffset) {
        this.rso2 = (float)Math.toRadians(spinOffset);
        return this;
    }

    public SpinParticleDataBuilder randomOffsetDegrees(float spinOffset1, float spinOffset2) {
        this.rso1 = (float)Math.toRadians(spinOffset1);
        this.rso2 = (float)Math.toRadians(spinOffset2);
        return this;
    }

    public SpinParticleDataBuilder randomSpin(float spin) {
        this.rsp2 = spin;
        return this;
    }

    public SpinParticleDataBuilder randomSpin(float spin1, float spin2) {
        this.rsp1 = spin1;
        this.rsp2 = spin2;
        return this;
    }

    public SpinParticleDataBuilder randomSpinDegrees(float spin) {
        this.rsp2 = (float)Math.toRadians(spin);
        return this;
    }

    public SpinParticleDataBuilder randomSpinDegrees(float spin1, float spin2) {
        this.rsp1 = (float)Math.toRadians(spin1);
        this.rsp2 = (float)Math.toRadians(spin2);
        return this;
    }

    @Override
    public SpinParticleDataBuilder setCoefficient(float coefficient) {
        return (SpinParticleDataBuilder)super.setCoefficient(coefficient);
    }

    @Override
    public SpinParticleDataBuilder setEasing(Easing easing) {
        return (SpinParticleDataBuilder)super.setEasing(easing);
    }

    @Override
    public SpinParticleDataBuilder setEasing(Easing easing, Easing middleToEndEasing) {
        return (SpinParticleDataBuilder)super.setEasing(easing, middleToEndEasing);
    }

    @Override
    public SpinParticleData build() {
        return new SpinParticleData(this.spinOffset, this.rsp1, this.rsp2, this.rso1, this.rso2, this.startingValue, this.middleValue, this.endingValue, this.rs1, this.rs2, this.rm1, this.rm2, this.re1, this.re2, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing);
    }
}

