/*
 * Decompiled with CFR 0.152.
 */
package mod.maxbogomol.fluffy_fur.client.particle.data;

import mod.maxbogomol.fluffy_fur.client.particle.GenericParticle;
import net.minecraft.client.particle.SpriteSet;

public class SpriteParticleData {
    public static final SpriteParticleData RANDOM = new Random();
    public static final SpriteParticleData FIRST = new First();
    public static final SpriteParticleData LAST = new Last();
    public static final SpriteParticleData WITH_AGE = new WithAge();
    public static final SpriteParticleData CRUMBS_RANDOM = new CrumbsRandom(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_FIRST = new CrumbsFirst(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LAST = new CrumbsLast(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_WITH_AGE = new CrumbsWithAge(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_RANDOM = new CrumbsRandom(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_FIRST = new CrumbsFirst(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_LAST = new CrumbsLast(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_WITH_AGE = new CrumbsWithAge(1.0f, 1.0f);

    public void init(GenericParticle particle) {
    }

    public void tick(GenericParticle particle) {
    }

    public void renderTick(GenericParticle particle, float partialTicks) {
    }

    public float getU0(GenericParticle particle) {
        return particle.f_108321_.m_118409_();
    }

    public float getU1(GenericParticle particle) {
        return particle.f_108321_.m_118410_();
    }

    public float getV0(GenericParticle particle) {
        return particle.f_108321_.m_118411_();
    }

    public float getV1(GenericParticle particle) {
        return particle.f_108321_.m_118412_();
    }

    public static class Random
    extends SpriteParticleData {
        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.m_108335_((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class First
    extends SpriteParticleData {
        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class Last
    extends SpriteParticleData {
        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.f_107406_.size() - 1);
            }
        }
    }

    public static class WithAge
    extends SpriteParticleData {
        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.f_107224_ * particle.spriteSet.f_107406_.size() / particle.f_107225_);
            }
        }
    }

    public static class CrumbsRandom
    extends Crumbs {
        public CrumbsRandom(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.m_108335_((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class CrumbsFirst
    extends Crumbs {
        public CrumbsFirst(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class CrumbsLast
    extends Crumbs {
        public CrumbsLast(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.f_107406_.size() - 1);
            }
        }
    }

    public static class CrumbsWithAge
    extends Crumbs {
        public CrumbsWithAge(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.f_107224_ * particle.spriteSet.f_107406_.size() / particle.f_107225_);
            }
        }
    }

    public static class CrumbsValue
    extends Crumbs {
        public int value;

        public CrumbsValue(int value, float offset, float size) {
            super(offset, size);
            this.value = value;
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.f_107406_.size()) {
                particle.pickSprite(this.value);
            }
        }
    }

    public static class Crumbs
    extends SpriteParticleData {
        public float offset;
        public float size;

        public Crumbs(float offset, float size) {
            this.offset = offset;
            this.size = size;
        }

        @Override
        public float getU0(GenericParticle particle) {
            return particle.f_108321_.m_118409_() + (particle.f_108321_.m_118410_() - particle.f_108321_.m_118409_()) * ((particle.uo * this.offset + this.size) / (this.offset + this.size));
        }

        @Override
        public float getU1(GenericParticle particle) {
            return particle.f_108321_.m_118409_() + (particle.f_108321_.m_118410_() - particle.f_108321_.m_118409_()) * (particle.uo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV0(GenericParticle particle) {
            return particle.f_108321_.m_118411_() + (particle.f_108321_.m_118412_() - particle.f_108321_.m_118411_()) * (particle.vo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV1(GenericParticle particle) {
            return particle.f_108321_.m_118411_() + (particle.f_108321_.m_118412_() - particle.f_108321_.m_118411_()) * ((particle.vo * this.offset + this.size) / (this.offset + this.size));
        }
    }

    public static class Value
    extends SpriteParticleData {
        public int value;

        public Value(int value) {
            this.value = value;
        }

        @Override
        public void init(GenericParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.f_107406_.size()) {
                particle.pickSprite(this.value);
            }
        }
    }
}

